/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.PSBridgeContext;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.fop.svg.SVGEventProducer;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.w3c.dom.Document;

public class PSImageHandlerSVG
implements ImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{BatikImageFlavors.SVG_DOM};

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        GraphicsNode graphicsNode;
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageXMLDOM imageXMLDOM = (ImageXMLDOM)image;
        boolean bl = false;
        SVGUserAgent sVGUserAgent = new SVGUserAgent(renderingContext.getUserAgent(), new AffineTransform());
        PSGraphics2D pSGraphics2D = new PSGraphics2D(bl, pSGenerator);
        pSGraphics2D.setGraphicContext(new GraphicContext());
        PSBridgeContext pSBridgeContext = new PSBridgeContext((UserAgent)sVGUserAgent, bl ? null : pSRenderingContext.getFontInfo(), renderingContext.getUserAgent().getFactory().getImageManager(), renderingContext.getUserAgent().getImageSessionContext());
        Document document = BatikUtil.cloneSVGDocument(imageXMLDOM.getDocument());
        try {
            GVTBuilder gVTBuilder = new GVTBuilder();
            graphicsNode = gVTBuilder.build((BridgeContext)pSBridgeContext, document);
        }
        catch (Exception exception) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(renderingContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgNotBuilt(this, exception, image.getInfo().getOriginalURI());
            return;
        }
        float f = (float)pSBridgeContext.getDocumentSize().getWidth() * 1000.0f;
        float f2 = (float)pSBridgeContext.getDocumentSize().getHeight() * 1000.0f;
        float f3 = (float)rectangle.width / f;
        float f4 = (float)rectangle.height / f2;
        pSBridgeContext = null;
        pSGenerator.commentln("%FOPBeginSVG");
        pSGenerator.saveGraphicsState();
        pSGenerator.concatMatrix((double)f3, 0.0, 0.0, (double)f4, rectangle.getMinX() / 1000.0, rectangle.getMinY() / 1000.0);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rectangle.getMinX(), rectangle.getMinY());
        pSGenerator.getCurrentState().concatMatrix(affineTransform);
        try {
            graphicsNode.paint((Graphics2D)pSGraphics2D);
        }
        catch (Exception exception) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(renderingContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgRenderingError(this, exception, image.getInfo().getOriginalURI());
        }
        pSGenerator.restoreGraphicsState();
        pSGenerator.commentln("%FOPEndSVG");
    }

    public int getPriority() {
        return 400;
    }

    public Class getSupportedImageClass() {
        return ImageXMLDOM.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        if (renderingContext instanceof PSRenderingContext) {
            PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
            return !pSRenderingContext.isCreateForms() && (image == null || image instanceof ImageXMLDOM && image.getFlavor().isCompatible((ImageFlavor)BatikImageFlavors.SVG_DOM));
        }
        return false;
    }
}

