/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.color.ICC_Profile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.extensions.xmp.XMPMetadata;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEmbeddedFile;
import org.apache.fop.pdf.PDFEmbeddedFiles;
import org.apache.fop.pdf.PDFEncryptionManager;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFNames;
import org.apache.fop.pdf.PDFNumsArray;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPageLabels;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFXMode;
import org.apache.fop.pdf.Version;
import org.apache.fop.pdf.VersionController;
import org.apache.fop.render.pdf.PDFConfigurationConstants;
import org.apache.fop.render.pdf.extensions.PDFEmbeddedFileExtensionAttachment;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicAdapter;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicSchema;

class PDFRenderingUtil
implements PDFConfigurationConstants {
    private static Log log = LogFactory.getLog(PDFRenderingUtil.class);
    private FOUserAgent userAgent;
    protected PDFDocument pdfDoc;
    protected PDFAMode pdfAMode = PDFAMode.DISABLED;
    protected PDFXMode pdfXMode = PDFXMode.DISABLED;
    protected PDFEncryptionParams encryptionParams;
    protected Map filterMap;
    protected PDFICCStream outputProfile;
    protected PDFICCBasedColorSpace sRGBColorSpace;
    protected boolean disableSRGBColorSpace = false;
    protected String outputProfileURI;
    protected Version maxPDFVersion;

    PDFRenderingUtil(FOUserAgent fOUserAgent) {
        this.userAgent = fOUserAgent;
        this.initialize();
    }

    private static boolean booleanValueOf(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new IllegalArgumentException("Boolean or \"true\" or \"false\" expected.");
    }

    private void initialize() {
        Object v;
        String string;
        Object v2;
        Object v3;
        Object v4;
        Object v5;
        Object v6;
        Object v7;
        Object v8;
        Object v9;
        String string2;
        String string3;
        PDFEncryptionParams pDFEncryptionParams = (PDFEncryptionParams)this.userAgent.getRendererOptions().get("encryption-params");
        if (pDFEncryptionParams != null) {
            this.encryptionParams = pDFEncryptionParams;
        }
        if ((string3 = (String)this.userAgent.getRendererOptions().get("user-password")) != null) {
            this.getEncryptionParams().setUserPassword(string3);
        }
        if ((string2 = (String)this.userAgent.getRendererOptions().get("owner-password")) != null) {
            this.getEncryptionParams().setOwnerPassword(string2);
        }
        if ((v9 = this.userAgent.getRendererOptions().get("noprint")) != null) {
            this.getEncryptionParams().setAllowPrint(!PDFRenderingUtil.booleanValueOf(v9));
        }
        if ((v8 = this.userAgent.getRendererOptions().get("nocopy")) != null) {
            this.getEncryptionParams().setAllowCopyContent(!PDFRenderingUtil.booleanValueOf(v8));
        }
        if ((v7 = this.userAgent.getRendererOptions().get("noedit")) != null) {
            this.getEncryptionParams().setAllowEditContent(!PDFRenderingUtil.booleanValueOf(v7));
        }
        if ((v6 = this.userAgent.getRendererOptions().get("noannotations")) != null) {
            this.getEncryptionParams().setAllowEditAnnotations(!PDFRenderingUtil.booleanValueOf(v6));
        }
        if ((v5 = this.userAgent.getRendererOptions().get("nofillinforms")) != null) {
            this.getEncryptionParams().setAllowFillInForms(!PDFRenderingUtil.booleanValueOf(v5));
        }
        if ((v4 = this.userAgent.getRendererOptions().get("noaccesscontent")) != null) {
            this.getEncryptionParams().setAllowAccessContent(!PDFRenderingUtil.booleanValueOf(v4));
        }
        if ((v3 = this.userAgent.getRendererOptions().get("noassembledoc")) != null) {
            this.getEncryptionParams().setAllowAssembleDocument(!PDFRenderingUtil.booleanValueOf(v3));
        }
        if ((v2 = this.userAgent.getRendererOptions().get("noprinthq")) != null) {
            this.getEncryptionParams().setAllowPrintHq(!PDFRenderingUtil.booleanValueOf(v2));
        }
        if ((string = (String)this.userAgent.getRendererOptions().get("pdf-a-mode")) != null) {
            this.pdfAMode = PDFAMode.valueOf(string);
        }
        if (this.pdfAMode.isPDFA1LevelA()) {
            this.userAgent.getRendererOptions().put("accessibility", Boolean.TRUE);
        }
        if ((string = (String)this.userAgent.getRendererOptions().get("pdf-x-mode")) != null) {
            this.pdfXMode = PDFXMode.valueOf(string);
        }
        if ((string = (String)this.userAgent.getRendererOptions().get("output-profile")) != null) {
            this.outputProfileURI = string;
        }
        if ((v = this.userAgent.getRendererOptions().get("disable-srgb-colorspace")) != null) {
            this.disableSRGBColorSpace = PDFRenderingUtil.booleanValueOf(v);
        }
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setAMode(PDFAMode pDFAMode) {
        this.pdfAMode = pDFAMode;
    }

    public void setXMode(PDFXMode pDFXMode) {
        this.pdfXMode = pDFXMode;
    }

    public void setOutputProfileURI(String string) {
        this.outputProfileURI = string;
    }

    public void setDisableSRGBColorSpace(boolean bl) {
        this.disableSRGBColorSpace = bl;
    }

    public void setFilterMap(Map map) {
        this.filterMap = map;
    }

    PDFEncryptionParams getEncryptionParams() {
        if (this.encryptionParams == null) {
            this.encryptionParams = new PDFEncryptionParams();
        }
        return this.encryptionParams;
    }

    private void updateInfo() {
        PDFInfo pDFInfo = this.pdfDoc.getInfo();
        pDFInfo.setCreator(this.userAgent.getCreator());
        pDFInfo.setCreationDate(this.userAgent.getCreationDate());
        pDFInfo.setAuthor(this.userAgent.getAuthor());
        pDFInfo.setTitle(this.userAgent.getTitle());
        pDFInfo.setSubject(this.userAgent.getSubject());
        pDFInfo.setKeywords(this.userAgent.getKeywords());
    }

    private void updatePDFProfiles() {
        this.pdfDoc.getProfile().setPDFAMode(this.pdfAMode);
        this.pdfDoc.getProfile().setPDFXMode(this.pdfXMode);
    }

    private void addsRGBColorSpace() throws IOException {
        if (this.disableSRGBColorSpace) {
            if (this.pdfAMode != PDFAMode.DISABLED || this.pdfXMode != PDFXMode.DISABLED || this.outputProfileURI != null) {
                throw new IllegalStateException("It is not possible to disable the sRGB color space if PDF/A or PDF/X functionality is enabled or an output profile is set!");
            }
        } else {
            if (this.sRGBColorSpace != null) {
                return;
            }
            this.sRGBColorSpace = PDFICCBasedColorSpace.setupsRGBAsDefaultRGBColorSpace(this.pdfDoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDefaultOutputProfile() throws IOException {
        if (this.outputProfile != null) {
            return;
        }
        InputStream inputStream = null;
        if (this.outputProfileURI != null) {
            ICC_Profile iCC_Profile;
            this.outputProfile = this.pdfDoc.getFactory().makePDFICCStream();
            Source source = this.getUserAgent().resolveURI(this.outputProfileURI);
            if (source == null) {
                throw new IOException("Output profile not found: " + this.outputProfileURI);
            }
            inputStream = source instanceof StreamSource ? ((StreamSource)source).getInputStream() : new URL(source.getSystemId()).openStream();
            try {
                iCC_Profile = ColorProfileUtil.getICC_Profile((InputStream)inputStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            this.outputProfile.setColorSpace(iCC_Profile, null);
        } else {
            this.outputProfile = this.sRGBColorSpace.getICCStream();
        }
    }

    private void addPDFA1OutputIntent() throws IOException {
        this.addDefaultOutputProfile();
        String string = ColorProfileUtil.getICCProfileDescription((ICC_Profile)this.outputProfile.getICCProfile());
        PDFOutputIntent pDFOutputIntent = this.pdfDoc.getFactory().makeOutputIntent();
        pDFOutputIntent.setSubtype("GTS_PDFA1");
        pDFOutputIntent.setDestOutputProfile(this.outputProfile);
        pDFOutputIntent.setOutputConditionIdentifier(string);
        pDFOutputIntent.setInfo(pDFOutputIntent.getOutputConditionIdentifier());
        this.pdfDoc.getRoot().addOutputIntent(pDFOutputIntent);
    }

    private void addPDFXOutputIntent() throws IOException {
        this.addDefaultOutputProfile();
        String string = ColorProfileUtil.getICCProfileDescription((ICC_Profile)this.outputProfile.getICCProfile());
        int n = this.outputProfile.getICCProfile().getProfileClass();
        if (n != 2) {
            throw new PDFConformanceException(this.pdfDoc.getProfile().getPDFXMode() + " requires that" + " the DestOutputProfile be an Output Device Profile. " + string + " does not match that requirement.");
        }
        PDFOutputIntent pDFOutputIntent = this.pdfDoc.getFactory().makeOutputIntent();
        pDFOutputIntent.setSubtype("GTS_PDFX");
        pDFOutputIntent.setDestOutputProfile(this.outputProfile);
        pDFOutputIntent.setOutputConditionIdentifier(string);
        pDFOutputIntent.setInfo(pDFOutputIntent.getOutputConditionIdentifier());
        this.pdfDoc.getRoot().addOutputIntent(pDFOutputIntent);
    }

    public void renderXMPMetadata(XMPMetadata xMPMetadata) {
        Metadata metadata = xMPMetadata.getMetadata();
        Metadata metadata2 = PDFMetadata.createXMPFromPDFDocument(this.pdfDoc);
        metadata2.mergeInto(metadata);
        XMPBasicAdapter xMPBasicAdapter = XMPBasicSchema.getAdapter((Metadata)metadata);
        xMPBasicAdapter.setMetadataDate(new Date());
        PDFMetadata.updateInfoFromMetadata(metadata, this.pdfDoc.getInfo());
        PDFMetadata pDFMetadata = this.pdfDoc.getFactory().makeMetadata(metadata, xMPMetadata.isReadOnly());
        this.pdfDoc.getRoot().setMetadata(pDFMetadata);
    }

    public void generateDefaultXMPMetadata() {
        if (this.pdfDoc.getRoot().getMetadata() == null) {
            Metadata metadata = PDFMetadata.createXMPFromPDFDocument(this.pdfDoc);
            PDFMetadata pDFMetadata = this.pdfDoc.getFactory().makeMetadata(metadata, true);
            this.pdfDoc.getRoot().setMetadata(pDFMetadata);
        }
    }

    public PDFDocument setupPDFDocument(OutputStream outputStream) throws IOException {
        String string;
        if (this.pdfDoc != null) {
            throw new IllegalStateException("PDFDocument already set up");
        }
        String string2 = string = this.userAgent.getProducer() != null ? this.userAgent.getProducer() : "";
        if (this.maxPDFVersion == null) {
            this.pdfDoc = new PDFDocument(string);
        } else {
            VersionController versionController = VersionController.getFixedVersionController(this.maxPDFVersion);
            this.pdfDoc = new PDFDocument(string, versionController);
        }
        this.updateInfo();
        this.updatePDFProfiles();
        this.pdfDoc.setFilterMap(this.filterMap);
        this.pdfDoc.outputHeader(outputStream);
        PDFEncryptionManager.setupPDFEncryption(this.encryptionParams, this.pdfDoc);
        this.addsRGBColorSpace();
        if (this.outputProfileURI != null) {
            this.addDefaultOutputProfile();
        }
        if (this.pdfXMode != PDFXMode.DISABLED) {
            log.debug((Object)(this.pdfXMode + " is active."));
            log.warn((Object)("Note: " + this.pdfXMode + " support is work-in-progress and not fully implemented, yet!"));
            this.addPDFXOutputIntent();
        }
        if (this.pdfAMode.isPDFA1LevelB()) {
            log.debug((Object)("PDF/A is active. Conformance Level: " + this.pdfAMode));
            this.addPDFA1OutputIntent();
        }
        this.pdfDoc.enableAccessibility(this.userAgent.isAccessibilityEnabled());
        return this.pdfDoc;
    }

    public void generatePageLabel(int n, String string) {
        PDFPageLabels pDFPageLabels = this.pdfDoc.getRoot().getPageLabels();
        if (pDFPageLabels == null) {
            pDFPageLabels = this.pdfDoc.getFactory().makePageLabels();
            this.pdfDoc.getRoot().setPageLabels(pDFPageLabels);
        }
        PDFNumsArray pDFNumsArray = pDFPageLabels.getNums();
        PDFDictionary pDFDictionary = new PDFDictionary(pDFNumsArray);
        pDFDictionary.put("P", string);
        pDFNumsArray.put(n, (Object)pDFDictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmbeddedFile(PDFEmbeddedFileExtensionAttachment pDFEmbeddedFileExtensionAttachment) throws IOException {
        PDFArray pDFArray;
        Object object;
        this.pdfDoc.getProfile().verifyEmbeddedFilesAllowed();
        PDFNames pDFNames = this.pdfDoc.getRoot().getNames();
        if (pDFNames == null) {
            pDFNames = this.pdfDoc.getFactory().makeNames();
            this.pdfDoc.getRoot().setNames(pDFNames);
        }
        PDFEmbeddedFile pDFEmbeddedFile = new PDFEmbeddedFile();
        this.pdfDoc.registerObject(pDFEmbeddedFile);
        Source source = this.getUserAgent().resolveURI(pDFEmbeddedFileExtensionAttachment.getSrc());
        InputStream inputStream = ImageUtil.getInputStream((Source)source);
        if (inputStream == null) {
            throw new FileNotFoundException(pDFEmbeddedFileExtensionAttachment.getSrc());
        }
        try {
            object = pDFEmbeddedFile.getBufferOutputStream();
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)object);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        object = new PDFDictionary();
        ((PDFDictionary)object).put("F", pDFEmbeddedFile);
        String string = PDFText.toPDFString(pDFEmbeddedFileExtensionAttachment.getFilename(), '_');
        PDFFileSpec pDFFileSpec = new PDFFileSpec(string);
        pDFFileSpec.setEmbeddedFile((PDFDictionary)object);
        if (pDFEmbeddedFileExtensionAttachment.getDesc() != null) {
            pDFFileSpec.setDescription(pDFEmbeddedFileExtensionAttachment.getDesc());
        }
        this.pdfDoc.registerObject(pDFFileSpec);
        PDFEmbeddedFiles pDFEmbeddedFiles = pDFNames.getEmbeddedFiles();
        if (pDFEmbeddedFiles == null) {
            pDFEmbeddedFiles = new PDFEmbeddedFiles();
            this.pdfDoc.assignObjectNumber(pDFEmbeddedFiles);
            this.pdfDoc.addTrailerObject(pDFEmbeddedFiles);
            pDFNames.setEmbeddedFiles(pDFEmbeddedFiles);
        }
        if ((pDFArray = pDFEmbeddedFiles.getNames()) == null) {
            pDFArray = new PDFArray();
            pDFEmbeddedFiles.setNames(pDFArray);
        }
        String string2 = PDFText.toPDFString(string);
        pDFArray.add(string2);
        pDFArray.add(new PDFReference(pDFFileSpec));
    }

    public void setPDFVersion(String string) {
        this.maxPDFVersion = Version.getValueOf(string);
    }
}

