/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.AbstractImageHandlerGraphics2D;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;

public class PDFImageHandlerGraphics2D
extends AbstractImageHandlerGraphics2D {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.GRAPHICS2D};

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        PDFRenderingContext pDFRenderingContext = (PDFRenderingContext)renderingContext;
        PDFContentGenerator pDFContentGenerator = pDFRenderingContext.getGenerator();
        ImageGraphics2D imageGraphics2D = (ImageGraphics2D)image;
        float f = (float)rectangle.width / 1000.0f;
        float f2 = (float)rectangle.height / 1000.0f;
        float f3 = (float)rectangle.x / 1000.0f;
        float f4 = (float)rectangle.y / 1000.0f;
        Dimension dimension = image.getInfo().getSize().getDimensionMpt();
        float f5 = (float)dimension.getWidth() / 1000.0f;
        float f6 = (float)dimension.getHeight() / 1000.0f;
        float f7 = f / f5;
        float f8 = f2 / f6;
        pDFContentGenerator.comment("G2D start");
        boolean bl = renderingContext.getUserAgent().isAccessibilityEnabled();
        if (bl) {
            PDFLogicalStructureHandler.MarkedContentInfo markedContentInfo = pDFRenderingContext.getMarkedContentInfo();
            pDFContentGenerator.saveGraphicsState(markedContentInfo.tag, markedContentInfo.mcid);
        } else {
            pDFContentGenerator.saveGraphicsState();
        }
        pDFContentGenerator.updateColor(Color.black, false, null);
        pDFContentGenerator.updateColor(Color.black, true, null);
        pDFContentGenerator.add(f7 + " 0 0 " + f8 + " " + f3 + " " + f4 + " cm\n");
        PDFGraphics2D pDFGraphics2D = new PDFGraphics2D(false, pDFRenderingContext.getFontInfo(), pDFContentGenerator.getDocument(), pDFContentGenerator.getResourceContext(), pDFRenderingContext.getPage().referencePDF(), "", 0.0f);
        pDFGraphics2D.setGraphicContext(new GraphicContext());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f3, f4);
        pDFContentGenerator.getState().concatenate(affineTransform);
        pDFGraphics2D.setPaintingState(pDFContentGenerator.getState());
        pDFGraphics2D.setOutputStream(pDFContentGenerator.getOutputStream());
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, f5, f6);
        imageGraphics2D.getGraphics2DImagePainter().paint((Graphics2D)((Object)pDFGraphics2D), (Rectangle2D)double_);
        pDFContentGenerator.add(pDFGraphics2D.getString());
        if (bl) {
            pDFContentGenerator.restoreGraphicsStateAccess();
        } else {
            pDFContentGenerator.restoreGraphicsState();
        }
        pDFContentGenerator.comment("G2D end");
    }

    public int getPriority() {
        return 200;
    }

    public Class getSupportedImageClass() {
        return ImageGraphics2D.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        String string;
        boolean bl;
        boolean bl2 = bl = (image == null || image instanceof ImageGraphics2D) && renderingContext instanceof PDFRenderingContext;
        if (bl && ImageHandlerUtil.isConversionModeBitmap(string = (String)renderingContext.getHint(ImageHandlerUtil.CONVERSION_MODE))) {
            return false;
        }
        return bl;
    }
}

