/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.pcl.PCLPageDefinition;
import org.apache.fop.render.pcl.PCLRenderingMode;
import org.apache.xmlgraphics.util.UnitConv;

public class PCLRenderingUtil {
    private static Log log = LogFactory.getLog(PCLRenderingUtil.class);
    private FOUserAgent userAgent;
    private PCLRenderingMode renderingMode = PCLRenderingMode.SPEED;
    private float ditheringQuality = 0.5f;
    private boolean allTextAsBitmaps = false;
    private boolean useColorCanvas = false;
    private boolean disabledPJL = false;

    PCLRenderingUtil(FOUserAgent fOUserAgent) {
        this.userAgent = fOUserAgent;
        this.initialize();
    }

    private void initialize() {
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setRenderingMode(PCLRenderingMode pCLRenderingMode) {
        this.renderingMode = pCLRenderingMode;
        this.ditheringQuality = pCLRenderingMode.getDefaultDitheringQuality();
    }

    public PCLRenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public float getDitheringQuality() {
        return this.ditheringQuality;
    }

    public void setPJLDisabled(boolean bl) {
        this.disabledPJL = bl;
    }

    public boolean isPJLDisabled() {
        return this.disabledPJL;
    }

    public void setAllTextAsBitmaps(boolean bl) {
        this.allTextAsBitmaps = bl;
    }

    public boolean isAllTextAsBitmaps() {
        return this.allTextAsBitmaps;
    }

    public boolean isColorCanvasEnabled() {
        return this.useColorCanvas;
    }

    public static int determinePrintDirection(AffineTransform affineTransform) {
        int n = affineTransform.getScaleX() == 0.0 && affineTransform.getScaleY() == 0.0 && affineTransform.getShearX() == 1.0 && affineTransform.getShearY() == -1.0 ? 90 : (affineTransform.getScaleX() == -1.0 && affineTransform.getScaleY() == -1.0 && affineTransform.getShearX() == 0.0 && affineTransform.getShearY() == 0.0 ? 180 : (affineTransform.getScaleX() == 0.0 && affineTransform.getScaleY() == 0.0 && affineTransform.getShearX() == -1.0 && affineTransform.getShearY() == 1.0 ? 270 : 0));
        return n;
    }

    public static Point2D transformedPoint(int n, int n2, AffineTransform affineTransform, PCLPageDefinition pCLPageDefinition, int n3) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Current transform: " + affineTransform));
        }
        Point2D.Float float_ = new Point2D.Float(n, n2);
        Point2D.Float float_2 = new Point2D.Float();
        affineTransform.transform(float_, float_2);
        Dimension dimension = pCLPageDefinition.getPhysicalPageSize();
        Rectangle rectangle = pCLPageDefinition.getLogicalPageRect();
        switch (n3) {
            case 0: {
                float_2.x -= (float)rectangle.x;
                float_2.y -= (float)rectangle.y;
                break;
            }
            case 90: {
                float f = float_2.x;
                float_2.x = (float)dimension.height - float_2.y;
                float_2.y = f;
                float_2.x -= (float)rectangle.y;
                float_2.y -= (float)rectangle.x;
                break;
            }
            case 180: {
                float_2.x = (float)dimension.width - float_2.x;
                float_2.y = (float)dimension.height - float_2.y;
                float_2.x -= (float)(dimension.width - rectangle.x - rectangle.width);
                float_2.y -= (float)(dimension.height - rectangle.y - rectangle.height);
                float_2.y = (float)((double)float_2.y - UnitConv.in2mpt((double)0.5));
                break;
            }
            case 270: {
                float f = float_2.y;
                float_2.y = (float)dimension.width - float_2.x;
                float_2.x = f;
                float_2.x -= (float)(dimension.height - rectangle.y - rectangle.height);
                float_2.y -= (float)(dimension.width - rectangle.x - rectangle.width);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal print direction: " + n3);
            }
        }
        return float_2;
    }
}

