/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.render.java2d.Java2DFontMetrics;
import org.apache.fop.render.java2d.SystemFontMetricsMapper;

public class InstalledFontCollection
implements FontCollection {
    private static Log log = LogFactory.getLog(InstalledFontCollection.class);
    private static final Set<String> HARDCODED_FONT_NAMES = new HashSet<String>();
    private final Java2DFontMetrics java2DFontMetrics;

    public InstalledFontCollection(Java2DFontMetrics java2DFontMetrics) {
        this.java2DFontMetrics = java2DFontMetrics;
    }

    public int setup(int n, FontInfo fontInfo) {
        int n2 = n;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        for (int i = 0; i < fontArray.length; ++i) {
            Font font = fontArray[i];
            if (HARDCODED_FONT_NAMES.contains(font.getName())) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("AWT Font: " + font.getFontName() + ", family: " + font.getFamily() + ", PS: " + font.getPSName() + ", Name: " + font.getName() + ", Angle: " + font.getItalicAngle() + ", Style: " + font.getStyle()));
            }
            String string = FontUtil.stripWhiteSpace(font.getName()).toLowerCase();
            String string2 = FontUtil.guessStyle(string);
            int n3 = FontUtil.guessWeight(string);
            String string3 = "F" + ++n2;
            int n4 = InstalledFontCollection.convertToAWTFontStyle(string2, n3);
            InstalledFontCollection.addFontMetricsMapper(fontInfo, font.getName(), string3, this.java2DFontMetrics, n4);
            InstalledFontCollection.addFontTriplet(fontInfo, font.getName(), "normal", 400, string3);
            if (font.getName().equals(font.getFamily())) continue;
            InstalledFontCollection.addFontTriplet(fontInfo, font.getFamily(), string2, n3, string3);
        }
        return n2;
    }

    private static void addFontTriplet(FontInfo fontInfo, String string, String string2, int n, String string3) {
        FontTriplet fontTriplet = FontInfo.createFontKey(string, string2, n);
        fontInfo.addFontProperties(string3, fontTriplet);
    }

    private static void addFontMetricsMapper(FontInfo fontInfo, String string, String string2, Java2DFontMetrics java2DFontMetrics, int n) {
        SystemFontMetricsMapper systemFontMetricsMapper = new SystemFontMetricsMapper(string, n, java2DFontMetrics);
        fontInfo.addMetrics(string2, systemFontMetricsMapper);
    }

    private static int convertToAWTFontStyle(String string, int n) {
        int n2 = 0;
        if (n >= 700) {
            n2 |= 1;
        }
        if (!"normal".equals(string)) {
            n2 |= 2;
        }
        return n2;
    }

    static {
        HARDCODED_FONT_NAMES.add("any");
        HARDCODED_FONT_NAMES.add("sans-serif");
        HARDCODED_FONT_NAMES.add("serif");
        HARDCODED_FONT_NAMES.add("monospace");
        HARDCODED_FONT_NAMES.add("Helvetica");
        HARDCODED_FONT_NAMES.add("Times");
        HARDCODED_FONT_NAMES.add("Courier");
        HARDCODED_FONT_NAMES.add("Symbol");
        HARDCODED_FONT_NAMES.add("ZapfDingbats");
        HARDCODED_FONT_NAMES.add("Times Roman");
        HARDCODED_FONT_NAMES.add("Times-Roman");
        HARDCODED_FONT_NAMES.add("Computer-Modern-Typewriter");
    }
}

