/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate.extensions;

import java.awt.Point;
import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.DocumentNavigationExtensionConstants;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GoToXYAction
extends AbstractAction
implements DocumentNavigationExtensionConstants {
    private int pageIndex = -1;
    private Point targetLocation;

    public GoToXYAction(String string) {
        this(string, -1, null);
    }

    public GoToXYAction(String string, int n, Point point) {
        this.setID(string);
        if (n < 0 && point != null) {
            throw new IllegalArgumentException("Page index may not be null if target location is known!");
        }
        this.setPageIndex(n);
        this.setTargetLocation(point);
    }

    public void setPageIndex(int n) {
        this.pageIndex = n;
    }

    public int getPageIndex() {
        if (this.pageIndex >= 0) {
            return this.pageIndex;
        }
        return 0;
    }

    public Point getTargetLocation() {
        if (this.targetLocation == null) {
            return new Point(0, 0);
        }
        return this.targetLocation;
    }

    public void setTargetLocation(Point point) {
        this.targetLocation = point;
    }

    private boolean isCompleteExceptTargetLocation() {
        return this.getPageIndex() >= 0;
    }

    public boolean isComplete() {
        return this.isCompleteExceptTargetLocation() && this.targetLocation != null;
    }

    public boolean isSame(AbstractAction abstractAction) {
        if (abstractAction == null) {
            throw new NullPointerException("other must not be null");
        }
        if (!(abstractAction instanceof GoToXYAction)) {
            return false;
        }
        GoToXYAction goToXYAction = (GoToXYAction)abstractAction;
        if (this.pageIndex != goToXYAction.pageIndex) {
            return false;
        }
        if (this.targetLocation == null || goToXYAction.targetLocation == null) {
            return false;
        }
        return this.getTargetLocation().equals(goToXYAction.getTargetLocation());
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (this.isCompleteExceptTargetLocation()) {
            Point point = this.getTargetLocation();
            attributesImpl.addAttribute(null, "id", "id", "CDATA", this.getID());
            attributesImpl.addAttribute(null, "page-index", "page-index", "CDATA", Integer.toString(this.pageIndex));
            attributesImpl.addAttribute(null, "x", "x", "CDATA", Integer.toString(point.x));
            attributesImpl.addAttribute(null, "y", "y", "CDATA", Integer.toString(point.y));
        } else {
            attributesImpl.addAttribute(null, "idref", "idref", "CDATA", this.getID());
        }
        contentHandler.startElement(GOTO_XY.getNamespaceURI(), GOTO_XY.getLocalName(), GOTO_XY.getQName(), attributesImpl);
        contentHandler.endElement(GOTO_XY.getNamespaceURI(), GOTO_XY.getLocalName(), GOTO_XY.getQName());
    }

    public String toString() {
        return "GoToXY: ID=" + this.getID() + ", page=" + this.getPageIndex() + ", loc=" + this.getTargetLocation() + ", " + (this.isComplete() ? "complete" : "INCOMPLETE");
    }
}

