/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFSerializer;
import org.apache.xmlgraphics.util.DoubleFormatUtil;

public final class IFUtil {
    private IFUtil() {
    }

    private static String format(double d) {
        if (d == -0.0) {
            d = 0.0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        DoubleFormatUtil.formatDouble((double)d, (int)6, (int)6, (StringBuffer)stringBuffer);
        return stringBuffer.toString();
    }

    public static StringBuffer toString(AffineTransform affineTransform, StringBuffer stringBuffer) {
        if (affineTransform.isIdentity()) {
            return stringBuffer;
        }
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (dArray[0] == 1.0 && dArray[3] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            stringBuffer.append("translate(");
            stringBuffer.append(IFUtil.format(dArray[4]));
            if (dArray[5] != 0.0) {
                stringBuffer.append(',').append(IFUtil.format(dArray[5]));
            }
        } else {
            stringBuffer.append("matrix(");
            for (int i = 0; i < 6; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(IFUtil.format(dArray[i]));
            }
        }
        stringBuffer.append(')');
        return stringBuffer;
    }

    public static StringBuffer toString(AffineTransform[] affineTransformArray, StringBuffer stringBuffer) {
        int n = affineTransformArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            IFUtil.toString(affineTransformArray[i], stringBuffer);
        }
        return stringBuffer;
    }

    public static String toString(AffineTransform[] affineTransformArray) {
        return IFUtil.toString(affineTransformArray, new StringBuffer()).toString();
    }

    public static String toString(AffineTransform affineTransform) {
        return IFUtil.toString(affineTransform, new StringBuffer()).toString();
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Integer.toString(nArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toString(Rectangle rectangle) {
        if (rectangle == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(rectangle.x).append(' ').append(rectangle.y).append(' ');
        stringBuffer.append(rectangle.width).append(' ').append(rectangle.height);
        return stringBuffer.toString();
    }

    public static void setupFonts(IFDocumentHandler iFDocumentHandler, FontInfo fontInfo) throws FOPException {
        Object object;
        if (fontInfo == null) {
            fontInfo = new FontInfo();
        }
        if (iFDocumentHandler instanceof IFSerializer && ((IFSerializer)(object = (IFSerializer)iFDocumentHandler)).getMimickedDocumentHandler() != null) {
            iFDocumentHandler = ((IFSerializer)object).getMimickedDocumentHandler();
        }
        if ((object = iFDocumentHandler.getConfigurator()) != null) {
            object.setupFontInfo(iFDocumentHandler, fontInfo);
        } else {
            iFDocumentHandler.setDefaultFontInfo(fontInfo);
        }
    }

    public static void setupFonts(IFDocumentHandler iFDocumentHandler) throws FOPException {
        IFUtil.setupFonts(iFDocumentHandler, null);
    }

    public static String getEffectiveMIMEType(IFDocumentHandler iFDocumentHandler) {
        IFDocumentHandler iFDocumentHandler2;
        if (iFDocumentHandler instanceof IFSerializer && (iFDocumentHandler2 = ((IFSerializer)iFDocumentHandler).getMimickedDocumentHandler()) != null) {
            return iFDocumentHandler2.getMimeType();
        }
        return iFDocumentHandler.getMimeType();
    }

    public static int[] convertDPToDX(int[][] nArray, int n) {
        int[] nArray2;
        if (nArray != null) {
            nArray2 = new int[n];
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = nArray[i][0];
            }
        } else {
            nArray2 = null;
        }
        return nArray2;
    }

    public static int[] convertDPToDX(int[][] nArray) {
        return IFUtil.convertDPToDX(nArray, nArray != null ? nArray.length : 0);
    }

    public static int[][] convertDXToDP(int[] nArray, int n) {
        int[][] nArray2;
        if (nArray != null) {
            nArray2 = new int[n][4];
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                int n3;
                int[] nArray3 = nArray2[i];
                nArray3[0] = n3 = nArray[i];
                nArray3[2] = n3;
            }
        } else {
            nArray2 = null;
        }
        return nArray2;
    }

    public static int[][] convertDXToDP(int[] nArray) {
        return IFUtil.convertDXToDP(nArray, nArray != null ? nArray.length : 0);
    }

    public static boolean isPAIdentity(int[] nArray) {
        if (nArray == null) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (nArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isDPIdentity(int[][] nArray) {
        if (nArray == null) {
            return true;
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (IFUtil.isPAIdentity(nArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isDPOnlyDX(int[][] nArray) {
        if (nArray == null) {
            return false;
        }
        for (int[] nArray2 : nArray) {
            if (nArray2[0] == nArray2[2]) continue;
            return false;
        }
        return true;
    }

    public static void adjustPA(int[] nArray, int[] nArray2) {
        if (nArray != null && nArray2 != null) {
            assert (nArray.length == 4);
            assert (nArray2.length == 4);
            for (int i = 0; i < 4; ++i) {
                int n = i;
                nArray[n] = nArray[n] + nArray2[i];
            }
        }
    }

    public static int[][] copyDP(int[][] nArray, int n, int n2) {
        if (nArray == null || n > nArray.length || n + n2 > nArray.length) {
            throw new IllegalArgumentException();
        }
        int[][] nArray2 = new int[n2][4];
        int n3 = n2;
        for (int i = 0; i < n3; ++i) {
            int[] nArray3 = nArray2[i];
            int[] nArray4 = nArray[i + n];
            for (int j = 0; j < 4; ++j) {
                nArray3[j] = nArray4[j];
            }
        }
        return nArray2;
    }
}

