/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.extensions;

import org.apache.fop.render.afp.extensions.AFPExtensionAttachment;
import org.apache.fop.render.afp.extensions.ExtensionPlacement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AFPPageSetup
extends AFPExtensionAttachment {
    protected static final String ATT_VALUE = "value";
    protected static final String ATT_PLACEMENT = "placement";
    protected String content;
    protected String value;
    protected ExtensionPlacement placement = ExtensionPlacement.DEFAULT;
    private static final long serialVersionUID = -549941295384013190L;

    public AFPPageSetup(String string) {
        super(string);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public ExtensionPlacement getPlacement() {
        return this.placement;
    }

    public void setPlacement(ExtensionPlacement extensionPlacement) {
        if (!"no-operation".equals(this.getElementName())) {
            throw new UnsupportedOperationException("The attribute 'placement' can currently only be set for NOPs!");
        }
        this.placement = extensionPlacement;
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (this.name != null && this.name.length() > 0) {
            attributesImpl.addAttribute(null, "name", "name", "CDATA", this.name);
        }
        if (this.value != null && this.value.length() > 0) {
            attributesImpl.addAttribute(null, ATT_VALUE, ATT_VALUE, "CDATA", this.value);
        }
        if (this.placement != ExtensionPlacement.DEFAULT) {
            attributesImpl.addAttribute(null, ATT_PLACEMENT, ATT_PLACEMENT, "CDATA", this.placement.getXMLValue());
        }
        contentHandler.startElement("apache:fop:extensions:afp", this.elementName, this.elementName, attributesImpl);
        if (this.content != null && this.content.length() > 0) {
            char[] cArray = this.content.toCharArray();
            contentHandler.characters(cArray, 0, cArray.length);
        }
        contentHandler.endElement("apache:fop:extensions:afp", this.elementName, this.elementName);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AFPPageSetup(");
        stringBuilder.append("element-name=").append(this.getElementName());
        stringBuilder.append(" name=").append(this.getName());
        stringBuilder.append(" value=").append(this.getValue());
        if (this.getPlacement() != ExtensionPlacement.DEFAULT) {
            stringBuilder.append(" placement=").append((Object)this.getPlacement());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

