/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.StreamCache;

public class PDFPattern
extends PDFPathPaint {
    protected PDFResources resources = null;
    protected int patternType = 2;
    protected String patternName = null;
    protected int paintType = 2;
    protected int tilingType = 1;
    protected List bBox = null;
    protected double xStep = -1.0;
    protected double yStep = -1.0;
    protected PDFShading shading = null;
    protected List xUID = null;
    protected StringBuffer extGState = null;
    protected List matrix = null;
    protected StringBuffer patternDataStream = null;

    public PDFPattern(PDFResources pDFResources, int n, int n2, int n3, List list, double d, double d2, List list2, List list3, StringBuffer stringBuffer) {
        this.resources = pDFResources;
        this.patternType = 1;
        this.paintType = n2;
        this.tilingType = n3;
        this.bBox = list;
        this.xStep = d;
        this.yStep = d2;
        this.matrix = list2;
        this.xUID = list3;
        this.patternDataStream = stringBuffer;
    }

    public PDFPattern(int n, PDFShading pDFShading, List list, StringBuffer stringBuffer, List list2) {
        this.patternType = 2;
        this.shading = pDFShading;
        this.xUID = list;
        this.extGState = stringBuffer;
        this.matrix = list2;
    }

    public String getName() {
        return this.patternName;
    }

    public void setName(String string) {
        if (string.indexOf(" ") >= 0) {
            throw new IllegalArgumentException("Pattern name must not contain any spaces");
        }
        this.patternName = string;
    }

    public String getColorSpaceOut(boolean bl) {
        if (bl) {
            return "/Pattern cs /" + this.getName() + " scn \n";
        }
        return "/Pattern CS /" + this.getName() + " SCN \n";
    }

    public int output(OutputStream outputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("<< \n/Type /Pattern \n");
        if (this.resources != null) {
            stringBuffer.append("/Resources " + this.resources.referencePDF() + " \n");
        }
        stringBuffer.append("/PatternType " + this.patternType + " \n");
        AbstractPDFStream abstractPDFStream = null;
        StreamCache streamCache = null;
        if (this.patternType == 1) {
            stringBuffer.append("/PaintType " + this.paintType + " \n");
            stringBuffer.append("/TilingType " + this.tilingType + " \n");
            if (this.bBox != null) {
                n = this.bBox.size();
                stringBuffer.append("/BBox [ ");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.bBox.get(n2)));
                    stringBuffer.append(" ");
                }
                stringBuffer.append("] \n");
            }
            stringBuffer.append("/XStep " + PDFNumber.doubleOut(new Double(this.xStep)) + " \n");
            stringBuffer.append("/YStep " + PDFNumber.doubleOut(new Double(this.yStep)) + " \n");
            if (this.matrix != null) {
                n = this.matrix.size();
                stringBuffer.append("/Matrix [ ");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.matrix.get(n2), 8));
                    stringBuffer.append(" ");
                }
                stringBuffer.append("] \n");
            }
            if (this.xUID != null) {
                n = this.xUID.size();
                stringBuffer.append("/XUID [ ");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append((Integer)this.xUID.get(n2) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.patternDataStream != null) {
                abstractPDFStream = new PDFStream();
                abstractPDFStream.setDocument(this.getDocumentSafely());
                ((PDFStream)abstractPDFStream).add(this.patternDataStream.toString());
                abstractPDFStream.getFilterList().addDefaultFilters(this.getDocument().getFilterMap(), "content");
                streamCache = abstractPDFStream.encodeStream();
                stringBuffer.append(abstractPDFStream.getFilterList().buildFilterDictEntries());
                stringBuffer.append("/Length " + (streamCache.getSize() + 1) + " \n");
            }
        } else {
            if (this.shading != null) {
                stringBuffer.append("/Shading " + this.shading.referencePDF() + " \n");
            }
            if (this.xUID != null) {
                n = this.xUID.size();
                stringBuffer.append("/XUID [ ");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append((Integer)this.xUID.get(n2) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.extGState != null) {
                stringBuffer.append("/ExtGState " + this.extGState + " \n");
            }
            if (this.matrix != null) {
                n = this.matrix.size();
                stringBuffer.append("/Matrix [ ");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.matrix.get(n2), 8));
                    stringBuffer.append(" ");
                }
                stringBuffer.append("] \n");
            }
        }
        stringBuffer.append(">> \n");
        byte[] byArray = PDFPattern.encode(stringBuffer.toString());
        int n3 = byArray.length;
        outputStream.write(byArray);
        if (abstractPDFStream != null) {
            n3 += abstractPDFStream.outputStreamData(streamCache, outputStream);
        }
        return n3;
    }

    public byte[] toPDF() {
        return null;
    }

    protected boolean contentEquals(PDFObject pDFObject) {
        if (pDFObject == null) {
            return false;
        }
        if (pDFObject == this) {
            return true;
        }
        if (!(pDFObject instanceof PDFPattern)) {
            return false;
        }
        PDFPattern pDFPattern = (PDFPattern)pDFObject;
        if (this.patternType != pDFPattern.patternType) {
            return false;
        }
        if (this.paintType != pDFPattern.paintType) {
            return false;
        }
        if (this.tilingType != pDFPattern.tilingType) {
            return false;
        }
        if (this.xStep != pDFPattern.xStep) {
            return false;
        }
        if (this.yStep != pDFPattern.yStep) {
            return false;
        }
        if (this.bBox != null ? !this.bBox.equals(pDFPattern.bBox) : pDFPattern.bBox != null) {
            return false;
        }
        if (this.bBox != null ? !this.bBox.equals(pDFPattern.bBox) : pDFPattern.bBox != null) {
            return false;
        }
        if (this.xUID != null ? !this.xUID.equals(pDFPattern.xUID) : pDFPattern.xUID != null) {
            return false;
        }
        if (this.extGState != null ? !this.extGState.equals(pDFPattern.extGState) : pDFPattern.extGState != null) {
            return false;
        }
        if (this.matrix != null ? !this.matrix.equals(pDFPattern.matrix) : pDFPattern.matrix != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(pDFPattern.resources) : pDFPattern.resources != null) {
            return false;
        }
        if (this.shading != null ? !this.shading.equals(pDFPattern.shading) : pDFPattern.shading != null) {
            return false;
        }
        return !(this.patternDataStream != null ? !this.patternDataStream.equals(pDFPattern.patternDataStream) : pDFPattern.patternDataStream != null);
    }
}

