/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFObject;
import org.apache.xmlgraphics.util.DoubleFormatUtil;

public class PDFNumber
extends PDFObject {
    private Number number;

    public Number getNumber() {
        return this.number;
    }

    public void setNumber(Number number) {
        this.number = number;
    }

    public static String doubleOut(Double d) {
        return PDFNumber.doubleOut((double)d);
    }

    public static String doubleOut(double d) {
        return PDFNumber.doubleOut(d, 6);
    }

    public static String doubleOut(double d, int n) {
        if (n < 0 || n > 16) {
            throw new IllegalArgumentException("Parameter dec must be between 1 and 16");
        }
        StringBuffer stringBuffer = new StringBuffer();
        DoubleFormatUtil.formatDouble((double)d, (int)n, (int)n, (StringBuffer)stringBuffer);
        return stringBuffer.toString();
    }

    protected String toPDFString() {
        if (this.getNumber() == null) {
            throw new IllegalArgumentException("The number of this PDFNumber must not be empty");
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(PDFNumber.doubleOut(this.getNumber().doubleValue(), 10));
        return stringBuffer.toString();
    }
}

