/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFXObject;

public class PDFFormXObject
extends PDFXObject {
    private PDFStream contents;

    public PDFFormXObject(int n, PDFStream pDFStream, PDFReference pDFReference) {
        super(pDFStream.getDictionary());
        this.put("Name", new PDFName("Form" + n));
        this.contents = pDFStream;
        this.put("Type", new PDFName("XObject"));
        this.put("Subtype", new PDFName("Form"));
        this.put("FormType", new Integer(1));
        this.setMatrix(new AffineTransform());
        if (pDFReference != null) {
            this.put("Resources", pDFReference);
        }
    }

    public void setBBox(Rectangle2D rectangle2D) {
        PDFArray pDFArray = (PDFArray)this.get("BBox");
        if (pDFArray == null) {
            pDFArray = new PDFArray(this);
            pDFArray.add(rectangle2D.getX());
            pDFArray.add(rectangle2D.getY());
            pDFArray.add(rectangle2D.getWidth());
            pDFArray.add(rectangle2D.getHeight());
            this.put("BBox", pDFArray);
        } else {
            pDFArray.set(0, rectangle2D.getX());
            pDFArray.set(1, rectangle2D.getY());
            pDFArray.set(2, rectangle2D.getWidth());
            pDFArray.set(3, rectangle2D.getHeight());
        }
    }

    public Rectangle2D getBBox() {
        PDFArray pDFArray = (PDFArray)this.get("BBox");
        if (pDFArray != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            double d = ((Number)pDFArray.get(0)).doubleValue();
            double d2 = ((Number)pDFArray.get(1)).doubleValue();
            double d3 = ((Number)pDFArray.get(2)).doubleValue();
            double d4 = ((Number)pDFArray.get(3)).doubleValue();
            double_.setFrame(d, d2, d3, d4);
            return double_;
        }
        return null;
    }

    public void setMatrix(AffineTransform affineTransform) {
        PDFArray pDFArray = (PDFArray)this.get("Matrix");
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (pDFArray == null) {
            pDFArray = new PDFArray(this);
            pDFArray.add(dArray[0]);
            pDFArray.add(dArray[1]);
            pDFArray.add(dArray[2]);
            pDFArray.add(dArray[3]);
            pDFArray.add(dArray[4]);
            pDFArray.add(dArray[5]);
            this.put("Matrix", pDFArray);
        } else {
            pDFArray.set(0, dArray[0]);
            pDFArray.set(1, dArray[1]);
            pDFArray.set(2, dArray[2]);
            pDFArray.set(3, dArray[3]);
            pDFArray.set(4, dArray[4]);
            pDFArray.set(5, dArray[5]);
        }
    }

    public AffineTransform getMatrix() {
        PDFArray pDFArray = (PDFArray)this.get("Matrix");
        if (pDFArray != null) {
            AffineTransform affineTransform = new AffineTransform();
            double d = ((Number)pDFArray.get(0)).doubleValue();
            double d2 = ((Number)pDFArray.get(1)).doubleValue();
            double d3 = ((Number)pDFArray.get(2)).doubleValue();
            double d4 = ((Number)pDFArray.get(3)).doubleValue();
            double d5 = ((Number)pDFArray.get(4)).doubleValue();
            double d6 = ((Number)pDFArray.get(5)).doubleValue();
            affineTransform.setTransform(d, d2, d3, d4, d5, d6);
            return affineTransform;
        }
        return null;
    }

    public void setData(byte[] byArray) throws IOException {
        this.contents.setData(byArray);
    }

    protected void outputRawStreamData(OutputStream outputStream) throws IOException {
        this.contents.outputRawStreamData(outputStream);
    }

    public int output(OutputStream outputStream) throws IOException {
        int n = super.output(outputStream);
        this.contents = null;
        return n;
    }

    protected void populateStreamDict(Object object) {
        if (this.get("Matrix") == null) {
            this.put("Matrix", new PDFArray((PDFObject)this, new int[]{1, 0, 0, 1, 0, 0}));
        }
        super.populateStreamDict(object);
    }
}

