/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFText;

public final class PDFEncryptionJCE
extends PDFObject
implements PDFEncryption {
    private final MessageDigest digest;
    private byte[] encryptionKey;
    private String encryptionDictionary;

    private PDFEncryptionJCE(int n, PDFEncryptionParams pDFEncryptionParams, PDFDocument pDFDocument) {
        this.setObjectNumber(n);
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException(noSuchAlgorithmException.getMessage());
        }
        this.setDocument(pDFDocument);
        EncryptionInitializer encryptionInitializer = new EncryptionInitializer(pDFEncryptionParams);
        encryptionInitializer.init();
    }

    public static PDFEncryption make(int n, PDFEncryptionParams pDFEncryptionParams, PDFDocument pDFDocument) {
        return new PDFEncryptionJCE(n, pDFEncryptionParams, pDFDocument);
    }

    public byte[] encrypt(byte[] byArray, PDFObject pDFObject) {
        PDFObject pDFObject2;
        for (pDFObject2 = pDFObject; pDFObject2 != null && !pDFObject2.hasObjectNumber(); pDFObject2 = pDFObject2.getParent()) {
        }
        if (pDFObject2 == null) {
            throw new IllegalStateException("No object number could be obtained for a PDF object");
        }
        byte[] byArray2 = this.createEncryptionKey(pDFObject2.getObjectNumber(), pDFObject2.getGeneration());
        return PDFEncryptionJCE.encryptWithKey(byArray2, byArray);
    }

    public void applyFilter(AbstractPDFStream abstractPDFStream) {
        abstractPDFStream.getFilterList().addFilter(new EncryptionFilter(abstractPDFStream.getObjectNumber(), abstractPDFStream.getGeneration()));
    }

    public byte[] toPDF() {
        assert (this.encryptionDictionary != null);
        return PDFEncryptionJCE.encode(this.encryptionDictionary);
    }

    public String getTrailerEntry() {
        return "/Encrypt " + this.getObjectNumber() + " " + this.getGeneration() + " R\n";
    }

    private static byte[] encryptWithKey(byte[] byArray, byte[] byArray2) {
        try {
            Cipher cipher = PDFEncryptionJCE.initCipher(byArray);
            return cipher.doFinal(byArray2);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IllegalStateException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalStateException(badPaddingException.getMessage());
        }
    }

    private static Cipher initCipher(byte[] byArray) {
        try {
            Cipher cipher = Cipher.getInstance("RC4");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "RC4");
            cipher.init(1, secretKeySpec);
            return cipher;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new UnsupportedOperationException(noSuchPaddingException);
        }
    }

    private byte[] createEncryptionKey(int n, int n2) {
        byte[] byArray = this.prepareMD5Input(n, n2);
        this.digest.reset();
        byte[] byArray2 = this.digest.digest(byArray);
        int n3 = Math.min(16, byArray.length);
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    private byte[] prepareMD5Input(int n, int n2) {
        byte[] byArray = new byte[this.encryptionKey.length + 5];
        System.arraycopy(this.encryptionKey, 0, byArray, 0, this.encryptionKey.length);
        int n3 = this.encryptionKey.length;
        byArray[n3++] = (byte)(n >>> 0);
        byArray[n3++] = (byte)(n >>> 8);
        byArray[n3++] = (byte)(n >>> 16);
        byArray[n3++] = (byte)(n2 >>> 0);
        byArray[n3++] = (byte)(n2 >>> 8);
        return byArray;
    }

    static /* synthetic */ byte[] access$502(PDFEncryptionJCE pDFEncryptionJCE, byte[] byArray) {
        pDFEncryptionJCE.encryptionKey = byArray;
        return byArray;
    }

    private class EncryptionFilter
    extends PDFFilter {
        private int streamNumber;
        private int streamGeneration;

        EncryptionFilter(int n, int n2) {
            this.streamNumber = n;
            this.streamGeneration = n2;
        }

        public String getName() {
            return "";
        }

        public PDFObject getDecodeParms() {
            return null;
        }

        public OutputStream applyFilter(OutputStream outputStream) throws IOException {
            byte[] byArray = PDFEncryptionJCE.this.createEncryptionKey(this.streamNumber, this.streamGeneration);
            Cipher cipher = PDFEncryptionJCE.initCipher(byArray);
            return new CipherOutputStream(outputStream, cipher);
        }
    }

    private class Rev3Engine
    extends InitializationEngine {
        Rev3Engine(EncryptionSettings encryptionSettings) {
            super(encryptionSettings);
        }

        protected byte[] computeOValueStep3(byte[] byArray) {
            for (int i = 0; i < 50; ++i) {
                byArray = PDFEncryptionJCE.this.digest.digest(byArray);
            }
            return byArray;
        }

        protected byte[] computeOValueStep7(byte[] byArray, byte[] byArray2) {
            return this.xorKeyAndEncrypt19Times(byArray, byArray2);
        }

        protected byte[] createEncryptionKeyStep6(byte[] byArray) {
            for (int i = 0; i < 50; ++i) {
                PDFEncryptionJCE.this.digest.update(byArray, 0, this.encryptionLengthInBytes);
                byArray = PDFEncryptionJCE.this.digest.digest();
            }
            return byArray;
        }

        protected byte[] computeUValue() {
            PDFEncryptionJCE.this.digest.reset();
            PDFEncryptionJCE.this.digest.update(this.padding);
            PDFEncryptionJCE.this.digest.update(PDFEncryptionJCE.this.getDocumentSafely().getFileIDGenerator().getOriginalFileID());
            byte[] byArray = PDFEncryptionJCE.encryptWithKey(PDFEncryptionJCE.this.encryptionKey, PDFEncryptionJCE.this.digest.digest());
            byArray = this.xorKeyAndEncrypt19Times(PDFEncryptionJCE.this.encryptionKey, byArray);
            byte[] byArray2 = new byte[32];
            System.arraycopy(byArray, 0, byArray2, 0, 16);
            Arrays.fill(byArray2, 16, 32, (byte)0);
            return byArray2;
        }

        private byte[] xorKeyAndEncrypt19Times(byte[] byArray, byte[] byArray2) {
            byte[] byArray3 = byArray2;
            byte[] byArray4 = new byte[byArray.length];
            for (int i = 1; i <= 19; ++i) {
                for (int j = 0; j < byArray.length; ++j) {
                    byArray4[j] = (byte)(byArray[j] ^ i);
                }
                byArray3 = PDFEncryptionJCE.encryptWithKey(byArray4, byArray3);
            }
            return byArray3;
        }
    }

    private class Rev2Engine
    extends InitializationEngine {
        Rev2Engine(EncryptionSettings encryptionSettings) {
            super(encryptionSettings);
        }

        protected byte[] computeOValueStep3(byte[] byArray) {
            return byArray;
        }

        protected byte[] computeOValueStep7(byte[] byArray, byte[] byArray2) {
            return byArray2;
        }

        protected byte[] createEncryptionKeyStep6(byte[] byArray) {
            return byArray;
        }

        protected byte[] computeUValue() {
            return PDFEncryptionJCE.encryptWithKey(PDFEncryptionJCE.this.encryptionKey, this.padding);
        }
    }

    private abstract class InitializationEngine {
        protected final byte[] padding = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
        protected final int encryptionLengthInBytes;
        private final int permissions;
        private byte[] oValue;
        private byte[] uValue;
        private final byte[] preparedUserPassword;
        protected final String ownerPassword;

        InitializationEngine(EncryptionSettings encryptionSettings) {
            this.encryptionLengthInBytes = encryptionSettings.encryptionLength / 8;
            this.permissions = encryptionSettings.permissions;
            this.preparedUserPassword = this.preparePassword(encryptionSettings.userPassword);
            this.ownerPassword = encryptionSettings.ownerPassword;
        }

        void run() {
            this.oValue = this.computeOValue();
            this.createEncryptionKey();
            this.uValue = this.computeUValue();
        }

        private byte[] computeOValue() {
            byte[] byArray = this.prepareMD5Input();
            PDFEncryptionJCE.this.digest.reset();
            byte[] byArray2 = PDFEncryptionJCE.this.digest.digest(byArray);
            byArray2 = this.computeOValueStep3(byArray2);
            byte[] byArray3 = new byte[this.encryptionLengthInBytes];
            System.arraycopy(byArray2, 0, byArray3, 0, this.encryptionLengthInBytes);
            byte[] byArray4 = PDFEncryptionJCE.encryptWithKey(byArray3, this.preparedUserPassword);
            byArray4 = this.computeOValueStep7(byArray3, byArray4);
            return byArray4;
        }

        private void createEncryptionKey() {
            PDFEncryptionJCE.this.digest.reset();
            PDFEncryptionJCE.this.digest.update(this.preparedUserPassword);
            PDFEncryptionJCE.this.digest.update(this.oValue);
            PDFEncryptionJCE.this.digest.update((byte)(this.permissions >>> 0));
            PDFEncryptionJCE.this.digest.update((byte)(this.permissions >>> 8));
            PDFEncryptionJCE.this.digest.update((byte)(this.permissions >>> 16));
            PDFEncryptionJCE.this.digest.update((byte)(this.permissions >>> 24));
            PDFEncryptionJCE.this.digest.update(PDFEncryptionJCE.this.getDocumentSafely().getFileIDGenerator().getOriginalFileID());
            byte[] byArray = PDFEncryptionJCE.this.digest.digest();
            byArray = this.createEncryptionKeyStep6(byArray);
            PDFEncryptionJCE.access$502(PDFEncryptionJCE.this, new byte[this.encryptionLengthInBytes]);
            System.arraycopy(byArray, 0, PDFEncryptionJCE.this.encryptionKey, 0, this.encryptionLengthInBytes);
        }

        protected abstract byte[] computeUValue();

        private byte[] preparePassword(String string) {
            int n = 32;
            byte[] byArray = new byte[n];
            byte[] byArray2 = string.getBytes();
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(this.padding, 0, byArray, byArray2.length, n - byArray2.length);
            return byArray;
        }

        private byte[] prepareMD5Input() {
            if (this.ownerPassword.length() != 0) {
                return this.preparePassword(this.ownerPassword);
            }
            return this.preparedUserPassword;
        }

        protected abstract byte[] computeOValueStep3(byte[] var1);

        protected abstract byte[] computeOValueStep7(byte[] var1, byte[] var2);

        protected abstract byte[] createEncryptionKeyStep6(byte[] var1);
    }

    private static final class EncryptionSettings {
        final int encryptionLength;
        final int permissions;
        final String userPassword;
        final String ownerPassword;

        EncryptionSettings(int n, int n2, String string, String string2) {
            this.encryptionLength = n;
            this.permissions = n2;
            this.userPassword = string;
            this.ownerPassword = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Permission {
        PRINT(3),
        EDIT_CONTENT(4),
        COPY_CONTENT(5),
        EDIT_ANNOTATIONS(6),
        FILL_IN_FORMS(9),
        ACCESS_CONTENT(10),
        ASSEMBLE_DOCUMENT(11),
        PRINT_HQ(12);

        private final int mask;

        private Permission(int n2) {
            this.mask = 1 << n2 - 1;
        }

        private int removeFrom(int n) {
            return n - this.mask;
        }

        static int computePermissions(PDFEncryptionParams pDFEncryptionParams) {
            int n = -4;
            if (!pDFEncryptionParams.isAllowPrint()) {
                n = PRINT.removeFrom(n);
            }
            if (!pDFEncryptionParams.isAllowCopyContent()) {
                n = COPY_CONTENT.removeFrom(n);
            }
            if (!pDFEncryptionParams.isAllowEditContent()) {
                n = EDIT_CONTENT.removeFrom(n);
            }
            if (!pDFEncryptionParams.isAllowEditAnnotations()) {
                n = EDIT_ANNOTATIONS.removeFrom(n);
            }
            if (!pDFEncryptionParams.isAllowFillInForms()) {
                n = FILL_IN_FORMS.removeFrom(n);
            }
            if (!pDFEncryptionParams.isAllowAccessContent()) {
                n = ACCESS_CONTENT.removeFrom(n);
            }
            if (!pDFEncryptionParams.isAllowAssembleDocument()) {
                n = ASSEMBLE_DOCUMENT.removeFrom(n);
            }
            if (!pDFEncryptionParams.isAllowPrintHq()) {
                n = PRINT_HQ.removeFrom(n);
            }
            return n;
        }
    }

    private class EncryptionInitializer {
        private final PDFEncryptionParams encryptionParams;
        private int encryptionLength;
        private int version;
        private int revision;

        EncryptionInitializer(PDFEncryptionParams pDFEncryptionParams) {
            this.encryptionParams = new PDFEncryptionParams(pDFEncryptionParams);
        }

        void init() {
            this.encryptionLength = this.encryptionParams.getEncryptionLengthInBits();
            this.determineEncryptionAlgorithm();
            int n = Permission.computePermissions(this.encryptionParams);
            EncryptionSettings encryptionSettings = new EncryptionSettings(this.encryptionLength, n, this.encryptionParams.getUserPassword(), this.encryptionParams.getOwnerPassword());
            InitializationEngine initializationEngine = this.revision == 2 ? new Rev2Engine(encryptionSettings) : new Rev3Engine(encryptionSettings);
            initializationEngine.run();
            PDFEncryptionJCE.this.encryptionDictionary = this.createEncryptionDictionary(n, initializationEngine.oValue, initializationEngine.uValue);
        }

        private void determineEncryptionAlgorithm() {
            if (this.isVersion1Revision2Algorithm()) {
                this.version = 1;
                this.revision = 2;
            } else {
                this.version = 2;
                this.revision = 3;
            }
        }

        private boolean isVersion1Revision2Algorithm() {
            return this.encryptionLength == 40 && this.encryptionParams.isAllowFillInForms() && this.encryptionParams.isAllowAccessContent() && this.encryptionParams.isAllowAssembleDocument() && this.encryptionParams.isAllowPrintHq();
        }

        private String createEncryptionDictionary(int n, byte[] byArray, byte[] byArray2) {
            return "<< /Filter /Standard\n/V " + this.version + "\n" + "/R " + this.revision + "\n" + "/Length " + this.encryptionLength + "\n" + "/P " + n + "\n" + "/O " + PDFText.toHex(byArray) + "\n" + "/U " + PDFText.toHex(byArray2) + "\n" + ">>";
        }
    }
}

