/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.BreakUtil;

public class TableLayoutManager
extends BlockStackingLayoutManager
implements ConditionalElementListener {
    private static Log log = LogFactory.getLog(TableLayoutManager.class);
    private TableContentLayoutManager contentLM;
    private ColumnSetup columns = null;
    private Block curBlockArea;
    private double tableUnit;
    private boolean autoLayout = true;
    private boolean discardBorderBefore;
    private boolean discardBorderAfter;
    private boolean discardPaddingBefore;
    private boolean discardPaddingAfter;
    private MinOptMax effSpaceBefore;
    private MinOptMax effSpaceAfter;
    private int halfBorderSeparationBPD;
    private int halfBorderSeparationIPD;
    private List columnBackgroundAreas;
    private Position auxiliaryPosition;

    public TableLayoutManager(Table table) {
        super(table);
        this.columns = new ColumnSetup(table);
    }

    public Table getTable() {
        return (Table)this.fobj;
    }

    public ColumnSetup getColumns() {
        return this.columns;
    }

    public void initialize() {
        this.foSpaceBefore = new SpaceVal(this.getTable().getCommonMarginBlock().spaceBefore, this).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getTable().getCommonMarginBlock().spaceAfter, this).getSpace();
        this.startIndent = this.getTable().getCommonMarginBlock().startIndent.getValue(this);
        this.endIndent = this.getTable().getCommonMarginBlock().endIndent.getValue(this);
        if (this.getTable().isSeparateBorderModel()) {
            this.halfBorderSeparationBPD = this.getTable().getBorderSeparation().getBPD().getLength().getValue(this) / 2;
            this.halfBorderSeparationIPD = this.getTable().getBorderSeparation().getIPD().getLength().getValue(this) / 2;
        } else {
            this.halfBorderSeparationBPD = 0;
            this.halfBorderSeparationIPD = 0;
        }
        if (!this.getTable().isAutoLayout() && this.getTable().getInlineProgressionDimension().getOptimum(this).getEnum() != 9) {
            this.autoLayout = false;
        }
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    public int getHalfBorderSeparationBPD() {
        return this.halfBorderSeparationBPD;
    }

    public int getHalfBorderSeparationIPD() {
        return this.halfBorderSeparationIPD;
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        int n2;
        int n3;
        Object object;
        int n4;
        LinkedList<BreakElement> linkedList = new LinkedList<BreakElement>();
        this.referenceIPD = layoutContext.getRefIPD();
        if (this.getTable().getInlineProgressionDimension().getOptimum(this).getEnum() != 9) {
            n4 = this.getTable().getInlineProgressionDimension().getOptimum(this).getLength().getValue(this);
            this.updateContentAreaIPDwithOverconstrainedAdjust(n4);
        } else {
            if (!this.getTable().isAutoLayout()) {
                BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getTable().getUserAgent().getEventBroadcaster());
                blockLevelEventProducer.tableFixedAutoWidthNotSupported(this, this.getTable().getLocator());
            }
            this.updateContentAreaIPDwithOverconstrainedAdjust();
        }
        n4 = this.columns.getSumOfColumnWidths(this);
        if (!this.autoLayout && n4 > this.getContentAreaIPD()) {
            log.debug((Object)FONode.decorateWithContextInfo("The sum of all column widths is larger than the specified table width.", this.getTable()));
            this.updateContentAreaIPDwithOverconstrainedAdjust(n4);
        }
        int n5 = this.referenceIPD - this.getIPIndents();
        if (this.getContentAreaIPD() > n5) {
            object = BlockLevelEventProducer.Provider.get(this.getTable().getUserAgent().getEventBroadcaster());
            object.objectTooWide(this, this.getTable().getName(), this.getContentAreaIPD(), layoutContext.getRefIPD(), this.getTable().getLocator());
        }
        if (this.tableUnit == 0.0) {
            this.tableUnit = this.columns.computeTableUnit(this);
        }
        if (!this.firstVisibleMarkServed) {
            this.addKnuthElementsForSpaceBefore(linkedList, n);
        }
        if (this.getTable().isSeparateBorderModel()) {
            this.addKnuthElementsForBorderPaddingBefore(linkedList, !this.firstVisibleMarkServed);
            this.firstVisibleMarkServed = true;
            this.addPendingMarks(layoutContext);
        }
        this.contentLM = new TableContentLayoutManager(this);
        LayoutContext layoutContext2 = new LayoutContext(0);
        layoutContext2.setRefIPD(layoutContext.getRefIPD());
        layoutContext2.copyPendingMarksFrom(layoutContext);
        object = this.contentLM.getNextKnuthElements(layoutContext2, n);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ListElement listElement = (ListElement)iterator.next();
            this.notifyPos(listElement.getPosition());
        }
        log.debug(object);
        this.wrapPositionElements((List)object, linkedList);
        layoutContext.updateKeepWithPreviousPending(this.getKeepWithPrevious());
        layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
        layoutContext.updateKeepWithNextPending(this.getKeepWithNext());
        layoutContext.updateKeepWithNextPending(layoutContext2.getKeepWithNextPending());
        if (this.getTable().isSeparateBorderModel()) {
            this.addKnuthElementsForBorderPaddingAfter(linkedList, true);
        }
        this.addKnuthElementsForSpaceAfter(linkedList, n);
        if (!layoutContext.suppressBreakBefore() && (n3 = BreakUtil.compareBreakClasses(this.getTable().getBreakBefore(), layoutContext2.getBreakBefore())) != 9) {
            linkedList.add(0, new BreakElement(this.getAuxiliaryPosition(), 0, -1000, n3, layoutContext));
        }
        if ((n2 = BreakUtil.compareBreakClasses(this.getTable().getBreakAfter(), layoutContext2.getBreakAfter())) != 9) {
            linkedList.add(new BreakElement(this.getAuxiliaryPosition(), 0, -1000, n2, layoutContext));
        }
        this.setFinished(true);
        this.resetSpaces();
        return linkedList;
    }

    public Position getAuxiliaryPosition() {
        if (this.auxiliaryPosition == null) {
            this.auxiliaryPosition = new LeafPosition(this, 0);
        }
        return this.auxiliaryPosition;
    }

    void registerColumnBackgroundArea(TableColumn tableColumn, Block block, int n) {
        this.addBackgroundArea(block);
        if (this.columnBackgroundAreas == null) {
            this.columnBackgroundAreas = new ArrayList();
        }
        this.columnBackgroundAreas.add(new ColumnBackgroundInfo(tableColumn, block, n));
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        this.getParentArea(null);
        this.addId();
        if (layoutContext.getSpaceBefore() != 0) {
            this.addBlockSpacing(0.0, MinOptMax.getInstance(layoutContext.getSpaceBefore()));
        }
        int n = this.getTable().getCommonMarginBlock().startIndent.getValue(this);
        int n2 = 0;
        LayoutContext layoutContext2 = new LayoutContext(0);
        layoutContext2.setRefIPD(this.getContentAreaIPD());
        this.contentLM.setStartXOffset(n);
        this.contentLM.addAreas(positionIterator, layoutContext2);
        this.curBlockArea.setBPD(n2 += this.contentLM.getUsedBPD());
        if (this.columnBackgroundAreas != null) {
            for (ColumnBackgroundInfo columnBackgroundInfo : this.columnBackgroundAreas) {
                TraitSetter.addBackground(columnBackgroundInfo.backgroundArea, columnBackgroundInfo.column.getCommonBorderPaddingBackground(), this, columnBackgroundInfo.xShift, -columnBackgroundInfo.backgroundArea.getYOffset(), columnBackgroundInfo.column.getColumnWidth().getValue(this), n2);
            }
            this.columnBackgroundAreas.clear();
        }
        if (this.getTable().isSeparateBorderModel()) {
            TraitSetter.addBorders(this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, this);
            TraitSetter.addPadding(this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, this);
        }
        TraitSetter.addBackground(this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this);
        TraitSetter.addMargins(this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this.startIndent, this.endIndent, this);
        TraitSetter.addBreaks(this.curBlockArea, this.getTable().getBreakBefore(), this.getTable().getBreakAfter());
        TraitSetter.addSpaceBeforeAfter(this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.resetSpaces();
        this.curBlockArea = null;
        this.notifyEndOfLayout();
    }

    public Area getParentArea(Area area) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.parentLayoutManager.getParentArea(this.curBlockArea);
            TraitSetter.setProducerID(this.curBlockArea, this.getTable().getId());
            this.curBlockArea.setIPD(this.getContentAreaIPD());
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area area) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)area);
        }
    }

    void addBackgroundArea(Block block) {
        this.curBlockArea.addChildArea(block);
    }

    public int negotiateBPDAdjustment(int n, KnuthElement knuthElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue knuthGlue) {
    }

    public KeepProperty getKeepTogetherProperty() {
        return this.getTable().getKeepTogether();
    }

    public KeepProperty getKeepWithPreviousProperty() {
        return this.getTable().getKeepWithPrevious();
    }

    public KeepProperty getKeepWithNextProperty() {
        return this.getTable().getKeepWithNext();
    }

    public int getBaseLength(int n, FObj fObj) {
        if (fObj instanceof TableColumn && fObj.getParent() == this.getFObj()) {
            switch (n) {
                case 5: {
                    return this.getContentAreaIPD();
                }
                case 11: {
                    return (int)this.tableUnit;
                }
            }
            log.error((Object)"Unknown base type for LengthBase.");
            return 0;
        }
        switch (n) {
            case 11: {
                return (int)this.tableUnit;
            }
        }
        return super.getBaseLength(n, fObj);
    }

    public void notifySpace(RelSide relSide, MinOptMax minOptMax) {
        if (RelSide.BEFORE == relSide) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + relSide + ", " + this.effSpaceBefore + "-> " + minOptMax));
            }
            this.effSpaceBefore = minOptMax;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + relSide + ", " + this.effSpaceAfter + "-> " + minOptMax));
            }
            this.effSpaceAfter = minOptMax;
        }
    }

    public void notifyBorder(RelSide relSide, MinOptMax minOptMax) {
        if (minOptMax == null) {
            if (RelSide.BEFORE == relSide) {
                this.discardBorderBefore = true;
            } else {
                this.discardBorderAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Border " + relSide + " -> " + minOptMax));
        }
    }

    public void notifyPadding(RelSide relSide, MinOptMax minOptMax) {
        if (minOptMax == null) {
            if (RelSide.BEFORE == relSide) {
                this.discardPaddingBefore = true;
            } else {
                this.discardPaddingAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Padding " + relSide + " -> " + minOptMax));
        }
    }

    public void reset() {
        super.reset();
        this.curBlockArea = null;
        this.tableUnit = 0.0;
    }

    private static final class ColumnBackgroundInfo {
        private TableColumn column;
        private Block backgroundArea;
        private int xShift;

        private ColumnBackgroundInfo(TableColumn tableColumn, Block block, int n) {
            this.column = tableColumn;
            this.backgroundArea = block;
            this.xShift = n;
        }
    }
}

