/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.traits.WritingMode;

final class ScaledBaselineTable {
    private static final float HANGING_BASELINE_FACTOR = 0.8f;
    private static final float MATHEMATICAL_BASELINE_FACTOR = 0.5f;
    private final int altitude;
    private final int depth;
    private final int xHeight;
    private final int dominantBaselineIdentifier;
    private final WritingMode writingMode;
    private final int dominantBaselineOffset;
    private int beforeEdgeOffset;
    private int afterEdgeOffset;

    ScaledBaselineTable(int n, int n2, int n3, int n4, WritingMode writingMode) {
        this.altitude = n;
        this.depth = n2;
        this.xHeight = n3;
        this.dominantBaselineIdentifier = n4;
        this.writingMode = writingMode;
        this.dominantBaselineOffset = this.getBaselineDefaultOffset(this.dominantBaselineIdentifier);
        this.beforeEdgeOffset = n - this.dominantBaselineOffset;
        this.afterEdgeOffset = n2 - this.dominantBaselineOffset;
    }

    int getDominantBaselineIdentifier() {
        return this.dominantBaselineIdentifier;
    }

    WritingMode getWritingMode() {
        return this.writingMode;
    }

    int getBaseline(int n) {
        int n2 = 0;
        if (!this.isHorizontalWritingMode()) {
            switch (n) {
                case 20: 
                case 143: 
                case 144: 
                case 145: {
                    throw new IllegalArgumentException("Baseline " + n + " only supported for horizontal writing modes");
                }
            }
        }
        switch (n) {
            case 14: 
            case 145: {
                n2 = this.beforeEdgeOffset;
                break;
            }
            case 6: 
            case 24: 
            case 56: 
            case 59: 
            case 82: 
            case 84: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                n2 = this.getBaselineDefaultOffset(n) - this.dominantBaselineOffset;
                break;
            }
            case 4: 
            case 20: {
                n2 = this.afterEdgeOffset;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        return n2;
    }

    private boolean isHorizontalWritingMode() {
        return this.writingMode.isHorizontal();
    }

    private int getBaselineDefaultOffset(int n) {
        int n2 = 0;
        switch (n) {
            case 142: {
                n2 = this.altitude;
                break;
            }
            case 56: {
                n2 = Math.round((float)this.altitude * 0.8f);
                break;
            }
            case 24: {
                n2 = (this.altitude - this.depth) / 2 + this.depth;
                break;
            }
            case 84: {
                n2 = this.xHeight / 2;
                break;
            }
            case 82: {
                n2 = Math.round((float)this.altitude * 0.5f);
                break;
            }
            case 6: {
                n2 = 0;
                break;
            }
            case 59: 
            case 141: {
                n2 = this.depth;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        return n2;
    }

    void setBeforeAndAfterBaselines(int n, int n2) {
        this.beforeEdgeOffset = n;
        this.afterEdgeOffset = n2;
    }

    ScaledBaselineTable deriveScaledBaselineTable(int n) {
        ScaledBaselineTable scaledBaselineTable = new ScaledBaselineTable(this.altitude, this.depth, this.xHeight, n, this.writingMode);
        return scaledBaselineTable;
    }
}

