/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.traits.MinOptMax;

public abstract class LeafNodeLayoutManager
extends AbstractLayoutManager
implements InlineLevelLayoutManager {
    protected static final Log log = LogFactory.getLog(LeafNodeLayoutManager.class);
    protected InlineArea curArea = null;
    protected CommonBorderPaddingBackground commonBorderPaddingBackground = null;
    protected AlignmentContext alignmentContext = null;
    protected boolean somethingChanged = false;
    protected AreaInfo areaInfo = null;

    public LeafNodeLayoutManager(FObj fObj) {
        super(fObj);
    }

    public LeafNodeLayoutManager() {
    }

    public InlineArea get(LayoutContext layoutContext) {
        return this.curArea;
    }

    public boolean resolved() {
        return false;
    }

    public void setCurrentArea(InlineArea inlineArea) {
        this.curArea = inlineArea;
    }

    public void addChildArea(Area area) {
        assert (false);
    }

    public Area getParentArea(Area area) {
        assert (false);
        return null;
    }

    protected void setCommonBorderPaddingBackground(CommonBorderPaddingBackground commonBorderPaddingBackground) {
        this.commonBorderPaddingBackground = commonBorderPaddingBackground;
    }

    protected MinOptMax getAllocationIPD(int n) {
        return MinOptMax.getInstance(this.curArea.getIPD());
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        this.addId();
        InlineArea inlineArea = this.getEffectiveArea();
        if (inlineArea.getAllocIPD() > 0 || inlineArea.getAllocBPD() > 0) {
            this.offsetArea(inlineArea, layoutContext);
            this.widthAdjustArea(inlineArea, layoutContext);
            if (this.commonBorderPaddingBackground != null) {
                TraitSetter.setBorderPaddingTraits(inlineArea, this.commonBorderPaddingBackground, false, false, this);
                TraitSetter.addBackground(inlineArea, this.commonBorderPaddingBackground, this);
            }
            this.parentLayoutManager.addChildArea(inlineArea);
        }
        while (positionIterator.hasNext()) {
            positionIterator.next();
        }
    }

    protected InlineArea getEffectiveArea() {
        return this.curArea;
    }

    protected void offsetArea(InlineArea inlineArea, LayoutContext layoutContext) {
        inlineArea.setBlockProgressionOffset(this.alignmentContext.getOffset());
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext layoutContext) {
        return layoutContext.getAlignmentContext();
    }

    protected void widthAdjustArea(InlineArea inlineArea, LayoutContext layoutContext) {
        double d = layoutContext.getIPDAdjust();
        int n = 0;
        if (d < 0.0) {
            n += (int)(d * (double)this.areaInfo.ipdArea.getShrink());
        } else if (d > 0.0) {
            n += (int)(d * (double)this.areaInfo.ipdArea.getStretch());
        }
        inlineArea.setIPD(this.areaInfo.ipdArea.getOpt() + n);
        inlineArea.setAdjustment(n);
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        this.curArea = this.get(layoutContext);
        if (this.curArea == null) {
            this.setFinished(true);
            return null;
        }
        this.alignmentContext = this.makeAlignmentContext(layoutContext);
        MinOptMax minOptMax = this.getAllocationIPD(layoutContext.getRefIPD());
        this.areaInfo = new AreaInfo(0, minOptMax, false, this.alignmentContext);
        InlineKnuthSequence inlineKnuthSequence = new InlineKnuthSequence();
        this.addKnuthElementsForBorderPaddingStart(inlineKnuthSequence);
        inlineKnuthSequence.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
        this.addKnuthElementsForBorderPaddingEnd(inlineKnuthSequence);
        this.setFinished(true);
        return Collections.singletonList(inlineKnuthSequence);
    }

    public List addALetterSpaceTo(List list) {
        return list;
    }

    public List addALetterSpaceTo(List list, int n) {
        return this.addALetterSpaceTo(list);
    }

    public String getWordChars(Position position) {
        return "";
    }

    public void hyphenate(Position position, HyphContext hyphContext) {
    }

    public boolean applyChanges(List list) {
        this.setFinished(false);
        return false;
    }

    public boolean applyChanges(List list, int n) {
        return this.applyChanges(list);
    }

    public List getChangedKnuthElements(List list, int n, int n2) {
        return this.getChangedKnuthElements(list, n);
    }

    public List getChangedKnuthElements(List list, int n) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthInlineBox> linkedList = new LinkedList<KnuthInlineBox>();
        this.addKnuthElementsForBorderPaddingStart(linkedList);
        linkedList.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), true));
        this.addKnuthElementsForBorderPaddingEnd(linkedList);
        this.setFinished(true);
        return linkedList;
    }

    protected void addKnuthElementsForBorderPaddingStart(List list) {
        int n;
        if (this.commonBorderPaddingBackground != null && (n = this.commonBorderPaddingBackground.getBorderStartWidth(false) + this.commonBorderPaddingBackground.getPaddingStart(false, this)) > 0) {
            list.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            list.add(new KnuthGlue(n, 0, 0, new LeafPosition(this, -1), true));
        }
    }

    protected void addKnuthElementsForBorderPaddingEnd(List list) {
        int n;
        if (this.commonBorderPaddingBackground != null && (n = this.commonBorderPaddingBackground.getBorderEndWidth(false) + this.commonBorderPaddingBackground.getPaddingEnd(false, this)) > 0) {
            list.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            list.add(new KnuthGlue(n, 0, 0, new LeafPosition(this, -1), true));
        }
    }

    protected class AreaInfo {
        protected short letterSpaces;
        protected MinOptMax ipdArea;
        protected boolean isHyphenated;
        protected AlignmentContext alignmentContext;

        public AreaInfo(short s, MinOptMax minOptMax, boolean bl, AlignmentContext alignmentContext) {
            this.letterSpaces = s;
            this.ipdArea = minOptMax;
            this.isHyphenated = bl;
            this.alignmentContext = alignmentContext;
        }
    }
}

