/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.SimplePercentBaseContext;
import org.apache.fop.fo.Constants;
import org.apache.fop.fonts.Font;
import org.apache.fop.layoutmgr.inline.ScaledBaselineTable;
import org.apache.fop.traits.WritingMode;

public class AlignmentContext
implements Constants {
    private int areaHeight;
    private int lineHeight;
    private int alignmentPoint;
    private int baselineShiftValue;
    private int alignmentBaselineIdentifier;
    private int xHeight;
    private ScaledBaselineTable scaledBaselineTable;
    private ScaledBaselineTable actualBaselineTable;
    private AlignmentContext parentAlignmentContext;

    AlignmentContext(int n, Length length, int n2, Length length2, int n3, AlignmentContext alignmentContext) {
        this(n, 0, n, n, length, n2, length2, n3, alignmentContext);
    }

    AlignmentContext(Font font, int n, Length length, int n2, Length length2, int n3, AlignmentContext alignmentContext) {
        this(font.getAscender(), font.getDescender(), n, font.getXHeight(), length, n2, length2, n3, alignmentContext);
    }

    private AlignmentContext(int n, int n2, int n3, int n4, Length length, int n5, Length length2, int n6, AlignmentContext alignmentContext) {
        this.areaHeight = n - n2;
        this.lineHeight = n3;
        this.xHeight = n4;
        this.parentAlignmentContext = alignmentContext;
        this.scaledBaselineTable = alignmentContext.getScaledBaselineTable();
        this.setAlignmentBaselineIdentifier(n5, alignmentContext.getDominantBaselineIdentifier());
        this.setBaselineShift(length2);
        int n7 = alignmentContext.getDominantBaselineIdentifier();
        boolean bl = false;
        if (this.baselineShiftValue != 0) {
            bl = true;
        }
        switch (n6) {
            case 9: {
                bl = this.baselineShiftValue != 0;
                break;
            }
            case 157: {
                break;
            }
            case 87: {
                break;
            }
            case 116: {
                bl = true;
                break;
            }
            default: {
                bl = true;
                n7 = n6;
            }
        }
        this.actualBaselineTable = new ScaledBaselineTable(n, n2, n4, n7, this.scaledBaselineTable.getWritingMode());
        if (bl) {
            this.scaledBaselineTable = new ScaledBaselineTable(n, n2, n4, n7, this.scaledBaselineTable.getWritingMode());
        }
        this.setAlignmentAdjust(length);
    }

    AlignmentContext(Font font, int n, WritingMode writingMode) {
        this.areaHeight = font.getAscender() - font.getDescender();
        this.lineHeight = n;
        this.xHeight = font.getXHeight();
        this.actualBaselineTable = this.scaledBaselineTable = new ScaledBaselineTable(font.getAscender(), font.getDescender(), font.getXHeight(), 6, writingMode);
        this.alignmentBaselineIdentifier = this.getDominantBaselineIdentifier();
        this.alignmentPoint = font.getAscender();
        this.baselineShiftValue = 0;
    }

    public int getAlignmentPoint() {
        return this.alignmentPoint;
    }

    public int getBaselineShiftValue() {
        return this.baselineShiftValue;
    }

    public int getAlignmentBaselineIdentifier() {
        return this.alignmentBaselineIdentifier;
    }

    private void setAlignmentBaselineIdentifier(int n, int n2) {
        switch (n) {
            case 9: 
            case 12: {
                this.alignmentBaselineIdentifier = n2;
                break;
            }
            case 4: 
            case 6: 
            case 14: 
            case 24: 
            case 56: 
            case 59: 
            case 82: 
            case 84: 
            case 141: 
            case 142: {
                this.alignmentBaselineIdentifier = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
    }

    private void setAlignmentAdjust(Length length) {
        int n = this.actualBaselineTable.getBaseline(14);
        switch (length.getEnum()) {
            case 9: {
                this.alignmentPoint = n - this.actualBaselineTable.getBaseline(this.alignmentBaselineIdentifier);
                break;
            }
            case 12: {
                this.alignmentPoint = n;
                break;
            }
            case 4: 
            case 6: 
            case 14: 
            case 24: 
            case 56: 
            case 59: 
            case 82: 
            case 84: 
            case 141: 
            case 142: {
                this.alignmentPoint = n - this.actualBaselineTable.getBaseline(length.getEnum());
                break;
            }
            default: {
                this.alignmentPoint = n + length.getValue(new SimplePercentBaseContext(null, 12, this.lineHeight));
            }
        }
    }

    private ScaledBaselineTable getScaledBaselineTable() {
        return this.scaledBaselineTable;
    }

    private int getDominantBaselineIdentifier() {
        return this.actualBaselineTable.getDominantBaselineIdentifier();
    }

    private void setBaselineShift(Length length) {
        this.baselineShiftValue = 0;
        switch (length.getEnum()) {
            case 12: {
                break;
            }
            case 137: {
                this.baselineShiftValue = Math.round(-(this.xHeight / 2) + this.parentAlignmentContext.getActualBaselineOffset(6));
                break;
            }
            case 138: {
                this.baselineShiftValue = Math.round(this.parentAlignmentContext.getXHeight() + this.parentAlignmentContext.getActualBaselineOffset(6));
                break;
            }
            case 0: {
                this.baselineShiftValue = length.getValue(new SimplePercentBaseContext(null, 0, this.parentAlignmentContext.getLineHeight()));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(length.getEnum()));
            }
        }
    }

    public AlignmentContext getParentAlignmentContext() {
        return this.parentAlignmentContext;
    }

    private int getBaselineOffset() {
        if (this.parentAlignmentContext == null) {
            return 0;
        }
        return this.parentAlignmentContext.getScaledBaselineTable().getBaseline(this.alignmentBaselineIdentifier) - this.scaledBaselineTable.deriveScaledBaselineTable(this.parentAlignmentContext.getDominantBaselineIdentifier()).getBaseline(this.alignmentBaselineIdentifier) - this.scaledBaselineTable.getBaseline(this.parentAlignmentContext.getDominantBaselineIdentifier()) + this.baselineShiftValue;
    }

    private int getTotalBaselineOffset() {
        int n = 0;
        if (this.parentAlignmentContext != null) {
            n = this.getBaselineOffset() + this.parentAlignmentContext.getTotalBaselineOffset();
        }
        return n;
    }

    public int getTotalAlignmentBaselineOffset() {
        return this.getTotalAlignmentBaselineOffset(this.alignmentBaselineIdentifier);
    }

    private int getTotalAlignmentBaselineOffset(int n) {
        int n2 = this.baselineShiftValue;
        if (this.parentAlignmentContext != null) {
            n2 = this.parentAlignmentContext.getTotalBaselineOffset() + this.parentAlignmentContext.getScaledBaselineTable().getBaseline(n) + this.baselineShiftValue;
        }
        return n2;
    }

    private int getActualBaselineOffset(int n) {
        int n2 = this.getTotalAlignmentBaselineOffset() - this.getTotalBaselineOffset();
        return n2 += this.actualBaselineTable.deriveScaledBaselineTable(this.alignmentBaselineIdentifier).getBaseline(n);
    }

    private int getTotalTopOffset() {
        int n = this.getTotalAlignmentBaselineOffset() + this.getAltitude();
        return n;
    }

    public int getHeight() {
        return this.areaHeight;
    }

    private int getLineHeight() {
        return this.lineHeight;
    }

    public int getAltitude() {
        return this.alignmentPoint;
    }

    public int getDepth() {
        return this.getHeight() - this.alignmentPoint;
    }

    private int getXHeight() {
        return this.xHeight;
    }

    public void resizeLine(int n, int n2) {
        this.areaHeight = n;
        this.alignmentPoint = n2;
        this.scaledBaselineTable.setBeforeAndAfterBaselines(this.alignmentPoint, this.alignmentPoint - this.areaHeight);
    }

    public int getOffset() {
        int n = 0;
        n = this.parentAlignmentContext != null ? this.parentAlignmentContext.getTotalTopOffset() - this.getTotalTopOffset() : this.getAltitude() - this.scaledBaselineTable.getBaseline(142);
        return n;
    }

    public boolean usesInitialBaselineTable() {
        return this.parentAlignmentContext == null || this.scaledBaselineTable == this.parentAlignmentContext.getScaledBaselineTable() && this.parentAlignmentContext.usesInitialBaselineTable();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("areaHeight=").append(this.areaHeight);
        stringBuffer.append(" lineHeight=").append(this.lineHeight);
        stringBuffer.append(" alignmentPoint=").append(this.alignmentPoint);
        stringBuffer.append(" alignmentBaselineID=").append(this.alignmentBaselineIdentifier);
        stringBuffer.append(" baselineShift=").append(this.baselineShiftValue);
        return stringBuffer.toString();
    }
}

