/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.ListElement;

public abstract class BreakingAlgorithm {
    protected static final Log log = LogFactory.getLog(BreakingAlgorithm.class);
    protected static final int INFINITE_RATIO = 1000;
    private static final int MAX_RECOVERY_ATTEMPTS = 5;
    public static final int ALL_BREAKS = 0;
    public static final int NO_FLAGGED_PENALTIES = 1;
    public static final int ONLY_FORCED_BREAKS = 2;
    protected int repeatedFlaggedDemerit = 50;
    protected int incompatibleFitnessDemerit = 50;
    protected int maxFlaggedPenaltiesCount;
    private double threshold;
    protected KnuthSequence par;
    protected int lineWidth = -1;
    private boolean force = false;
    protected boolean considerTooShort = false;
    private KnuthNode lastTooLong;
    private KnuthNode lastTooShort;
    private KnuthNode lastDeactivated;
    protected int alignment;
    protected int alignmentLast;
    protected boolean indentFirstPart;
    protected KnuthNode[] activeLines;
    protected int activeNodeCount;
    protected int startLine = 0;
    protected int endLine = 0;
    protected int totalWidth;
    protected int totalStretch = 0;
    protected int totalShrink = 0;
    protected BestRecords best;
    private boolean partOverflowRecoveryActivated = true;
    private KnuthNode lastRecovered;

    public BreakingAlgorithm(int n, int n2, boolean bl, boolean bl2, int n3) {
        this.alignment = n;
        this.alignmentLast = n2;
        this.indentFirstPart = bl;
        this.partOverflowRecoveryActivated = bl2;
        this.best = new BestRecords();
        this.maxFlaggedPenaltiesCount = n3;
    }

    protected int getMaxRecoveryAttempts() {
        return 5;
    }

    protected boolean isPartOverflowRecoveryActivated() {
        return this.partOverflowRecoveryActivated;
    }

    public abstract void updateData1(int var1, double var2);

    public abstract void updateData2(KnuthNode var1, KnuthSequence var2, int var3);

    public void setConstantLineWidth(int n) {
        this.lineWidth = n;
    }

    public int findBreakingPoints(KnuthSequence knuthSequence, double d, boolean bl, int n) {
        return this.findBreakingPoints(knuthSequence, 0, d, bl, n);
    }

    public int findBreakingPoints(KnuthSequence knuthSequence, int n, double d, boolean bl, int n2) {
        int n3;
        this.par = knuthSequence;
        this.threshold = d;
        this.force = bl;
        this.initialize();
        boolean bl2 = false;
        int n4 = n;
        if (this.alignment != 23) {
            n4 = knuthSequence.getFirstBoxIndex(n);
        }
        n4 = n4 < 0 ? 0 : n4;
        this.addNode(0, this.createNode(n4, 0, 1, 0, 0, 0, 0.0, 0, 0, 0, 0.0, null));
        KnuthNode knuthNode = this.getNode(0);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Looping over " + (knuthSequence.size() - n) + " elements"));
            log.trace((Object)knuthSequence);
        }
        for (n3 = n; n3 < knuthSequence.size(); ++n3) {
            bl2 = this.handleElementAt(n3, bl2, n2).isBox();
            if (this.activeNodeCount != 0) continue;
            if (this.getIPDdifference() != 0) {
                return this.handleIpdChange();
            }
            if (!bl) {
                log.debug((Object)("Could not find a set of breaking points " + d));
                return 0;
            }
            if (this.lastDeactivated != null && this.lastDeactivated != knuthNode) {
                this.replaceLastDeactivated();
            }
            if (this.lastTooShort == null || knuthNode.position == this.lastTooShort.position) {
                knuthNode = this.recoverFromOverflow();
            } else {
                knuthNode = this.lastTooShort;
                this.lastRecovered = null;
            }
            n3 = this.restartFrom(knuthNode, n3);
        }
        this.finish();
        n3 = this.filterActiveNodes();
        for (int i = this.startLine; i < this.endLine; ++i) {
            KnuthNode knuthNode2 = this.getNode(i);
            while (knuthNode2 != null) {
                this.updateData1(knuthNode2.line, knuthNode2.totalDemerits);
                this.calculateBreakPoints(knuthNode2, knuthSequence, knuthNode2.line);
                knuthNode2 = knuthNode2.next;
            }
        }
        this.activeLines = null;
        return n3;
    }

    protected int getIPDdifference() {
        return 0;
    }

    protected int handleIpdChange() {
        throw new IllegalStateException();
    }

    protected KnuthNode recoverFromTooLong(KnuthNode knuthNode) {
        ListElement listElement;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recovering from too long: " + knuthNode));
        }
        if (knuthNode.previous.previous == null && !(listElement = (ListElement)this.par.get(0)).isPenalty()) {
            this.par.add(0, KnuthPenalty.DUMMY_ZERO_PENALTY);
        }
        return this.createNode(knuthNode.previous.position, knuthNode.previous.line + 1, 1, 0, 0, 0, 0.0, 0, 0, 0, 0.0, knuthNode.previous);
    }

    protected void initialize() {
        this.totalWidth = 0;
        this.totalStretch = 0;
        this.totalShrink = 0;
        this.lastTooShort = null;
        this.lastTooLong = null;
        this.startLine = 0;
        this.endLine = 0;
        this.activeLines = new KnuthNode[20];
    }

    protected KnuthNode createNode(int n, int n2, int n3, int n4, int n5, int n6, double d, int n7, int n8, int n9, double d2, KnuthNode knuthNode) {
        return new KnuthNode(n, n2, n3, n4, n5, n6, d, n7, n8, n9, d2, knuthNode);
    }

    protected KnuthNode createNode(int n, int n2, int n3, int n4, int n5, int n6) {
        return new KnuthNode(n, n2, n3, n4, n5, n6, this.best.getAdjust(n3), this.best.getAvailableShrink(n3), this.best.getAvailableStretch(n3), this.best.getDifference(n3), this.best.getDemerits(n3), this.best.getNode(n3));
    }

    protected final KnuthNode getLastTooShort() {
        return this.lastTooShort;
    }

    protected final KnuthElement handleElementAt(int n, boolean bl, int n2) {
        KnuthElement knuthElement = this.getElement(n);
        if (knuthElement.isBox()) {
            this.handleBox((KnuthBox)knuthElement);
        } else if (knuthElement.isGlue()) {
            this.handleGlueAt((KnuthGlue)knuthElement, n, bl, n2);
        } else if (knuthElement.isPenalty()) {
            this.handlePenaltyAt((KnuthPenalty)knuthElement, n, n2);
        } else {
            throw new IllegalArgumentException("Unknown KnuthElement type: expecting KnuthBox, KnuthGlue or KnuthPenalty");
        }
        return knuthElement;
    }

    protected void handleBox(KnuthBox knuthBox) {
        this.totalWidth += knuthBox.getWidth();
    }

    protected void handleGlueAt(KnuthGlue knuthGlue, int n, boolean bl, int n2) {
        if (bl && n2 != 2) {
            this.considerLegalBreak(knuthGlue, n);
        }
        this.totalWidth += knuthGlue.getWidth();
        this.totalStretch += knuthGlue.getStretch();
        this.totalShrink += knuthGlue.getShrink();
    }

    protected void handlePenaltyAt(KnuthPenalty knuthPenalty, int n, int n2) {
        if (!(knuthPenalty.getPenalty() >= 1000 || n2 == 1 && knuthPenalty.isPenaltyFlagged() || n2 == 2 && !knuthPenalty.isForcedBreak())) {
            this.considerLegalBreak(knuthPenalty, n);
        }
    }

    protected final void replaceLastDeactivated() {
        if (this.lastDeactivated.adjustRatio > 0.0) {
            this.lastTooShort = this.lastDeactivated;
        } else {
            this.lastTooLong = this.lastDeactivated;
        }
    }

    protected KnuthNode recoverFromOverflow() {
        KnuthNode knuthNode;
        if (this.isPartOverflowRecoveryActivated()) {
            KnuthNode knuthNode2;
            if (this.lastRecovered == null) {
                this.lastRecovered = this.lastTooLong;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Recovery point: " + this.lastRecovered));
                }
            }
            knuthNode = knuthNode2 = this.recoverFromTooLong(this.lastTooLong);
            knuthNode2.fitRecoveryCounter = this.lastTooLong.previous.fitRecoveryCounter + 1;
            if (log.isDebugEnabled()) {
                log.debug((Object)("first part doesn't fit into line, recovering: " + knuthNode2.fitRecoveryCounter));
            }
            if (knuthNode2.fitRecoveryCounter > this.getMaxRecoveryAttempts()) {
                while (knuthNode.fitRecoveryCounter > 0 && knuthNode.previous != null) {
                    knuthNode = knuthNode.previous;
                    this.lastDeactivated = knuthNode.previous;
                }
                knuthNode = this.lastRecovered;
                this.lastRecovered = null;
                this.startLine = knuthNode.line;
                this.endLine = knuthNode.line;
                log.debug((Object)"rolled back...");
            }
        } else {
            knuthNode = this.lastTooLong;
        }
        return knuthNode;
    }

    protected int restartFrom(KnuthNode knuthNode, int n) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restarting at node " + knuthNode));
        }
        knuthNode.totalDemerits = 0.0;
        this.addNode(knuthNode.line, knuthNode);
        this.startLine = knuthNode.line;
        this.endLine = this.startLine + 1;
        this.totalWidth = knuthNode.totalWidth;
        this.totalStretch = knuthNode.totalStretch;
        this.totalShrink = knuthNode.totalShrink;
        this.lastTooShort = null;
        this.lastTooLong = null;
        int n2 = knuthNode.position;
        while (n2 + 1 < this.par.size() && !this.getElement(n2 + 1).isBox()) {
            ++n2;
        }
        return n2;
    }

    protected void considerLegalBreak(KnuthElement knuthElement, int n) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("considerLegalBreak() at " + n + " (" + this.totalWidth + "+" + this.totalStretch + "-" + this.totalShrink + "), parts/lines: " + this.startLine + "-" + this.endLine));
            log.trace((Object)("\tCurrent active node list: " + this.activeNodeCount + " " + this.toString("\t")));
        }
        this.lastDeactivated = null;
        this.lastTooLong = null;
        for (int i = this.startLine; i < this.endLine; ++i) {
            KnuthNode knuthNode = this.getNode(i);
            while (knuthNode != null) {
                if (knuthNode.position != n) {
                    int n2 = this.computeDifference(knuthNode, knuthElement, n);
                    if (!this.elementCanEndLine(knuthElement, this.endLine, n2)) {
                        log.trace((Object)"Skipping legal break");
                        break;
                    }
                    double d = this.computeAdjustmentRatio(knuthNode, n2);
                    int n3 = this.totalShrink - knuthNode.totalShrink;
                    int n4 = this.totalStretch - knuthNode.totalStretch;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("\tr=" + d + " difference=" + n2));
                        log.trace((Object)("\tline=" + i));
                    }
                    if (d < -1.0 || knuthElement.isForcedBreak()) {
                        this.deactivateNode(knuthNode, i);
                    }
                    int n5 = FitnessClasses.computeFitness(d);
                    double d2 = this.computeDemerits(knuthNode, knuthElement, n5, d);
                    if (d >= -1.0 && d <= this.threshold) {
                        this.activateNode(knuthNode, n2, d, d2, n5, n3, n4);
                    }
                    if (this.force && (d <= -1.0 || d > this.threshold)) {
                        this.forceNode(knuthNode, i, n, n2, d, d2, n5, n3, n4);
                    }
                }
                knuthNode = knuthNode.next;
            }
            this.addBreaks(i, n);
        }
    }

    protected boolean elementCanEndLine(KnuthElement knuthElement, int n, int n2) {
        return !knuthElement.isPenalty() || knuthElement.getPenalty() < 1000;
    }

    protected void forceNode(KnuthNode knuthNode, int n, int n2, int n3, double d, double d2, int n4, int n5, int n6) {
        KnuthElement knuthElement;
        int n7 = this.totalWidth;
        int n8 = this.totalStretch;
        int n9 = this.totalShrink;
        for (int i = n2; i < this.par.size() && !(knuthElement = this.getElement(i)).isBox(); ++i) {
            if (knuthElement.isGlue()) {
                n7 += knuthElement.getWidth();
                n8 += knuthElement.getStretch();
                n9 += knuthElement.getShrink();
                continue;
            }
            if (knuthElement.isForcedBreak() && i != n2) break;
        }
        if (d <= -1.0) {
            log.debug((Object)("Considering tooLong, demerits=" + d2));
            if (this.lastTooLong == null || d2 < this.lastTooLong.totalDemerits) {
                this.lastTooLong = this.createNode(n2, n + 1, n4, n7, n8, n9, d, n5, n6, n3, d2, knuthNode);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Picking tooLong " + this.lastTooLong));
                }
            }
        } else if (this.lastTooShort == null || d2 <= this.lastTooShort.totalDemerits) {
            if (this.considerTooShort) {
                this.best.addRecord(d2, knuthNode, d, n5, n6, n3, n4);
            }
            this.lastTooShort = this.createNode(n2, n + 1, n4, n7, n8, n9, d, n5, n6, n3, d2, knuthNode);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Picking tooShort " + this.lastTooShort));
            }
        }
    }

    protected void activateNode(KnuthNode knuthNode, int n, double d, double d2, int n2, int n3, int n4) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("\tDemerits=" + d2));
            log.trace((Object)("\tFitness class=" + FitnessClasses.NAMES[n2]));
        }
        if (d2 < this.best.getDemerits(n2)) {
            this.best.addRecord(d2, knuthNode, d, n3, n4, n, n2);
            this.lastTooShort = null;
        }
    }

    protected void deactivateNode(KnuthNode knuthNode, int n) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing " + knuthNode));
        }
        this.removeNode(n, knuthNode);
        this.lastDeactivated = this.compareNodes(this.lastDeactivated, knuthNode);
    }

    private void addBreaks(int n, int n2) {
        KnuthElement knuthElement;
        if (!this.best.hasRecords()) {
            return;
        }
        int n3 = this.totalWidth;
        int n4 = this.totalStretch;
        int n5 = this.totalShrink;
        for (int i = n2; i < this.par.size() && !(knuthElement = this.getElement(i)).isBox(); ++i) {
            if (knuthElement.isGlue()) {
                n3 += knuthElement.getWidth();
                n4 += knuthElement.getStretch();
                n5 += knuthElement.getShrink();
                continue;
            }
            if (knuthElement.isForcedBreak() && i != n2) break;
        }
        double d = this.best.getMinDemerits() + (double)this.incompatibleFitnessDemerit;
        for (int i = 0; i <= 3; ++i) {
            if (!this.best.notInfiniteDemerits(i) || !(this.best.getDemerits(i) <= d)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("\tInsert new break in list of " + this.activeNodeCount + " from fitness class " + FitnessClasses.NAMES[i]));
            }
            KnuthNode knuthNode = this.createNode(n2, n + 1, i, n3, n4, n5);
            this.addNode(n + 1, knuthNode);
        }
        this.best.reset();
    }

    protected int computeDifference(KnuthNode knuthNode, KnuthElement knuthElement, int n) {
        int n2 = this.totalWidth - knuthNode.totalWidth;
        if (knuthElement.isPenalty()) {
            n2 += knuthElement.getWidth();
        }
        return this.getLineWidth() - n2;
    }

    protected double computeAdjustmentRatio(KnuthNode knuthNode, int n) {
        if (n > 0) {
            int n2 = this.totalStretch - knuthNode.totalStretch;
            if (n2 > 0) {
                return (double)n / (double)n2;
            }
            return 1000.0;
        }
        if (n < 0) {
            int n3 = this.totalShrink - knuthNode.totalShrink;
            if (n3 > 0) {
                return (double)n / (double)n3;
            }
            return -1000.0;
        }
        return 0.0;
    }

    protected double computeDemerits(KnuthNode knuthNode, KnuthElement knuthElement, int n, double d) {
        double d2;
        double d3 = 0.0;
        double d4 = Math.abs(d);
        d4 = 1.0 + 100.0 * d4 * d4 * d4;
        d3 = knuthElement.isPenalty() ? ((d2 = (double)knuthElement.getPenalty()) >= 0.0 ? (d4 += d2) * d4 : (!knuthElement.isForcedBreak() ? d4 * d4 - d2 * d2 : d4 * d4)) : d4 * d4;
        if (knuthElement.isPenalty() && ((KnuthPenalty)knuthElement).isPenaltyFlagged() && this.getElement(knuthNode.position).isPenalty() && ((KnuthPenalty)this.getElement(knuthNode.position)).isPenaltyFlagged()) {
            KnuthElement knuthElement2;
            int n2;
            d3 += (double)this.repeatedFlaggedDemerit;
            KnuthNode knuthNode2 = knuthNode.previous;
            for (n2 = 2; knuthNode2 != null && n2 <= this.maxFlaggedPenaltiesCount && (knuthElement2 = this.getElement(knuthNode2.position)).isPenalty() && ((KnuthPenalty)knuthElement2).isPenaltyFlagged(); ++n2) {
                knuthNode2 = knuthNode2.previous;
            }
            if (this.maxFlaggedPenaltiesCount >= 1 && n2 > this.maxFlaggedPenaltiesCount) {
                d3 += Double.POSITIVE_INFINITY;
            }
        }
        if (Math.abs(n - knuthNode.fitness) > 1) {
            d3 += (double)this.incompatibleFitnessDemerit;
        }
        return d3 += knuthNode.totalDemerits;
    }

    protected void finish() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Main loop completed " + this.activeNodeCount));
            log.trace((Object)("Active nodes=" + this.toString("")));
        }
    }

    protected KnuthElement getElement(int n) {
        return (KnuthElement)this.par.get(n);
    }

    protected KnuthNode compareNodes(KnuthNode knuthNode, KnuthNode knuthNode2) {
        if (knuthNode == null || knuthNode2.position > knuthNode.position) {
            return knuthNode2;
        }
        if (knuthNode2.position == knuthNode.position && knuthNode2.totalDemerits < knuthNode.totalDemerits) {
            return knuthNode2;
        }
        return knuthNode;
    }

    protected void addNode(int n, KnuthNode knuthNode) {
        int n2 = n * 2;
        if (n2 >= this.activeLines.length) {
            KnuthNode[] knuthNodeArray = this.activeLines;
            this.activeLines = new KnuthNode[n2 + n2];
            System.arraycopy(knuthNodeArray, 0, this.activeLines, 0, knuthNodeArray.length);
        }
        knuthNode.next = null;
        if (this.activeLines[n2 + 1] != null) {
            this.activeLines[n2 + 1].next = knuthNode;
        } else {
            this.activeLines[n2] = knuthNode;
            this.endLine = n + 1;
        }
        this.activeLines[n2 + 1] = knuthNode;
        ++this.activeNodeCount;
    }

    protected void removeNode(int n, KnuthNode knuthNode) {
        int n2 = n * 2;
        KnuthNode knuthNode2 = this.getNode(n);
        if (knuthNode2 != knuthNode) {
            KnuthNode knuthNode3 = null;
            while (knuthNode2 != knuthNode) {
                knuthNode3 = knuthNode2;
                knuthNode2 = knuthNode2.next;
            }
            knuthNode3.next = knuthNode2.next;
            if (knuthNode3.next == null) {
                this.activeLines[n2 + 1] = knuthNode3;
            }
        } else {
            this.activeLines[n2] = knuthNode.next;
            if (knuthNode.next == null) {
                this.activeLines[n2 + 1] = null;
            }
            while (this.startLine < this.endLine && this.getNode(this.startLine) == null) {
                ++this.startLine;
            }
        }
        --this.activeNodeCount;
    }

    protected KnuthNode getNode(int n) {
        return this.activeLines[n * 2];
    }

    protected int getLineWidth(int n) {
        assert (this.lineWidth >= 0);
        return this.lineWidth;
    }

    protected int getLineWidth() {
        return this.lineWidth;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        for (int i = this.startLine; i < this.endLine; ++i) {
            KnuthNode knuthNode = this.getNode(i);
            while (knuthNode != null) {
                stringBuffer.append(string).append('\t').append(knuthNode).append(",\n");
                knuthNode = knuthNode.next;
            }
        }
        stringBuffer.append(string).append("]");
        return stringBuffer.toString();
    }

    protected abstract int filterActiveNodes();

    protected void calculateBreakPoints(KnuthNode knuthNode, KnuthSequence knuthSequence, int n) {
        KnuthNode knuthNode2 = knuthNode;
        for (int i = knuthNode.line; i > 0; --i) {
            this.updateData2(knuthNode2, knuthSequence, n);
            knuthNode2 = knuthNode2.previous;
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getAlignmentLast() {
        return this.alignmentLast;
    }

    protected class BestRecords {
        private static final double INFINITE_DEMERITS = Double.POSITIVE_INFINITY;
        private double[] bestDemerits = new double[4];
        private KnuthNode[] bestNode = new KnuthNode[4];
        private double[] bestAdjust = new double[4];
        private int[] bestDifference = new int[4];
        private int[] bestAvailableShrink = new int[4];
        private int[] bestAvailableStretch = new int[4];
        private int bestIndex = -1;

        public BestRecords() {
            this.reset();
        }

        public void addRecord(double d, KnuthNode knuthNode, double d2, int n, int n2, int n3, int n4) {
            if (d > this.bestDemerits[n4]) {
                log.error((Object)"New demerits value greater than the old one");
            }
            this.bestDemerits[n4] = d;
            this.bestNode[n4] = knuthNode;
            this.bestAdjust[n4] = d2;
            this.bestAvailableShrink[n4] = n;
            this.bestAvailableStretch[n4] = n2;
            this.bestDifference[n4] = n3;
            if (this.bestIndex == -1 || d < this.bestDemerits[this.bestIndex]) {
                this.bestIndex = n4;
            }
        }

        public boolean hasRecords() {
            return this.bestIndex != -1;
        }

        public boolean notInfiniteDemerits(int n) {
            return this.bestDemerits[n] != Double.POSITIVE_INFINITY;
        }

        public double getDemerits(int n) {
            return this.bestDemerits[n];
        }

        public KnuthNode getNode(int n) {
            return this.bestNode[n];
        }

        public double getAdjust(int n) {
            return this.bestAdjust[n];
        }

        public int getAvailableShrink(int n) {
            return this.bestAvailableShrink[n];
        }

        public int getAvailableStretch(int n) {
            return this.bestAvailableStretch[n];
        }

        public int getDifference(int n) {
            return this.bestDifference[n];
        }

        public double getMinDemerits() {
            if (this.bestIndex != -1) {
                return this.getDemerits(this.bestIndex);
            }
            return Double.POSITIVE_INFINITY;
        }

        public void reset() {
            for (int i = 0; i < 4; ++i) {
                this.bestDemerits[i] = Double.POSITIVE_INFINITY;
            }
            this.bestIndex = -1;
        }
    }

    public class KnuthNode {
        public final int position;
        public final int line;
        public final int fitness;
        public final int totalWidth;
        public final int totalStretch;
        public final int totalShrink;
        public final double adjustRatio;
        public final int availableShrink;
        public final int availableStretch;
        public final int difference;
        public double totalDemerits;
        public KnuthNode previous;
        public KnuthNode next;
        public int fitRecoveryCounter = 0;

        public KnuthNode(int n, int n2, int n3, int n4, int n5, int n6, double d, int n7, int n8, int n9, double d2, KnuthNode knuthNode) {
            this.position = n;
            this.line = n2;
            this.fitness = n3;
            this.totalWidth = n4;
            this.totalStretch = n5;
            this.totalShrink = n6;
            this.adjustRatio = d;
            this.availableShrink = n7;
            this.availableStretch = n8;
            this.difference = n9;
            this.totalDemerits = d2;
            this.previous = knuthNode;
        }

        public String toString() {
            return "<KnuthNode at " + this.position + " " + this.totalWidth + "+" + this.totalStretch + "-" + this.totalShrink + " line:" + this.line + " prev:" + (this.previous != null ? this.previous.position : -1) + " dem:" + this.totalDemerits + " fitness:" + FitnessClasses.NAMES[this.fitness] + ">";
        }
    }

    static final class FitnessClasses {
        static final int VERY_TIGHT = 0;
        static final int TIGHT = 1;
        static final int LOOSE = 2;
        static final int VERY_LOOSE = 3;
        static final String[] NAMES = new String[]{"VERY TIGHT", "TIGHT", "LOOSE", "VERY LOOSE"};

        private FitnessClasses() {
        }

        static int computeFitness(double d) {
            if (d < -0.5) {
                return 0;
            }
            if (d <= 0.5) {
                return 1;
            }
            if (d <= 1.0) {
                return 2;
            }
            return 3;
        }
    }
}

