/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.io.IOException;
import java.util.Map;
import org.apache.fop.image.loader.batik.ImageWMF;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;

public class ImageLoaderWMF
extends AbstractImageLoader {
    private ImageFlavor targetFlavor;

    public ImageLoaderWMF(ImageFlavor imageFlavor) {
        if (!ImageWMF.WMF_IMAGE.equals((Object)imageFlavor)) {
            throw new IllegalArgumentException("Unsupported target ImageFlavor: " + imageFlavor);
        }
        this.targetFlavor = imageFlavor;
    }

    public ImageFlavor getTargetFlavor() {
        return this.targetFlavor;
    }

    public Image loadImage(ImageInfo imageInfo, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        if (!"image/x-wmf".equals(imageInfo.getMimeType())) {
            throw new IllegalArgumentException("ImageInfo must be from a WMF image");
        }
        Image image = imageInfo.getOriginalImage();
        if (!(image instanceof ImageWMF)) {
            throw new IllegalArgumentException("ImageInfo was expected to contain the Windows Metafile (WMF)");
        }
        ImageWMF imageWMF = (ImageWMF)image;
        return imageWMF;
    }
}

