/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImageConverterG2D2SVG
extends AbstractImageConverter {
    public Image convert(Image image, Map map) throws ImageException {
        this.checkSourceFlavor(image);
        ImageGraphics2D imageGraphics2D = (ImageGraphics2D)image;
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
        Element element = document.getDocumentElement();
        SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault((Document)document);
        sVGGeneratorContext.setComment("Generated by Apache Batik's SVGGraphics2D");
        sVGGeneratorContext.setEmbeddedFontsOn(true);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(sVGGeneratorContext, true);
        ImageSize imageSize = image.getSize();
        Dimension dimension = imageSize.getDimensionMpt();
        sVGGraphics2D.setSVGCanvasSize(dimension);
        element.setAttribute("viewBox", "0 0 " + dimension.width + " " + dimension.height);
        imageGraphics2D.getGraphics2DImagePainter().paint((Graphics2D)sVGGraphics2D, (Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height));
        sVGGraphics2D.getRoot(element);
        ImageXMLDOM imageXMLDOM = new ImageXMLDOM(image.getInfo(), document, BatikImageFlavors.SVG_DOM);
        sVGGraphics2D.dispose();
        return imageXMLDOM;
    }

    public ImageFlavor getSourceFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }

    public ImageFlavor getTargetFlavor() {
        return BatikImageFlavors.SVG_DOM;
    }
}

