/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;

public class Graphics2DImagePainterImpl
implements Graphics2DImagePainter {
    private final GraphicsNode root;
    protected final BridgeContext ctx;
    protected final Dimension imageSize;

    public Graphics2DImagePainterImpl(GraphicsNode graphicsNode, BridgeContext bridgeContext, Dimension dimension) {
        this.root = graphicsNode;
        this.imageSize = dimension;
        this.ctx = bridgeContext;
    }

    public Dimension getImageSize() {
        return this.imageSize;
    }

    private void prepare(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        if (d != 0.0 || d2 != 0.0) {
            graphics2D.translate(d, d2);
        }
        float f = (float)this.ctx.getDocumentSize().getWidth();
        float f2 = (float)this.ctx.getDocumentSize().getHeight();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        float f5 = f3 / f;
        float f6 = f4 / f2;
        if ((double)f5 != 1.0 || (double)f6 != 1.0) {
            graphics2D.scale(f5, f6);
        }
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.prepare(graphics2D, rectangle2D);
        this.root.paint(graphics2D);
    }
}

