/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.type1.PFMInputStream;
import org.apache.xmlgraphics.fonts.Glyphs;

public class PFMFile {
    private String windowsName;
    private String postscriptName;
    private short dfItalic;
    private int dfWeight;
    private short dfCharSet;
    private short dfPitchAndFamily;
    private int dfAvgWidth;
    private int dfMaxWidth;
    private int dfMinWidth;
    private short dfFirstChar;
    private short dfLastChar;
    private int etmCapHeight;
    private int etmXHeight;
    private int etmLowerCaseAscent;
    private int etmLowerCaseDescent;
    private int[] extentTable;
    private Map kerningTab = new HashMap();
    protected Log log = LogFactory.getLog(PFMFile.class);

    public void load(InputStream inputStream) throws IOException {
        byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
        InputStream inputStream2 = inputStream;
        inputStream2 = new ByteArrayInputStream(byArray);
        PFMInputStream pFMInputStream = new PFMInputStream(inputStream2);
        inputStream2.mark(512);
        short s = pFMInputStream.readByte();
        short s2 = pFMInputStream.readByte();
        if (s == 128 && s2 == 1) {
            throw new IOException("Cannot parse PFM file. You probably specified the PFB file of a Type 1 font as parameter instead of the PFM.");
        }
        inputStream2.reset();
        byte[] byArray2 = new byte[16];
        inputStream2.read(byArray2);
        if (new String(byArray2, "US-ASCII").equalsIgnoreCase("StartFontMetrics")) {
            throw new IOException("Cannot parse PFM file. You probably specified the AFM file of a Type 1 font as parameter instead of the PFM.");
        }
        inputStream2.reset();
        int n = pFMInputStream.readShort();
        if (n != 256) {
            this.log.warn((Object)("PFM version expected to be '256' but got '" + n + "'." + " Please make sure you specify the PFM as parameter" + " and not the PFB or the AFM."));
        }
        inputStream2.reset();
        this.loadHeader(pFMInputStream);
        this.loadExtension(pFMInputStream);
    }

    private void loadHeader(PFMInputStream pFMInputStream) throws IOException {
        pFMInputStream.skip(80L);
        this.dfItalic = pFMInputStream.readByte();
        pFMInputStream.skip(2L);
        this.dfWeight = pFMInputStream.readShort();
        this.dfCharSet = pFMInputStream.readByte();
        pFMInputStream.skip(4L);
        this.dfPitchAndFamily = pFMInputStream.readByte();
        this.dfAvgWidth = pFMInputStream.readShort();
        this.dfMaxWidth = pFMInputStream.readShort();
        this.dfFirstChar = pFMInputStream.readByte();
        this.dfLastChar = pFMInputStream.readByte();
        pFMInputStream.skip(8L);
        long l = pFMInputStream.readInt();
        pFMInputStream.reset();
        pFMInputStream.skip(l);
        this.windowsName = pFMInputStream.readString();
        pFMInputStream.reset();
        pFMInputStream.skip(117L);
    }

    private void loadExtension(PFMInputStream pFMInputStream) throws IOException {
        int n = pFMInputStream.readShort();
        if (n != 30) {
            this.log.warn((Object)("Size of extension block was expected to be 30 bytes, but was " + n + " bytes."));
        }
        long l = pFMInputStream.readInt();
        long l2 = pFMInputStream.readInt();
        pFMInputStream.skip(4L);
        long l3 = pFMInputStream.readInt();
        pFMInputStream.skip(4L);
        long l4 = pFMInputStream.readInt();
        if (l3 > 0L) {
            pFMInputStream.reset();
            pFMInputStream.skip(l3);
            this.loadKernPairs(pFMInputStream);
        }
        pFMInputStream.reset();
        pFMInputStream.skip(l4);
        this.postscriptName = pFMInputStream.readString();
        if (l != 0L) {
            pFMInputStream.reset();
            pFMInputStream.skip(l);
            this.loadExtMetrics(pFMInputStream);
        }
        if (l2 != 0L) {
            pFMInputStream.reset();
            pFMInputStream.skip(l2);
            this.loadExtentTable(pFMInputStream);
        }
    }

    private void loadKernPairs(PFMInputStream pFMInputStream) throws IOException {
        int n = pFMInputStream.readShort();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(n + " kerning pairs"));
        }
        while (n > 0) {
            Object object;
            short s = pFMInputStream.readByte();
            --n;
            short s2 = pFMInputStream.readByte();
            int n2 = pFMInputStream.readShort();
            if (n2 > 32768) {
                n2 = -(65536 - n2);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Char no: (" + s + ", " + s2 + ") kern: " + n2));
                object = Glyphs.TEX8R_GLYPH_NAMES[s];
                String string = Glyphs.TEX8R_GLYPH_NAMES[s2];
                this.log.trace((Object)("glyphs: " + (String)object + ", " + string));
            }
            if ((object = (HashMap<Integer, Integer>)this.kerningTab.get(new Integer(s))) == null) {
                object = new HashMap<Integer, Integer>();
            }
            object.put(new Integer(s2), new Integer(n2));
            this.kerningTab.put(new Integer(s), object);
        }
    }

    private void loadExtMetrics(PFMInputStream pFMInputStream) throws IOException {
        int n = pFMInputStream.readShort();
        if (n != 52) {
            this.log.warn((Object)("Size of extension block was expected to be 52 bytes, but was " + n + " bytes."));
        }
        pFMInputStream.skip(12L);
        this.etmCapHeight = pFMInputStream.readShort();
        this.etmXHeight = pFMInputStream.readShort();
        this.etmLowerCaseAscent = pFMInputStream.readShort();
        this.etmLowerCaseDescent = -pFMInputStream.readShort();
    }

    private void loadExtentTable(PFMInputStream pFMInputStream) throws IOException {
        this.extentTable = new int[this.dfLastChar - this.dfFirstChar + 1];
        this.dfMinWidth = this.dfMaxWidth;
        for (short s = this.dfFirstChar; s <= this.dfLastChar; s = (short)(s + 1)) {
            this.extentTable[s - this.dfFirstChar] = pFMInputStream.readShort();
            if (this.extentTable[s - this.dfFirstChar] >= this.dfMinWidth) continue;
            this.dfMinWidth = this.extentTable[s - this.dfFirstChar];
        }
    }

    public String getWindowsName() {
        return this.windowsName;
    }

    public Map getKerning() {
        return this.kerningTab;
    }

    public String getPostscriptName() {
        return this.postscriptName;
    }

    public short getCharSet() {
        return this.dfCharSet;
    }

    public String getCharSetName() {
        switch (this.dfCharSet) {
            case 0: {
                return "WinAnsi";
            }
            case 2: {
                if (!"Symbol".equals(this.getPostscriptName())) break;
                return "Symbol";
            }
            case 128: {
                return "Shift-JIS (Japanese)";
            }
            default: {
                this.log.warn((Object)("Unknown charset detected (" + this.dfCharSet + ", 0x" + Integer.toHexString(this.dfCharSet) + "). Trying fallback to WinAnsi."));
            }
        }
        return "WinAnsi";
    }

    public short getFirstChar() {
        return this.dfFirstChar;
    }

    public short getLastChar() {
        return this.dfLastChar;
    }

    public int getCapHeight() {
        return this.etmCapHeight;
    }

    public int getXHeight() {
        return this.etmXHeight;
    }

    public int getLowerCaseAscent() {
        return this.etmLowerCaseAscent;
    }

    public int getLowerCaseDescent() {
        return this.etmLowerCaseDescent;
    }

    public boolean getIsProportional() {
        return (this.dfPitchAndFamily & 1) == 1;
    }

    public int[] getFontBBox() {
        int[] nArray = new int[]{!this.getIsProportional() && this.dfAvgWidth == this.dfMaxWidth ? -20 : -100, this.getLowerCaseDescent() - 5, this.dfMaxWidth + 10, this.getLowerCaseAscent() + 5};
        return nArray;
    }

    public boolean isNonSymbolic() {
        return this.dfCharSet != 2;
    }

    public int getFlags() {
        int n = 0;
        if (!this.getIsProportional()) {
            n |= 1;
        }
        n = this.isNonSymbolic() ? (n |= 0x20) : (n |= 4);
        if ((this.dfPitchAndFamily & 0x10) != 0) {
            n |= 2;
        }
        if ((this.dfPitchAndFamily & 0x40) != 0) {
            n |= 8;
        }
        if (this.dfItalic != 0) {
            n |= 0x40;
        }
        return n;
    }

    public int getStemV() {
        if (this.dfItalic != 0) {
            return (int)Math.round((double)this.dfMinWidth * 0.25);
        }
        return (int)Math.round((double)this.dfMinWidth * 0.6);
    }

    public int getItalicAngle() {
        if (this.dfItalic != 0) {
            return -16;
        }
        return 0;
    }

    public int getCharWidth(short s) {
        if (this.extentTable != null) {
            return this.extentTable[s - this.dfFirstChar];
        }
        return this.dfAvgWidth;
    }
}

