/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.awt.geom.Dimension2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.NamedCharacter;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.type1.AFMCharMetrics;
import org.apache.fop.fonts.type1.AFMWritingDirectionMetrics;
import org.apache.xmlgraphics.java2d.Dimension2DDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AFMFile {
    private static final Log LOG = LogFactory.getLog(AFMFile.class);
    private String fontName;
    private String fullName;
    private String familyName;
    private String weight;
    private RectangularShape fontBBox;
    private String encodingScheme;
    private String characterSet;
    private Number capHeight;
    private Number xHeight;
    private Number ascender;
    private Number descender;
    private Number stdHW;
    private Number stdVW;
    private AFMWritingDirectionMetrics[] writingDirectionMetrics = new AFMWritingDirectionMetrics[3];
    private List<AFMCharMetrics> charMetrics = new ArrayList<AFMCharMetrics>();
    private Map<String, AFMCharMetrics> charNameToMetrics = new HashMap<String, AFMCharMetrics>();
    private int firstChar = -1;
    private int lastChar = -1;
    private Map<String, Map<String, Dimension2D>> kerningMap;

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String string) {
        this.fullName = string;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String string) {
        this.familyName = string;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String string) {
        this.weight = string;
    }

    public RectangularShape getFontBBox() {
        return this.fontBBox;
    }

    public int[] getFontBBoxAsIntArray() {
        RectangularShape rectangularShape = this.getFontBBox();
        return new int[]{(int)Math.floor(rectangularShape.getMinX()), (int)Math.floor(rectangularShape.getMinY()), (int)Math.ceil(rectangularShape.getMaxX()), (int)Math.ceil(rectangularShape.getMaxY())};
    }

    public void setFontBBox(RectangularShape rectangularShape) {
        this.fontBBox = rectangularShape;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(String string) {
        this.encodingScheme = string;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String string) {
        this.characterSet = string;
    }

    public Number getCapHeight() {
        return this.capHeight;
    }

    public void setCapHeight(Number number) {
        this.capHeight = number;
    }

    public Number getXHeight() {
        return this.xHeight;
    }

    public void setXHeight(Number number) {
        this.xHeight = number;
    }

    public Number getAscender() {
        return this.ascender;
    }

    public void setAscender(Number number) {
        this.ascender = number;
    }

    public Number getDescender() {
        return this.descender;
    }

    public void setDescender(Number number) {
        this.descender = number;
    }

    public Number getStdHW() {
        return this.stdHW;
    }

    public void setStdHW(Number number) {
        this.stdHW = number;
    }

    public Number getStdVW() {
        return this.stdVW;
    }

    public void setStdVW(Number number) {
        this.stdVW = number;
    }

    public AFMWritingDirectionMetrics getWritingDirectionMetrics(int n) {
        return this.writingDirectionMetrics[n];
    }

    public void setWritingDirectionMetrics(int n, AFMWritingDirectionMetrics aFMWritingDirectionMetrics) {
        this.writingDirectionMetrics[n] = aFMWritingDirectionMetrics;
    }

    public void addCharMetrics(AFMCharMetrics aFMCharMetrics) {
        int n;
        String string = aFMCharMetrics.getCharName();
        if (aFMCharMetrics.getUnicodeSequence() == null) {
            return;
        }
        this.charMetrics.add(aFMCharMetrics);
        if (string != null) {
            this.charNameToMetrics.put(string, aFMCharMetrics);
        }
        if ((n = aFMCharMetrics.getCharCode()) >= 0) {
            if (this.firstChar < 0 || n < this.firstChar) {
                this.firstChar = n;
            }
            if (this.lastChar < 0 || n > this.lastChar) {
                this.lastChar = n;
            }
        }
    }

    public int getCharCount() {
        return this.charMetrics.size();
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public AFMCharMetrics getChar(String string) {
        return this.charNameToMetrics.get(string);
    }

    public List<AFMCharMetrics> getCharMetrics() {
        return Collections.unmodifiableList(this.charMetrics);
    }

    public void addXKerning(String string, String string2, double d) {
        Map<String, Dimension2D> map;
        if (this.kerningMap == null) {
            this.kerningMap = new HashMap<String, Map<String, Dimension2D>>();
        }
        if ((map = this.kerningMap.get(string)) == null) {
            map = new HashMap<String, Dimension2D>();
            this.kerningMap.put(string, map);
        }
        map.put(string2, (Dimension2D)new Dimension2DDouble(d, 0.0));
    }

    public boolean hasKerning() {
        return this.kerningMap != null;
    }

    public Map<Integer, Map<Integer, Integer>> createXKerningMapEncoded() {
        if (!this.hasKerning()) {
            return null;
        }
        HashMap<Integer, Map<Integer, Integer>> hashMap = new HashMap<Integer, Map<Integer, Integer>>();
        for (Map.Entry<String, Map<String, Dimension2D>> entry : this.kerningMap.entrySet()) {
            String string = entry.getKey();
            AFMCharMetrics aFMCharMetrics = this.getChar(string);
            if (aFMCharMetrics == null || !aFMCharMetrics.hasCharCode()) continue;
            HashMap<Integer, Integer> hashMap2 = null;
            Map<String, Dimension2D> map = entry.getValue();
            for (Map.Entry<String, Dimension2D> entry2 : map.entrySet()) {
                Object object;
                String string2 = entry2.getKey();
                AFMCharMetrics aFMCharMetrics2 = this.getChar(string2);
                if (aFMCharMetrics2 == null || !aFMCharMetrics2.hasCharCode()) continue;
                if (hashMap2 == null && (hashMap2 = (HashMap<Integer, Integer>)hashMap.get(object = Integer.valueOf(aFMCharMetrics.getCharCode()))) == null) {
                    hashMap2 = new HashMap<Integer, Integer>();
                    hashMap.put((Integer)object, hashMap2);
                }
                object = entry2.getValue();
                hashMap2.put(aFMCharMetrics2.getCharCode(), (int)Math.round(((Dimension2D)object).getWidth()));
            }
        }
        return hashMap;
    }

    public void overridePrimaryEncoding(SingleByteEncoding singleByteEncoding) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Overriding primary encoding of " + this.getFontName() + " with: " + singleByteEncoding));
        }
        AFMCharMetrics[] aFMCharMetricsArray = new AFMCharMetrics[256];
        for (AFMCharMetrics aFMCharMetrics : this.charMetrics) {
            NamedCharacter namedCharacter = aFMCharMetrics.getCharacter();
            if (namedCharacter.hasSingleUnicodeValue()) {
                char c = singleByteEncoding.mapChar(namedCharacter.getSingleUnicodeValue());
                if (c > '\u0000') {
                    if (aFMCharMetricsArray[c] != null) {
                        if (!LOG.isDebugEnabled()) continue;
                        AFMCharMetrics aFMCharMetrics2 = aFMCharMetricsArray[c];
                        String string = "Not mapping character " + namedCharacter + " to code point " + c + " (" + Integer.toHexString(c) + ") in " + singleByteEncoding + ". " + aFMCharMetrics2 + " has already been assigned that code point.";
                        string = aFMCharMetrics2.getUnicodeSequence().equals(namedCharacter.getUnicodeSequence()) ? string + " This is a specialized glyph for the same Unicode character." : string + " This is a similar character.";
                        if (aFMCharMetrics.getWidthX() != aFMCharMetrics2.getWidthX()) {
                            string = string + " They have differing widths: " + aFMCharMetrics.getWidthX() + " vs. " + aFMCharMetrics2.getWidthX();
                        }
                        LOG.debug((Object)string);
                        continue;
                    }
                    aFMCharMetrics.setCharCode(c);
                    aFMCharMetricsArray[c] = aFMCharMetrics;
                    continue;
                }
                aFMCharMetrics.setCharCode(-1);
                continue;
            }
            aFMCharMetrics.setCharCode(-1);
        }
    }

    public String toString() {
        return "AFM: " + this.getFullName();
    }
}

