/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.substitute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.substitute.FontQualifier;
import org.apache.fop.fonts.substitute.FontSubstitution;

public class FontSubstitutions
extends ArrayList {
    private static final long serialVersionUID = -9173104935431899722L;
    protected static final Log log = LogFactory.getLog(FontSubstitutions.class);

    public void adjustFontInfo(FontInfo fontInfo) {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            FontSubstitution fontSubstitution = (FontSubstitution)iterator.next();
            FontQualifier fontQualifier = fontSubstitution.getToQualifier();
            FontTriplet fontTriplet = fontQualifier.bestMatch(fontInfo);
            if (fontTriplet == null) {
                log.error((Object)("Unable to match font substitution for destination qualifier " + fontQualifier));
                continue;
            }
            String string = fontInfo.getInternalFontKey(fontTriplet);
            FontQualifier fontQualifier2 = fontSubstitution.getFromQualifier();
            List list = fontQualifier2.getTriplets();
            for (FontTriplet fontTriplet2 : list) {
                fontInfo.addFontProperties(string, fontTriplet2);
            }
        }
    }
}

