/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class TimesBold
extends Base14Font {
    private static final String fontName = "Times-Bold";
    private static final String fullName = "Times Bold";
    private static final Set familyNames;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 676;
    private static final int xHeight = 461;
    private static final int ascender = 676;
    private static final int descender = -205;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning = false;

    public TimesBold() {
        this(false);
    }

    public TimesBold(boolean bl) {
        this.enableKerning = bl;
    }

    public String getEncodingName() {
        return encoding;
    }

    public String getFontName() {
        return fontName;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int n) {
        return n * 676;
    }

    public int getCapHeight(int n) {
        return n * 676;
    }

    public int getDescender(int n) {
        return n * -205;
    }

    public int getXHeight(int n) {
        return n * 461;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int n, int n2) {
        return n2 * width[n];
    }

    public int[] getWidths() {
        int[] nArray = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), nArray, 0, this.getLastChar() - this.getFirstChar() + 1);
        return nArray;
    }

    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char c2 = this.mapping.mapChar(c);
        if (c2 != '\u0000') {
            return c2;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        width = new int[256];
        TimesBold.width[65] = 722;
        TimesBold.width[198] = 1000;
        TimesBold.width[193] = 722;
        TimesBold.width[194] = 722;
        TimesBold.width[196] = 722;
        TimesBold.width[192] = 722;
        TimesBold.width[197] = 722;
        TimesBold.width[195] = 722;
        TimesBold.width[66] = 667;
        TimesBold.width[67] = 722;
        TimesBold.width[199] = 722;
        TimesBold.width[68] = 722;
        TimesBold.width[69] = 667;
        TimesBold.width[201] = 667;
        TimesBold.width[202] = 667;
        TimesBold.width[203] = 667;
        TimesBold.width[200] = 667;
        TimesBold.width[208] = 722;
        TimesBold.width[128] = 500;
        TimesBold.width[70] = 611;
        TimesBold.width[71] = 778;
        TimesBold.width[72] = 778;
        TimesBold.width[73] = 389;
        TimesBold.width[205] = 389;
        TimesBold.width[206] = 389;
        TimesBold.width[207] = 389;
        TimesBold.width[204] = 389;
        TimesBold.width[74] = 500;
        TimesBold.width[75] = 778;
        TimesBold.width[76] = 667;
        TimesBold.width[77] = 944;
        TimesBold.width[78] = 722;
        TimesBold.width[209] = 722;
        TimesBold.width[79] = 778;
        TimesBold.width[140] = 1000;
        TimesBold.width[211] = 778;
        TimesBold.width[212] = 778;
        TimesBold.width[214] = 778;
        TimesBold.width[210] = 778;
        TimesBold.width[216] = 778;
        TimesBold.width[213] = 778;
        TimesBold.width[80] = 611;
        TimesBold.width[81] = 778;
        TimesBold.width[82] = 722;
        TimesBold.width[83] = 556;
        TimesBold.width[138] = 556;
        TimesBold.width[84] = 667;
        TimesBold.width[222] = 611;
        TimesBold.width[85] = 722;
        TimesBold.width[218] = 722;
        TimesBold.width[219] = 722;
        TimesBold.width[220] = 722;
        TimesBold.width[217] = 722;
        TimesBold.width[86] = 722;
        TimesBold.width[87] = 1000;
        TimesBold.width[88] = 722;
        TimesBold.width[89] = 722;
        TimesBold.width[221] = 722;
        TimesBold.width[159] = 722;
        TimesBold.width[90] = 667;
        TimesBold.width[142] = 667;
        TimesBold.width[97] = 500;
        TimesBold.width[225] = 500;
        TimesBold.width[226] = 500;
        TimesBold.width[180] = 333;
        TimesBold.width[228] = 500;
        TimesBold.width[230] = 722;
        TimesBold.width[224] = 500;
        TimesBold.width[38] = 833;
        TimesBold.width[229] = 500;
        TimesBold.width[94] = 581;
        TimesBold.width[126] = 520;
        TimesBold.width[42] = 500;
        TimesBold.width[64] = 930;
        TimesBold.width[227] = 500;
        TimesBold.width[98] = 556;
        TimesBold.width[92] = 278;
        TimesBold.width[124] = 220;
        TimesBold.width[123] = 394;
        TimesBold.width[125] = 394;
        TimesBold.width[91] = 333;
        TimesBold.width[93] = 333;
        TimesBold.width[166] = 220;
        TimesBold.width[149] = 350;
        TimesBold.width[99] = 444;
        TimesBold.width[231] = 444;
        TimesBold.width[184] = 333;
        TimesBold.width[162] = 500;
        TimesBold.width[136] = 333;
        TimesBold.width[58] = 333;
        TimesBold.width[44] = 250;
        TimesBold.width[169] = 747;
        TimesBold.width[164] = 500;
        TimesBold.width[100] = 556;
        TimesBold.width[134] = 500;
        TimesBold.width[135] = 500;
        TimesBold.width[176] = 400;
        TimesBold.width[168] = 333;
        TimesBold.width[247] = 570;
        TimesBold.width[36] = 500;
        TimesBold.width[101] = 444;
        TimesBold.width[233] = 444;
        TimesBold.width[234] = 444;
        TimesBold.width[235] = 444;
        TimesBold.width[232] = 444;
        TimesBold.width[56] = 500;
        TimesBold.width[133] = 1000;
        TimesBold.width[151] = 1000;
        TimesBold.width[150] = 500;
        TimesBold.width[61] = 570;
        TimesBold.width[240] = 500;
        TimesBold.width[33] = 333;
        TimesBold.width[161] = 333;
        TimesBold.width[102] = 333;
        TimesBold.width[53] = 500;
        TimesBold.width[131] = 500;
        TimesBold.width[52] = 500;
        TimesBold.width[103] = 500;
        TimesBold.width[223] = 556;
        TimesBold.width[96] = 333;
        TimesBold.width[62] = 570;
        TimesBold.width[171] = 500;
        TimesBold.width[187] = 500;
        TimesBold.width[139] = 333;
        TimesBold.width[155] = 333;
        TimesBold.width[104] = 556;
        TimesBold.width[45] = 333;
        TimesBold.width[105] = 278;
        TimesBold.width[237] = 278;
        TimesBold.width[238] = 278;
        TimesBold.width[239] = 278;
        TimesBold.width[236] = 278;
        TimesBold.width[106] = 333;
        TimesBold.width[107] = 556;
        TimesBold.width[108] = 278;
        TimesBold.width[60] = 570;
        TimesBold.width[172] = 570;
        TimesBold.width[109] = 833;
        TimesBold.width[175] = 333;
        TimesBold.width[181] = 556;
        TimesBold.width[215] = 570;
        TimesBold.width[110] = 556;
        TimesBold.width[57] = 500;
        TimesBold.width[241] = 556;
        TimesBold.width[35] = 500;
        TimesBold.width[111] = 500;
        TimesBold.width[243] = 500;
        TimesBold.width[244] = 500;
        TimesBold.width[246] = 500;
        TimesBold.width[156] = 722;
        TimesBold.width[242] = 500;
        TimesBold.width[49] = 500;
        TimesBold.width[189] = 750;
        TimesBold.width[188] = 750;
        TimesBold.width[185] = 300;
        TimesBold.width[170] = 300;
        TimesBold.width[186] = 330;
        TimesBold.width[248] = 500;
        TimesBold.width[245] = 500;
        TimesBold.width[112] = 556;
        TimesBold.width[182] = 540;
        TimesBold.width[40] = 333;
        TimesBold.width[41] = 333;
        TimesBold.width[37] = 1000;
        TimesBold.width[46] = 250;
        TimesBold.width[183] = 250;
        TimesBold.width[137] = 1000;
        TimesBold.width[43] = 570;
        TimesBold.width[177] = 570;
        TimesBold.width[113] = 556;
        TimesBold.width[63] = 500;
        TimesBold.width[191] = 500;
        TimesBold.width[34] = 555;
        TimesBold.width[132] = 500;
        TimesBold.width[147] = 500;
        TimesBold.width[148] = 500;
        TimesBold.width[145] = 333;
        TimesBold.width[146] = 333;
        TimesBold.width[130] = 333;
        TimesBold.width[39] = 278;
        TimesBold.width[114] = 444;
        TimesBold.width[174] = 747;
        TimesBold.width[115] = 389;
        TimesBold.width[154] = 389;
        TimesBold.width[167] = 500;
        TimesBold.width[59] = 333;
        TimesBold.width[55] = 500;
        TimesBold.width[54] = 500;
        TimesBold.width[47] = 278;
        TimesBold.width[32] = 250;
        TimesBold.width[163] = 500;
        TimesBold.width[116] = 333;
        TimesBold.width[254] = 556;
        TimesBold.width[51] = 500;
        TimesBold.width[190] = 750;
        TimesBold.width[179] = 300;
        TimesBold.width[152] = 333;
        TimesBold.width[153] = 1000;
        TimesBold.width[50] = 500;
        TimesBold.width[178] = 300;
        TimesBold.width[117] = 556;
        TimesBold.width[250] = 556;
        TimesBold.width[251] = 556;
        TimesBold.width[252] = 556;
        TimesBold.width[249] = 556;
        TimesBold.width[95] = 500;
        TimesBold.width[118] = 500;
        TimesBold.width[119] = 722;
        TimesBold.width[120] = 500;
        TimesBold.width[121] = 500;
        TimesBold.width[253] = 500;
        TimesBold.width[255] = 500;
        TimesBold.width[165] = 500;
        TimesBold.width[122] = 444;
        TimesBold.width[158] = 444;
        TimesBold.width[48] = 500;
        kerning = new HashMap();
        Integer n = new Integer(79);
        Map<Integer, Integer> map = (HashMap<Integer, Integer>)kerning.get(n);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            kerning.put(n, map);
        }
        Integer n2 = new Integer(65);
        map.put(n2, new Integer(-40));
        n2 = new Integer(87);
        map.put(n2, new Integer(-50));
        n2 = new Integer(89);
        map.put(n2, new Integer(-50));
        n2 = new Integer(84);
        map.put(n2, new Integer(-40));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(86);
        map.put(n2, new Integer(-50));
        n2 = new Integer(88);
        map.put(n2, new Integer(-40));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(107);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-15));
        n2 = new Integer(121);
        map.put(n2, new Integer(-15));
        n2 = new Integer(101);
        map.put(n2, new Integer(-10));
        n = new Integer(112);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(80);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-20));
        n2 = new Integer(97);
        map.put(n2, new Integer(-10));
        n2 = new Integer(65);
        map.put(n2, new Integer(-74));
        n2 = new Integer(46);
        map.put(n2, new Integer(-110));
        n2 = new Integer(101);
        map.put(n2, new Integer(-20));
        n2 = new Integer(44);
        map.put(n2, new Integer(-92));
        n = new Integer(86);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-100));
        n2 = new Integer(79);
        map.put(n2, new Integer(-45));
        n2 = new Integer(58);
        map.put(n2, new Integer(-92));
        n2 = new Integer(71);
        map.put(n2, new Integer(-30));
        n2 = new Integer(44);
        map.put(n2, new Integer(-129));
        n2 = new Integer(59);
        map.put(n2, new Integer(-92));
        n2 = new Integer(45);
        map.put(n2, new Integer(-74));
        n2 = new Integer(105);
        map.put(n2, new Integer(-37));
        n2 = new Integer(65);
        map.put(n2, new Integer(-135));
        n2 = new Integer(97);
        map.put(n2, new Integer(-92));
        n2 = new Integer(117);
        map.put(n2, new Integer(-92));
        n2 = new Integer(46);
        map.put(n2, new Integer(-145));
        n2 = new Integer(101);
        map.put(n2, new Integer(-100));
        n = new Integer(118);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-10));
        n2 = new Integer(97);
        map.put(n2, new Integer(-10));
        n2 = new Integer(46);
        map.put(n2, new Integer(-70));
        n2 = new Integer(101);
        map.put(n2, new Integer(-10));
        n2 = new Integer(44);
        map.put(n2, new Integer(-55));
        n = new Integer(32);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-55));
        n2 = new Integer(87);
        map.put(n2, new Integer(-30));
        n2 = new Integer(147);
        map.put(n2, new Integer(0));
        n2 = new Integer(89);
        map.put(n2, new Integer(-55));
        n2 = new Integer(84);
        map.put(n2, new Integer(-30));
        n2 = new Integer(145);
        map.put(n2, new Integer(0));
        n2 = new Integer(86);
        map.put(n2, new Integer(-45));
        n = new Integer(97);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(116);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(112);
        map.put(n2, new Integer(0));
        n2 = new Integer(103);
        map.put(n2, new Integer(0));
        n2 = new Integer(98);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(-25));
        n = new Integer(70);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-25));
        n2 = new Integer(105);
        map.put(n2, new Integer(0));
        n2 = new Integer(114);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(-25));
        n2 = new Integer(65);
        map.put(n2, new Integer(-90));
        n2 = new Integer(46);
        map.put(n2, new Integer(-110));
        n2 = new Integer(101);
        map.put(n2, new Integer(-25));
        n2 = new Integer(44);
        map.put(n2, new Integer(-92));
        n = new Integer(85);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-60));
        n2 = new Integer(46);
        map.put(n2, new Integer(-50));
        n2 = new Integer(44);
        map.put(n2, new Integer(-50));
        n = new Integer(100);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(100);
        map.put(n2, new Integer(0));
        n2 = new Integer(119);
        map.put(n2, new Integer(-15));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(83);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(122);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n = new Integer(68);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-35));
        n2 = new Integer(87);
        map.put(n2, new Integer(-40));
        n2 = new Integer(89);
        map.put(n2, new Integer(-40));
        n2 = new Integer(46);
        map.put(n2, new Integer(-20));
        n2 = new Integer(86);
        map.put(n2, new Integer(-40));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(146);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(0));
        n2 = new Integer(100);
        map.put(n2, new Integer(-20));
        n2 = new Integer(32);
        map.put(n2, new Integer(-74));
        n2 = new Integer(146);
        map.put(n2, new Integer(-63));
        n2 = new Integer(114);
        map.put(n2, new Integer(-20));
        n2 = new Integer(116);
        map.put(n2, new Integer(0));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(115);
        map.put(n2, new Integer(-37));
        n2 = new Integer(118);
        map.put(n2, new Integer(-20));
        n = new Integer(58);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(32);
        map.put(n2, new Integer(0));
        n = new Integer(119);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-10));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(104);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-70));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-55));
        n = new Integer(75);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-25));
        n2 = new Integer(79);
        map.put(n2, new Integer(-30));
        n2 = new Integer(117);
        map.put(n2, new Integer(-15));
        n2 = new Integer(121);
        map.put(n2, new Integer(-45));
        n2 = new Integer(101);
        map.put(n2, new Integer(-25));
        n = new Integer(82);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(79);
        map.put(n2, new Integer(-30));
        n2 = new Integer(87);
        map.put(n2, new Integer(-35));
        n2 = new Integer(85);
        map.put(n2, new Integer(-30));
        n2 = new Integer(89);
        map.put(n2, new Integer(-35));
        n2 = new Integer(84);
        map.put(n2, new Integer(-40));
        n2 = new Integer(86);
        map.put(n2, new Integer(-55));
        n = new Integer(145);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-10));
        n2 = new Integer(145);
        map.put(n2, new Integer(-63));
        n = new Integer(103);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(105);
        map.put(n2, new Integer(0));
        n2 = new Integer(114);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-15));
        n2 = new Integer(103);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(66);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-30));
        n2 = new Integer(85);
        map.put(n2, new Integer(-10));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(98);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(-20));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-40));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(98);
        map.put(n2, new Integer(-10));
        n2 = new Integer(118);
        map.put(n2, new Integer(-15));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(81);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(85);
        map.put(n2, new Integer(-10));
        n2 = new Integer(46);
        map.put(n2, new Integer(-20));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(44);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(-45));
        n2 = new Integer(32);
        map.put(n2, new Integer(0));
        n2 = new Integer(146);
        map.put(n2, new Integer(-55));
        n = new Integer(102);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(50));
        n2 = new Integer(111);
        map.put(n2, new Integer(-25));
        n2 = new Integer(105);
        map.put(n2, new Integer(-25));
        n2 = new Integer(146);
        map.put(n2, new Integer(55));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(102);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-15));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-15));
        n = new Integer(84);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-92));
        n2 = new Integer(79);
        map.put(n2, new Integer(-18));
        n2 = new Integer(119);
        map.put(n2, new Integer(-74));
        n2 = new Integer(58);
        map.put(n2, new Integer(-74));
        n2 = new Integer(114);
        map.put(n2, new Integer(-74));
        n2 = new Integer(104);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-74));
        n2 = new Integer(59);
        map.put(n2, new Integer(-74));
        n2 = new Integer(45);
        map.put(n2, new Integer(-92));
        n2 = new Integer(105);
        map.put(n2, new Integer(-18));
        n2 = new Integer(65);
        map.put(n2, new Integer(-90));
        n2 = new Integer(97);
        map.put(n2, new Integer(-92));
        n2 = new Integer(117);
        map.put(n2, new Integer(-92));
        n2 = new Integer(121);
        map.put(n2, new Integer(-74));
        n2 = new Integer(46);
        map.put(n2, new Integer(-90));
        n2 = new Integer(101);
        map.put(n2, new Integer(-92));
        n = new Integer(121);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-25));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-70));
        n2 = new Integer(101);
        map.put(n2, new Integer(-10));
        n2 = new Integer(44);
        map.put(n2, new Integer(-55));
        n = new Integer(120);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n = new Integer(101);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(112);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(103);
        map.put(n2, new Integer(0));
        n2 = new Integer(98);
        map.put(n2, new Integer(0));
        n2 = new Integer(120);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(-15));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(99);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(107);
        map.put(n2, new Integer(0));
        n2 = new Integer(104);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(87);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-75));
        n2 = new Integer(79);
        map.put(n2, new Integer(-10));
        n2 = new Integer(58);
        map.put(n2, new Integer(-55));
        n2 = new Integer(104);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-92));
        n2 = new Integer(59);
        map.put(n2, new Integer(-55));
        n2 = new Integer(45);
        map.put(n2, new Integer(-37));
        n2 = new Integer(105);
        map.put(n2, new Integer(-18));
        n2 = new Integer(65);
        map.put(n2, new Integer(-120));
        n2 = new Integer(97);
        map.put(n2, new Integer(-65));
        n2 = new Integer(117);
        map.put(n2, new Integer(-50));
        n2 = new Integer(121);
        map.put(n2, new Integer(-60));
        n2 = new Integer(46);
        map.put(n2, new Integer(-92));
        n2 = new Integer(101);
        map.put(n2, new Integer(-65));
        n = new Integer(104);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(121);
        map.put(n2, new Integer(-15));
        n = new Integer(71);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(105);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(118);
        map.put(n2, new Integer(-10));
        n = new Integer(65);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(79);
        map.put(n2, new Integer(-45));
        n2 = new Integer(146);
        map.put(n2, new Integer(-74));
        n2 = new Integer(119);
        map.put(n2, new Integer(-90));
        n2 = new Integer(87);
        map.put(n2, new Integer(-130));
        n2 = new Integer(67);
        map.put(n2, new Integer(-55));
        n2 = new Integer(112);
        map.put(n2, new Integer(-25));
        n2 = new Integer(81);
        map.put(n2, new Integer(-45));
        n2 = new Integer(71);
        map.put(n2, new Integer(-55));
        n2 = new Integer(86);
        map.put(n2, new Integer(-145));
        n2 = new Integer(118);
        map.put(n2, new Integer(-100));
        n2 = new Integer(148);
        map.put(n2, new Integer(0));
        n2 = new Integer(85);
        map.put(n2, new Integer(-50));
        n2 = new Integer(117);
        map.put(n2, new Integer(-50));
        n2 = new Integer(89);
        map.put(n2, new Integer(-100));
        n2 = new Integer(121);
        map.put(n2, new Integer(-74));
        n2 = new Integer(84);
        map.put(n2, new Integer(-95));
        n = new Integer(147);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-10));
        n2 = new Integer(145);
        map.put(n2, new Integer(0));
        n = new Integer(78);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-20));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(115);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n = new Integer(111);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(-10));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(103);
        map.put(n2, new Integer(0));
        n2 = new Integer(120);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(-10));
        n = new Integer(114);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-18));
        n2 = new Integer(100);
        map.put(n2, new Integer(0));
        n2 = new Integer(107);
        map.put(n2, new Integer(0));
        n2 = new Integer(114);
        map.put(n2, new Integer(0));
        n2 = new Integer(99);
        map.put(n2, new Integer(-18));
        n2 = new Integer(112);
        map.put(n2, new Integer(-10));
        n2 = new Integer(103);
        map.put(n2, new Integer(-10));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(113);
        map.put(n2, new Integer(-18));
        n2 = new Integer(118);
        map.put(n2, new Integer(-10));
        n2 = new Integer(44);
        map.put(n2, new Integer(-92));
        n2 = new Integer(45);
        map.put(n2, new Integer(-37));
        n2 = new Integer(105);
        map.put(n2, new Integer(0));
        n2 = new Integer(109);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(117);
        map.put(n2, new Integer(0));
        n2 = new Integer(116);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-100));
        n2 = new Integer(110);
        map.put(n2, new Integer(-15));
        n2 = new Integer(115);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(-18));
        n = new Integer(108);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(76);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(-20));
        n2 = new Integer(146);
        map.put(n2, new Integer(-110));
        n2 = new Integer(87);
        map.put(n2, new Integer(-92));
        n2 = new Integer(89);
        map.put(n2, new Integer(-92));
        n2 = new Integer(121);
        map.put(n2, new Integer(-55));
        n2 = new Integer(84);
        map.put(n2, new Integer(-92));
        n2 = new Integer(86);
        map.put(n2, new Integer(-92));
        n = new Integer(148);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(32);
        map.put(n2, new Integer(0));
        n = new Integer(109);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(89);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-111));
        n2 = new Integer(45);
        map.put(n2, new Integer(-92));
        n2 = new Integer(105);
        map.put(n2, new Integer(-37));
        n2 = new Integer(79);
        map.put(n2, new Integer(-35));
        n2 = new Integer(58);
        map.put(n2, new Integer(-92));
        n2 = new Integer(97);
        map.put(n2, new Integer(-85));
        n2 = new Integer(65);
        map.put(n2, new Integer(-110));
        n2 = new Integer(117);
        map.put(n2, new Integer(-92));
        n2 = new Integer(46);
        map.put(n2, new Integer(-92));
        n2 = new Integer(101);
        map.put(n2, new Integer(-111));
        n2 = new Integer(59);
        map.put(n2, new Integer(-92));
        n2 = new Integer(44);
        map.put(n2, new Integer(-92));
        n = new Integer(74);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-15));
        n2 = new Integer(97);
        map.put(n2, new Integer(-15));
        n2 = new Integer(65);
        map.put(n2, new Integer(-30));
        n2 = new Integer(117);
        map.put(n2, new Integer(-15));
        n2 = new Integer(46);
        map.put(n2, new Integer(-20));
        n2 = new Integer(101);
        map.put(n2, new Integer(-15));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(46);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(-55));
        n2 = new Integer(146);
        map.put(n2, new Integer(-55));
        n = new Integer(110);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(-40));
        familyNames = new HashSet();
        familyNames.add("Times");
    }
}

