/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class HelveticaOblique
extends Base14Font {
    private static final String fontName = "Helvetica-Oblique";
    private static final String fullName = "Helvetica Oblique";
    private static final Set familyNames;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 718;
    private static final int xHeight = 523;
    private static final int ascender = 718;
    private static final int descender = -207;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning = false;

    public HelveticaOblique() {
        this(false);
    }

    public HelveticaOblique(boolean bl) {
        this.enableKerning = bl;
    }

    public String getEncodingName() {
        return encoding;
    }

    public String getFontName() {
        return fontName;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int n) {
        return n * 718;
    }

    public int getCapHeight(int n) {
        return n * 718;
    }

    public int getDescender(int n) {
        return n * -207;
    }

    public int getXHeight(int n) {
        return n * 523;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int n, int n2) {
        return n2 * width[n];
    }

    public int[] getWidths() {
        int[] nArray = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), nArray, 0, this.getLastChar() - this.getFirstChar() + 1);
        return nArray;
    }

    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char c2 = this.mapping.mapChar(c);
        if (c2 != '\u0000') {
            return c2;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        width = new int[256];
        HelveticaOblique.width[65] = 667;
        HelveticaOblique.width[198] = 1000;
        HelveticaOblique.width[193] = 667;
        HelveticaOblique.width[194] = 667;
        HelveticaOblique.width[196] = 667;
        HelveticaOblique.width[192] = 667;
        HelveticaOblique.width[197] = 667;
        HelveticaOblique.width[195] = 667;
        HelveticaOblique.width[66] = 667;
        HelveticaOblique.width[67] = 722;
        HelveticaOblique.width[199] = 722;
        HelveticaOblique.width[68] = 722;
        HelveticaOblique.width[69] = 667;
        HelveticaOblique.width[201] = 667;
        HelveticaOblique.width[202] = 667;
        HelveticaOblique.width[203] = 667;
        HelveticaOblique.width[200] = 667;
        HelveticaOblique.width[208] = 722;
        HelveticaOblique.width[128] = 556;
        HelveticaOblique.width[70] = 611;
        HelveticaOblique.width[71] = 778;
        HelveticaOblique.width[72] = 722;
        HelveticaOblique.width[73] = 278;
        HelveticaOblique.width[205] = 278;
        HelveticaOblique.width[206] = 278;
        HelveticaOblique.width[207] = 278;
        HelveticaOblique.width[204] = 278;
        HelveticaOblique.width[74] = 500;
        HelveticaOblique.width[75] = 667;
        HelveticaOblique.width[76] = 556;
        HelveticaOblique.width[77] = 833;
        HelveticaOblique.width[78] = 722;
        HelveticaOblique.width[209] = 722;
        HelveticaOblique.width[79] = 778;
        HelveticaOblique.width[140] = 1000;
        HelveticaOblique.width[211] = 778;
        HelveticaOblique.width[212] = 778;
        HelveticaOblique.width[214] = 778;
        HelveticaOblique.width[210] = 778;
        HelveticaOblique.width[216] = 778;
        HelveticaOblique.width[213] = 778;
        HelveticaOblique.width[80] = 667;
        HelveticaOblique.width[81] = 778;
        HelveticaOblique.width[82] = 722;
        HelveticaOblique.width[83] = 667;
        HelveticaOblique.width[138] = 667;
        HelveticaOblique.width[84] = 611;
        HelveticaOblique.width[222] = 667;
        HelveticaOblique.width[85] = 722;
        HelveticaOblique.width[218] = 722;
        HelveticaOblique.width[219] = 722;
        HelveticaOblique.width[220] = 722;
        HelveticaOblique.width[217] = 722;
        HelveticaOblique.width[86] = 667;
        HelveticaOblique.width[87] = 944;
        HelveticaOblique.width[88] = 667;
        HelveticaOblique.width[89] = 667;
        HelveticaOblique.width[221] = 667;
        HelveticaOblique.width[159] = 667;
        HelveticaOblique.width[90] = 611;
        HelveticaOblique.width[142] = 611;
        HelveticaOblique.width[97] = 556;
        HelveticaOblique.width[225] = 556;
        HelveticaOblique.width[226] = 556;
        HelveticaOblique.width[180] = 333;
        HelveticaOblique.width[228] = 556;
        HelveticaOblique.width[230] = 889;
        HelveticaOblique.width[224] = 556;
        HelveticaOblique.width[38] = 667;
        HelveticaOblique.width[229] = 556;
        HelveticaOblique.width[94] = 469;
        HelveticaOblique.width[126] = 584;
        HelveticaOblique.width[42] = 389;
        HelveticaOblique.width[64] = 1015;
        HelveticaOblique.width[227] = 556;
        HelveticaOblique.width[98] = 556;
        HelveticaOblique.width[92] = 278;
        HelveticaOblique.width[124] = 260;
        HelveticaOblique.width[123] = 334;
        HelveticaOblique.width[125] = 334;
        HelveticaOblique.width[91] = 278;
        HelveticaOblique.width[93] = 278;
        HelveticaOblique.width[166] = 260;
        HelveticaOblique.width[149] = 350;
        HelveticaOblique.width[99] = 500;
        HelveticaOblique.width[231] = 500;
        HelveticaOblique.width[184] = 333;
        HelveticaOblique.width[162] = 556;
        HelveticaOblique.width[136] = 333;
        HelveticaOblique.width[58] = 278;
        HelveticaOblique.width[44] = 278;
        HelveticaOblique.width[169] = 737;
        HelveticaOblique.width[164] = 556;
        HelveticaOblique.width[100] = 556;
        HelveticaOblique.width[134] = 556;
        HelveticaOblique.width[135] = 556;
        HelveticaOblique.width[176] = 400;
        HelveticaOblique.width[168] = 333;
        HelveticaOblique.width[247] = 584;
        HelveticaOblique.width[36] = 556;
        HelveticaOblique.width[101] = 556;
        HelveticaOblique.width[233] = 556;
        HelveticaOblique.width[234] = 556;
        HelveticaOblique.width[235] = 556;
        HelveticaOblique.width[232] = 556;
        HelveticaOblique.width[56] = 556;
        HelveticaOblique.width[133] = 1000;
        HelveticaOblique.width[151] = 1000;
        HelveticaOblique.width[150] = 556;
        HelveticaOblique.width[61] = 584;
        HelveticaOblique.width[240] = 556;
        HelveticaOblique.width[33] = 278;
        HelveticaOblique.width[161] = 333;
        HelveticaOblique.width[102] = 278;
        HelveticaOblique.width[53] = 556;
        HelveticaOblique.width[131] = 556;
        HelveticaOblique.width[52] = 556;
        HelveticaOblique.width[103] = 556;
        HelveticaOblique.width[223] = 611;
        HelveticaOblique.width[96] = 333;
        HelveticaOblique.width[62] = 584;
        HelveticaOblique.width[171] = 556;
        HelveticaOblique.width[187] = 556;
        HelveticaOblique.width[139] = 333;
        HelveticaOblique.width[155] = 333;
        HelveticaOblique.width[104] = 556;
        HelveticaOblique.width[45] = 333;
        HelveticaOblique.width[105] = 222;
        HelveticaOblique.width[237] = 278;
        HelveticaOblique.width[238] = 278;
        HelveticaOblique.width[239] = 278;
        HelveticaOblique.width[236] = 278;
        HelveticaOblique.width[106] = 222;
        HelveticaOblique.width[107] = 500;
        HelveticaOblique.width[108] = 222;
        HelveticaOblique.width[60] = 584;
        HelveticaOblique.width[172] = 584;
        HelveticaOblique.width[109] = 833;
        HelveticaOblique.width[175] = 333;
        HelveticaOblique.width[181] = 556;
        HelveticaOblique.width[215] = 584;
        HelveticaOblique.width[110] = 556;
        HelveticaOblique.width[57] = 556;
        HelveticaOblique.width[241] = 556;
        HelveticaOblique.width[35] = 556;
        HelveticaOblique.width[111] = 556;
        HelveticaOblique.width[243] = 556;
        HelveticaOblique.width[244] = 556;
        HelveticaOblique.width[246] = 556;
        HelveticaOblique.width[156] = 944;
        HelveticaOblique.width[242] = 556;
        HelveticaOblique.width[49] = 556;
        HelveticaOblique.width[189] = 834;
        HelveticaOblique.width[188] = 834;
        HelveticaOblique.width[185] = 333;
        HelveticaOblique.width[170] = 370;
        HelveticaOblique.width[186] = 365;
        HelveticaOblique.width[248] = 611;
        HelveticaOblique.width[245] = 556;
        HelveticaOblique.width[112] = 556;
        HelveticaOblique.width[182] = 537;
        HelveticaOblique.width[40] = 333;
        HelveticaOblique.width[41] = 333;
        HelveticaOblique.width[37] = 889;
        HelveticaOblique.width[46] = 278;
        HelveticaOblique.width[183] = 278;
        HelveticaOblique.width[137] = 1000;
        HelveticaOblique.width[43] = 584;
        HelveticaOblique.width[177] = 584;
        HelveticaOblique.width[113] = 556;
        HelveticaOblique.width[63] = 556;
        HelveticaOblique.width[191] = 611;
        HelveticaOblique.width[34] = 355;
        HelveticaOblique.width[132] = 333;
        HelveticaOblique.width[147] = 333;
        HelveticaOblique.width[148] = 333;
        HelveticaOblique.width[145] = 222;
        HelveticaOblique.width[146] = 222;
        HelveticaOblique.width[130] = 222;
        HelveticaOblique.width[39] = 191;
        HelveticaOblique.width[114] = 333;
        HelveticaOblique.width[174] = 737;
        HelveticaOblique.width[115] = 500;
        HelveticaOblique.width[154] = 500;
        HelveticaOblique.width[167] = 556;
        HelveticaOblique.width[59] = 278;
        HelveticaOblique.width[55] = 556;
        HelveticaOblique.width[54] = 556;
        HelveticaOblique.width[47] = 278;
        HelveticaOblique.width[32] = 278;
        HelveticaOblique.width[163] = 556;
        HelveticaOblique.width[116] = 278;
        HelveticaOblique.width[254] = 556;
        HelveticaOblique.width[51] = 556;
        HelveticaOblique.width[190] = 834;
        HelveticaOblique.width[179] = 333;
        HelveticaOblique.width[152] = 333;
        HelveticaOblique.width[153] = 1000;
        HelveticaOblique.width[50] = 556;
        HelveticaOblique.width[178] = 333;
        HelveticaOblique.width[117] = 556;
        HelveticaOblique.width[250] = 556;
        HelveticaOblique.width[251] = 556;
        HelveticaOblique.width[252] = 556;
        HelveticaOblique.width[249] = 556;
        HelveticaOblique.width[95] = 556;
        HelveticaOblique.width[118] = 500;
        HelveticaOblique.width[119] = 722;
        HelveticaOblique.width[120] = 500;
        HelveticaOblique.width[121] = 500;
        HelveticaOblique.width[253] = 500;
        HelveticaOblique.width[255] = 500;
        HelveticaOblique.width[165] = 556;
        HelveticaOblique.width[122] = 500;
        HelveticaOblique.width[158] = 500;
        HelveticaOblique.width[48] = 556;
        kerning = new HashMap();
        Integer n = new Integer(107);
        Map<Integer, Integer> map = (HashMap<Integer, Integer>)kerning.get(n);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            kerning.put(n, map);
        }
        Integer n2 = new Integer(111);
        map.put(n2, new Integer(-20));
        n2 = new Integer(101);
        map.put(n2, new Integer(-20));
        n = new Integer(79);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-20));
        n2 = new Integer(87);
        map.put(n2, new Integer(-30));
        n2 = new Integer(89);
        map.put(n2, new Integer(-70));
        n2 = new Integer(84);
        map.put(n2, new Integer(-40));
        n2 = new Integer(46);
        map.put(n2, new Integer(-40));
        n2 = new Integer(86);
        map.put(n2, new Integer(-50));
        n2 = new Integer(88);
        map.put(n2, new Integer(-60));
        n2 = new Integer(44);
        map.put(n2, new Integer(-40));
        n = new Integer(104);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(121);
        map.put(n2, new Integer(-30));
        n = new Integer(87);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-30));
        n2 = new Integer(45);
        map.put(n2, new Integer(-40));
        n2 = new Integer(79);
        map.put(n2, new Integer(-20));
        n2 = new Integer(97);
        map.put(n2, new Integer(-40));
        n2 = new Integer(65);
        map.put(n2, new Integer(-50));
        n2 = new Integer(117);
        map.put(n2, new Integer(-30));
        n2 = new Integer(121);
        map.put(n2, new Integer(-20));
        n2 = new Integer(46);
        map.put(n2, new Integer(-80));
        n2 = new Integer(101);
        map.put(n2, new Integer(-30));
        n2 = new Integer(44);
        map.put(n2, new Integer(-80));
        n = new Integer(99);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(107);
        map.put(n2, new Integer(-20));
        n2 = new Integer(44);
        map.put(n2, new Integer(-15));
        n = new Integer(112);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(121);
        map.put(n2, new Integer(-30));
        n2 = new Integer(46);
        map.put(n2, new Integer(-35));
        n2 = new Integer(44);
        map.put(n2, new Integer(-35));
        n = new Integer(80);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-50));
        n2 = new Integer(97);
        map.put(n2, new Integer(-40));
        n2 = new Integer(65);
        map.put(n2, new Integer(-120));
        n2 = new Integer(46);
        map.put(n2, new Integer(-180));
        n2 = new Integer(101);
        map.put(n2, new Integer(-50));
        n2 = new Integer(44);
        map.put(n2, new Integer(-180));
        n = new Integer(86);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-80));
        n2 = new Integer(45);
        map.put(n2, new Integer(-80));
        n2 = new Integer(79);
        map.put(n2, new Integer(-40));
        n2 = new Integer(58);
        map.put(n2, new Integer(-40));
        n2 = new Integer(97);
        map.put(n2, new Integer(-70));
        n2 = new Integer(65);
        map.put(n2, new Integer(-80));
        n2 = new Integer(117);
        map.put(n2, new Integer(-70));
        n2 = new Integer(46);
        map.put(n2, new Integer(-125));
        n2 = new Integer(71);
        map.put(n2, new Integer(-40));
        n2 = new Integer(101);
        map.put(n2, new Integer(-80));
        n2 = new Integer(59);
        map.put(n2, new Integer(-40));
        n2 = new Integer(44);
        map.put(n2, new Integer(-125));
        n = new Integer(118);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-25));
        n2 = new Integer(97);
        map.put(n2, new Integer(-25));
        n2 = new Integer(46);
        map.put(n2, new Integer(-80));
        n2 = new Integer(101);
        map.put(n2, new Integer(-25));
        n2 = new Integer(44);
        map.put(n2, new Integer(-80));
        n = new Integer(59);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(32);
        map.put(n2, new Integer(-50));
        n = new Integer(32);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(87);
        map.put(n2, new Integer(-40));
        n2 = new Integer(147);
        map.put(n2, new Integer(-30));
        n2 = new Integer(89);
        map.put(n2, new Integer(-90));
        n2 = new Integer(84);
        map.put(n2, new Integer(-50));
        n2 = new Integer(145);
        map.put(n2, new Integer(-60));
        n2 = new Integer(86);
        map.put(n2, new Integer(-50));
        n = new Integer(97);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(-20));
        n2 = new Integer(121);
        map.put(n2, new Integer(-30));
        n2 = new Integer(118);
        map.put(n2, new Integer(-20));
        n = new Integer(65);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(79);
        map.put(n2, new Integer(-30));
        n2 = new Integer(119);
        map.put(n2, new Integer(-40));
        n2 = new Integer(87);
        map.put(n2, new Integer(-50));
        n2 = new Integer(67);
        map.put(n2, new Integer(-30));
        n2 = new Integer(81);
        map.put(n2, new Integer(-30));
        n2 = new Integer(71);
        map.put(n2, new Integer(-30));
        n2 = new Integer(86);
        map.put(n2, new Integer(-70));
        n2 = new Integer(118);
        map.put(n2, new Integer(-40));
        n2 = new Integer(85);
        map.put(n2, new Integer(-50));
        n2 = new Integer(117);
        map.put(n2, new Integer(-30));
        n2 = new Integer(89);
        map.put(n2, new Integer(-100));
        n2 = new Integer(84);
        map.put(n2, new Integer(-120));
        n2 = new Integer(121);
        map.put(n2, new Integer(-40));
        n = new Integer(70);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-30));
        n2 = new Integer(114);
        map.put(n2, new Integer(-45));
        n2 = new Integer(97);
        map.put(n2, new Integer(-50));
        n2 = new Integer(65);
        map.put(n2, new Integer(-80));
        n2 = new Integer(46);
        map.put(n2, new Integer(-150));
        n2 = new Integer(101);
        map.put(n2, new Integer(-30));
        n2 = new Integer(44);
        map.put(n2, new Integer(-150));
        n = new Integer(85);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-40));
        n2 = new Integer(46);
        map.put(n2, new Integer(-40));
        n2 = new Integer(44);
        map.put(n2, new Integer(-40));
        n = new Integer(115);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(-30));
        n2 = new Integer(46);
        map.put(n2, new Integer(-15));
        n2 = new Integer(44);
        map.put(n2, new Integer(-15));
        n = new Integer(122);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-15));
        n2 = new Integer(101);
        map.put(n2, new Integer(-15));
        n = new Integer(83);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(46);
        map.put(n2, new Integer(-20));
        n2 = new Integer(44);
        map.put(n2, new Integer(-20));
        n = new Integer(111);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(-15));
        n2 = new Integer(121);
        map.put(n2, new Integer(-30));
        n2 = new Integer(46);
        map.put(n2, new Integer(-40));
        n2 = new Integer(120);
        map.put(n2, new Integer(-30));
        n2 = new Integer(118);
        map.put(n2, new Integer(-15));
        n2 = new Integer(44);
        map.put(n2, new Integer(-40));
        n = new Integer(68);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-40));
        n2 = new Integer(87);
        map.put(n2, new Integer(-40));
        n2 = new Integer(89);
        map.put(n2, new Integer(-90));
        n2 = new Integer(46);
        map.put(n2, new Integer(-70));
        n2 = new Integer(86);
        map.put(n2, new Integer(-70));
        n2 = new Integer(44);
        map.put(n2, new Integer(-70));
        n = new Integer(146);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(100);
        map.put(n2, new Integer(-50));
        n2 = new Integer(32);
        map.put(n2, new Integer(-70));
        n2 = new Integer(146);
        map.put(n2, new Integer(-57));
        n2 = new Integer(114);
        map.put(n2, new Integer(-50));
        n2 = new Integer(115);
        map.put(n2, new Integer(-50));
        n = new Integer(82);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(79);
        map.put(n2, new Integer(-20));
        n2 = new Integer(87);
        map.put(n2, new Integer(-30));
        n2 = new Integer(85);
        map.put(n2, new Integer(-40));
        n2 = new Integer(89);
        map.put(n2, new Integer(-50));
        n2 = new Integer(84);
        map.put(n2, new Integer(-30));
        n2 = new Integer(86);
        map.put(n2, new Integer(-50));
        n = new Integer(75);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-40));
        n2 = new Integer(79);
        map.put(n2, new Integer(-50));
        n2 = new Integer(117);
        map.put(n2, new Integer(-30));
        n2 = new Integer(121);
        map.put(n2, new Integer(-50));
        n2 = new Integer(101);
        map.put(n2, new Integer(-40));
        n = new Integer(119);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-10));
        n2 = new Integer(97);
        map.put(n2, new Integer(-15));
        n2 = new Integer(46);
        map.put(n2, new Integer(-60));
        n2 = new Integer(101);
        map.put(n2, new Integer(-10));
        n2 = new Integer(44);
        map.put(n2, new Integer(-60));
        n = new Integer(58);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(32);
        map.put(n2, new Integer(-50));
        n = new Integer(114);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(107);
        map.put(n2, new Integer(15));
        n2 = new Integer(58);
        map.put(n2, new Integer(30));
        n2 = new Integer(112);
        map.put(n2, new Integer(30));
        n2 = new Integer(108);
        map.put(n2, new Integer(15));
        n2 = new Integer(118);
        map.put(n2, new Integer(30));
        n2 = new Integer(44);
        map.put(n2, new Integer(-50));
        n2 = new Integer(59);
        map.put(n2, new Integer(30));
        n2 = new Integer(105);
        map.put(n2, new Integer(15));
        n2 = new Integer(109);
        map.put(n2, new Integer(25));
        n2 = new Integer(97);
        map.put(n2, new Integer(-10));
        n2 = new Integer(117);
        map.put(n2, new Integer(15));
        n2 = new Integer(116);
        map.put(n2, new Integer(40));
        n2 = new Integer(121);
        map.put(n2, new Integer(30));
        n2 = new Integer(46);
        map.put(n2, new Integer(-50));
        n2 = new Integer(110);
        map.put(n2, new Integer(25));
        n = new Integer(67);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(46);
        map.put(n2, new Integer(-30));
        n2 = new Integer(44);
        map.put(n2, new Integer(-30));
        n = new Integer(145);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(145);
        map.put(n2, new Integer(-57));
        n = new Integer(103);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(114);
        map.put(n2, new Integer(-10));
        n = new Integer(66);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(85);
        map.put(n2, new Integer(-10));
        n2 = new Integer(46);
        map.put(n2, new Integer(-20));
        n2 = new Integer(44);
        map.put(n2, new Integer(-20));
        n = new Integer(81);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(85);
        map.put(n2, new Integer(-10));
        n = new Integer(76);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(-140));
        n2 = new Integer(146);
        map.put(n2, new Integer(-160));
        n2 = new Integer(87);
        map.put(n2, new Integer(-70));
        n2 = new Integer(89);
        map.put(n2, new Integer(-140));
        n2 = new Integer(121);
        map.put(n2, new Integer(-30));
        n2 = new Integer(84);
        map.put(n2, new Integer(-110));
        n2 = new Integer(86);
        map.put(n2, new Integer(-110));
        n = new Integer(98);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(-20));
        n2 = new Integer(121);
        map.put(n2, new Integer(-20));
        n2 = new Integer(46);
        map.put(n2, new Integer(-40));
        n2 = new Integer(108);
        map.put(n2, new Integer(-20));
        n2 = new Integer(98);
        map.put(n2, new Integer(-10));
        n2 = new Integer(118);
        map.put(n2, new Integer(-20));
        n2 = new Integer(44);
        map.put(n2, new Integer(-40));
        n = new Integer(44);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(-100));
        n2 = new Integer(146);
        map.put(n2, new Integer(-100));
        n = new Integer(148);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(32);
        map.put(n2, new Integer(-40));
        n = new Integer(109);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(-10));
        n2 = new Integer(121);
        map.put(n2, new Integer(-15));
        n = new Integer(248);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(107);
        map.put(n2, new Integer(-55));
        n2 = new Integer(104);
        map.put(n2, new Integer(-55));
        n2 = new Integer(99);
        map.put(n2, new Integer(-55));
        n2 = new Integer(112);
        map.put(n2, new Integer(-55));
        n2 = new Integer(113);
        map.put(n2, new Integer(-55));
        n2 = new Integer(118);
        map.put(n2, new Integer(-70));
        n2 = new Integer(105);
        map.put(n2, new Integer(-55));
        n2 = new Integer(97);
        map.put(n2, new Integer(-55));
        n2 = new Integer(117);
        map.put(n2, new Integer(-55));
        n2 = new Integer(116);
        map.put(n2, new Integer(-55));
        n2 = new Integer(106);
        map.put(n2, new Integer(-55));
        n2 = new Integer(115);
        map.put(n2, new Integer(-55));
        n2 = new Integer(122);
        map.put(n2, new Integer(-55));
        n2 = new Integer(100);
        map.put(n2, new Integer(-55));
        n2 = new Integer(111);
        map.put(n2, new Integer(-55));
        n2 = new Integer(119);
        map.put(n2, new Integer(-70));
        n2 = new Integer(114);
        map.put(n2, new Integer(-55));
        n2 = new Integer(103);
        map.put(n2, new Integer(-55));
        n2 = new Integer(108);
        map.put(n2, new Integer(-55));
        n2 = new Integer(98);
        map.put(n2, new Integer(-55));
        n2 = new Integer(44);
        map.put(n2, new Integer(-95));
        n2 = new Integer(109);
        map.put(n2, new Integer(-55));
        n2 = new Integer(102);
        map.put(n2, new Integer(-55));
        n2 = new Integer(121);
        map.put(n2, new Integer(-70));
        n2 = new Integer(46);
        map.put(n2, new Integer(-95));
        n2 = new Integer(110);
        map.put(n2, new Integer(-55));
        n2 = new Integer(120);
        map.put(n2, new Integer(-85));
        n2 = new Integer(101);
        map.put(n2, new Integer(-55));
        n = new Integer(102);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(60));
        n2 = new Integer(111);
        map.put(n2, new Integer(-30));
        n2 = new Integer(146);
        map.put(n2, new Integer(50));
        n2 = new Integer(97);
        map.put(n2, new Integer(-30));
        n2 = new Integer(46);
        map.put(n2, new Integer(-30));
        n2 = new Integer(101);
        map.put(n2, new Integer(-30));
        n2 = new Integer(44);
        map.put(n2, new Integer(-30));
        n = new Integer(74);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(97);
        map.put(n2, new Integer(-20));
        n2 = new Integer(65);
        map.put(n2, new Integer(-20));
        n2 = new Integer(117);
        map.put(n2, new Integer(-20));
        n2 = new Integer(46);
        map.put(n2, new Integer(-30));
        n2 = new Integer(44);
        map.put(n2, new Integer(-30));
        n = new Integer(89);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-140));
        n2 = new Integer(45);
        map.put(n2, new Integer(-140));
        n2 = new Integer(105);
        map.put(n2, new Integer(-20));
        n2 = new Integer(79);
        map.put(n2, new Integer(-85));
        n2 = new Integer(58);
        map.put(n2, new Integer(-60));
        n2 = new Integer(97);
        map.put(n2, new Integer(-140));
        n2 = new Integer(65);
        map.put(n2, new Integer(-110));
        n2 = new Integer(117);
        map.put(n2, new Integer(-110));
        n2 = new Integer(46);
        map.put(n2, new Integer(-140));
        n2 = new Integer(101);
        map.put(n2, new Integer(-140));
        n2 = new Integer(59);
        map.put(n2, new Integer(-60));
        n2 = new Integer(44);
        map.put(n2, new Integer(-140));
        n = new Integer(121);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-20));
        n2 = new Integer(97);
        map.put(n2, new Integer(-20));
        n2 = new Integer(46);
        map.put(n2, new Integer(-100));
        n2 = new Integer(101);
        map.put(n2, new Integer(-20));
        n2 = new Integer(44);
        map.put(n2, new Integer(-100));
        n = new Integer(84);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-120));
        n2 = new Integer(79);
        map.put(n2, new Integer(-40));
        n2 = new Integer(58);
        map.put(n2, new Integer(-20));
        n2 = new Integer(119);
        map.put(n2, new Integer(-120));
        n2 = new Integer(114);
        map.put(n2, new Integer(-120));
        n2 = new Integer(44);
        map.put(n2, new Integer(-120));
        n2 = new Integer(59);
        map.put(n2, new Integer(-20));
        n2 = new Integer(45);
        map.put(n2, new Integer(-140));
        n2 = new Integer(65);
        map.put(n2, new Integer(-120));
        n2 = new Integer(97);
        map.put(n2, new Integer(-120));
        n2 = new Integer(117);
        map.put(n2, new Integer(-120));
        n2 = new Integer(121);
        map.put(n2, new Integer(-120));
        n2 = new Integer(46);
        map.put(n2, new Integer(-120));
        n2 = new Integer(101);
        map.put(n2, new Integer(-120));
        n = new Integer(46);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(-100));
        n2 = new Integer(32);
        map.put(n2, new Integer(-60));
        n2 = new Integer(146);
        map.put(n2, new Integer(-100));
        n = new Integer(110);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(-10));
        n2 = new Integer(121);
        map.put(n2, new Integer(-15));
        n2 = new Integer(118);
        map.put(n2, new Integer(-20));
        n = new Integer(120);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(101);
        map.put(n2, new Integer(-30));
        n = new Integer(101);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(-20));
        n2 = new Integer(121);
        map.put(n2, new Integer(-20));
        n2 = new Integer(46);
        map.put(n2, new Integer(-15));
        n2 = new Integer(120);
        map.put(n2, new Integer(-30));
        n2 = new Integer(118);
        map.put(n2, new Integer(-30));
        n2 = new Integer(44);
        map.put(n2, new Integer(-15));
        familyNames = new HashSet();
        familyNames.add("Helvetica");
    }
}

