/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.Version;
import org.apache.fop.fonts.apps.AbstractFontReader;
import org.apache.fop.fonts.type1.PFMFile;
import org.apache.fop.util.CommandLineLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PFMReader
extends AbstractFontReader {
    private static void displayUsage() {
        System.out.println("java " + PFMReader.class.getName() + " [options] metricfile.pfm xmlfile.xml");
        System.out.println();
        System.out.println("where options can be:");
        System.out.println("-d  Debug mode");
        System.out.println("-q  Quiet mode");
        System.out.println("-fn <fontname>");
        System.out.println("    default is to use the fontname in the .pfm file, but");
        System.out.println("    you can override that name to make sure that the");
        System.out.println("    embedded font is used (if you're embedding fonts)");
        System.out.println("    instead of installed fonts when viewing documents ");
        System.out.println("    with Acrobat Reader.");
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        HashMap hashMap = new HashMap();
        String[] stringArray2 = PFMReader.parseArguments(hashMap, stringArray);
        LogFactory logFactory = LogFactory.getFactory();
        if (System.getProperty("org.apache.commons.logging.Log") == null) {
            logFactory.setAttribute("org.apache.commons.logging.Log", (Object)CommandLineLogger.class.getName());
        }
        PFMReader.determineLogLevel(hashMap);
        PFMReader pFMReader = new PFMReader();
        log.info((Object)("PFM Reader for Apache FOP " + Version.getVersion() + "\n"));
        if (hashMap.get("-ef") != null) {
            string = (String)hashMap.get("-ef");
        }
        if (hashMap.get("-er") != null) {
            string2 = (String)hashMap.get("-er");
        }
        if (hashMap.get("-fn") != null) {
            string4 = (String)hashMap.get("-fn");
        }
        if (hashMap.get("-cn") != null) {
            string3 = (String)hashMap.get("-cn");
        }
        if (stringArray2.length != 2 || hashMap.get("-h") != null || hashMap.get("-help") != null || hashMap.get("--help") != null) {
            PFMReader.displayUsage();
        } else {
            try {
                log.info((Object)"Parsing font...");
                PFMFile pFMFile = pFMReader.loadPFM(stringArray2[0]);
                if (pFMFile != null) {
                    pFMReader.preview(pFMFile);
                    Document document = pFMReader.constructFontXML(pFMFile, string4, string3, string2, string);
                    pFMReader.writeFontXML(document, stringArray2[1]);
                }
                log.info((Object)"XML font metrics file successfullly created.");
            }
            catch (Exception exception) {
                log.error((Object)"Error while building XML font metrics file", (Throwable)exception);
                System.exit(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PFMFile loadPFM(String string) throws IOException {
        log.info((Object)("Reading " + string + "..."));
        log.info((Object)"");
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            PFMFile pFMFile = new PFMFile();
            pFMFile.load(fileInputStream);
            PFMFile pFMFile2 = pFMFile;
            return pFMFile2;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public void preview(PFMFile pFMFile) {
        if (log != null && log.isInfoEnabled()) {
            log.info((Object)("Font: " + pFMFile.getWindowsName()));
            log.info((Object)("Name: " + pFMFile.getPostscriptName()));
            log.info((Object)("CharSet: " + pFMFile.getCharSetName()));
            log.info((Object)("CapHeight: " + pFMFile.getCapHeight()));
            log.info((Object)("XHeight: " + pFMFile.getXHeight()));
            log.info((Object)("LowerCaseAscent: " + pFMFile.getLowerCaseAscent()));
            log.info((Object)("LowerCaseDescent: " + pFMFile.getLowerCaseDescent()));
            log.info((Object)("Having widths for " + (pFMFile.getLastChar() - pFMFile.getFirstChar()) + " characters (" + pFMFile.getFirstChar() + "-" + pFMFile.getLastChar() + ")."));
            log.info((Object)("for example: Char " + pFMFile.getFirstChar() + " has a width of " + pFMFile.getCharWidth(pFMFile.getFirstChar())));
            log.info((Object)"");
        }
    }

    public Document constructFontXML(PFMFile pFMFile, String string, String string2, String string3, String string4) {
        Document document;
        Object object;
        log.info((Object)"Creating xml font file...");
        log.info((Object)"");
        try {
            object = DocumentBuilderFactory.newInstance();
            document = ((DocumentBuilderFactory)object).newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error((Object)"Can't create DOM implementation", (Throwable)parserConfigurationException);
            return null;
        }
        object = document.createElement("font-metrics");
        document.appendChild((Node)object);
        object.setAttribute("type", "TYPE1");
        Element element = document.createElement("font-name");
        object.appendChild(element);
        element.appendChild(document.createTextNode(pFMFile.getPostscriptName()));
        element = document.createElement("embed");
        object.appendChild(element);
        if (string4 != null) {
            element.setAttribute("file", string4);
        }
        if (string3 != null) {
            element.setAttribute("class", string3);
        }
        element = document.createElement("encoding");
        object.appendChild(element);
        element.appendChild(document.createTextNode(pFMFile.getCharSetName() + "Encoding"));
        element = document.createElement("cap-height");
        object.appendChild(element);
        Integer n = new Integer(pFMFile.getCapHeight());
        element.appendChild(document.createTextNode(n.toString()));
        element = document.createElement("x-height");
        object.appendChild(element);
        n = new Integer(pFMFile.getXHeight());
        element.appendChild(document.createTextNode(n.toString()));
        element = document.createElement("ascender");
        object.appendChild(element);
        n = new Integer(pFMFile.getLowerCaseAscent());
        element.appendChild(document.createTextNode(n.toString()));
        element = document.createElement("descender");
        object.appendChild(element);
        n = new Integer(pFMFile.getLowerCaseDescent());
        element.appendChild(document.createTextNode(n.toString()));
        Element element2 = document.createElement("bbox");
        object.appendChild(element2);
        int[] nArray = pFMFile.getFontBBox();
        String[] stringArray = new String[]{"left", "bottom", "right", "top"};
        for (int i = 0; i < stringArray.length; ++i) {
            element = document.createElement(stringArray[i]);
            element2.appendChild(element);
            n = new Integer(nArray[i]);
            element.appendChild(document.createTextNode(n.toString()));
        }
        element = document.createElement("flags");
        object.appendChild(element);
        n = new Integer(pFMFile.getFlags());
        element.appendChild(document.createTextNode(n.toString()));
        element = document.createElement("stemv");
        object.appendChild(element);
        n = new Integer(pFMFile.getStemV());
        element.appendChild(document.createTextNode(n.toString()));
        element = document.createElement("italicangle");
        object.appendChild(element);
        n = new Integer(pFMFile.getItalicAngle());
        element.appendChild(document.createTextNode(n.toString()));
        element = document.createElement("first-char");
        object.appendChild(element);
        n = new Integer(pFMFile.getFirstChar());
        element.appendChild(document.createTextNode(n.toString()));
        element = document.createElement("last-char");
        object.appendChild(element);
        n = new Integer(pFMFile.getLastChar());
        element.appendChild(document.createTextNode(n.toString()));
        Element element3 = document.createElement("widths");
        object.appendChild(element3);
        for (short s = pFMFile.getFirstChar(); s <= pFMFile.getLastChar(); s = (short)(s + 1)) {
            element = document.createElement("char");
            element3.appendChild(element);
            element.setAttribute("idx", Integer.toString(s));
            element.setAttribute("wdt", Integer.toString(pFMFile.getCharWidth(s)));
        }
        for (Integer n2 : pFMFile.getKerning().keySet()) {
            element = document.createElement("kerning");
            element.setAttribute("kpx1", n2.toString());
            object.appendChild(element);
            Element element4 = null;
            Map map = (Map)pFMFile.getKerning().get(n2);
            for (Map.Entry entry : map.entrySet()) {
                Integer n3 = (Integer)entry.getKey();
                element4 = document.createElement("pair");
                element4.setAttribute("kpx2", n3.toString());
                Integer n4 = (Integer)entry.getValue();
                element4.setAttribute("kern", n4.toString());
                element.appendChild(element4);
            }
        }
        return document;
    }
}

