/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontReader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Typeface;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyFont
extends Typeface
implements FontDescriptor,
Substitutable,
Positionable {
    private static Log log = LogFactory.getLog(LazyFont.class);
    private String metricsFileName;
    private String fontEmbedPath;
    private boolean useKerning;
    private boolean useAdvanced;
    private EncodingMode encodingMode = EncodingMode.AUTO;
    private EmbeddingMode embeddingMode = EmbeddingMode.AUTO;
    private boolean embedded = true;
    private String subFontName;
    private boolean isMetricsLoaded;
    private Typeface realFont;
    private FontDescriptor realFontDescriptor;
    private FontResolver resolver;

    public LazyFont(EmbedFontInfo embedFontInfo, FontResolver fontResolver) {
        this.metricsFileName = embedFontInfo.getMetricsFile();
        this.fontEmbedPath = embedFontInfo.getEmbedFile();
        this.useKerning = embedFontInfo.getKerning();
        this.useAdvanced = fontResolver != null ? fontResolver.isComplexScriptFeaturesEnabled() : embedFontInfo.getAdvanced();
        this.encodingMode = embedFontInfo.getEncodingMode();
        this.embeddingMode = embedFontInfo.getEmbeddingMode();
        this.subFontName = embedFontInfo.getSubFontName();
        this.embedded = embedFontInfo.isEmbedded();
        this.resolver = fontResolver;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append('{');
        stringBuffer.append("metrics-url=" + this.metricsFileName);
        stringBuffer.append(",embed-url=" + this.fontEmbedPath);
        stringBuffer.append(",kerning=" + this.useKerning);
        stringBuffer.append(",advanced=" + this.useAdvanced);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private void load(boolean bl) {
        if (!this.isMetricsLoaded) {
            block18: {
                try {
                    if (this.metricsFileName != null) {
                        FontReader fontReader = null;
                        if (this.resolver != null) {
                            Source source = this.resolver.resolve(this.metricsFileName);
                            if (source == null) {
                                String string = "Cannot load font: failed to create Source from metrics file " + this.metricsFileName;
                                if (bl) {
                                    throw new RuntimeException(string);
                                }
                                log.error((Object)string);
                                return;
                            }
                            InputStream inputStream = null;
                            if (source instanceof StreamSource) {
                                inputStream = ((StreamSource)source).getInputStream();
                            }
                            if (inputStream == null && source.getSystemId() != null) {
                                inputStream = new URL(source.getSystemId()).openStream();
                            }
                            if (inputStream == null) {
                                String string = "Cannot load font: After URI resolution, the returned Source object does not contain an InputStream or a valid URL (system identifier) for metrics file: " + this.metricsFileName;
                                if (bl) {
                                    throw new RuntimeException(string);
                                }
                                log.error((Object)string);
                                return;
                            }
                            InputSource inputSource = new InputSource(inputStream);
                            inputSource.setSystemId(source.getSystemId());
                            fontReader = new FontReader(inputSource);
                        } else {
                            fontReader = new FontReader(new InputSource(new URL(this.metricsFileName).openStream()));
                        }
                        fontReader.setKerningEnabled(this.useKerning);
                        fontReader.setAdvancedEnabled(this.useAdvanced);
                        if (this.embedded) {
                            fontReader.setFontEmbedPath(this.fontEmbedPath);
                        }
                        fontReader.setResolver(this.resolver);
                        this.realFont = fontReader.getFont();
                    } else {
                        if (this.fontEmbedPath == null) {
                            throw new RuntimeException("Cannot load font. No font URIs available.");
                        }
                        this.realFont = FontLoader.loadFont(this.fontEmbedPath, this.subFontName, this.embedded, this.embeddingMode, this.encodingMode, this.useKerning, this.useAdvanced, this.resolver);
                    }
                    if (this.realFont instanceof FontDescriptor) {
                        this.realFontDescriptor = (FontDescriptor)((Object)this.realFont);
                    }
                }
                catch (FOPException fOPException) {
                    log.error((Object)("Failed to read font metrics file " + this.metricsFileName), (Throwable)fOPException);
                    if (bl) {
                        throw new RuntimeException(fOPException.getMessage());
                    }
                }
                catch (IOException iOException) {
                    log.error((Object)("Failed to read font metrics file " + this.metricsFileName), (Throwable)iOException);
                    if (!bl) break block18;
                    throw new RuntimeException(iOException.getMessage());
                }
            }
            this.realFont.setEventListener(this.eventListener);
            this.isMetricsLoaded = true;
        }
    }

    public Typeface getRealFont() {
        this.load(false);
        return this.realFont;
    }

    @Override
    public String getEncodingName() {
        this.load(true);
        return this.realFont.getEncodingName();
    }

    @Override
    public char mapChar(char c) {
        this.load(true);
        return this.realFont.mapChar(c);
    }

    @Override
    public boolean hadMappingOperations() {
        this.load(true);
        return this.realFont.hadMappingOperations();
    }

    @Override
    public boolean hasChar(char c) {
        this.load(true);
        return this.realFont.hasChar(c);
    }

    @Override
    public boolean isMultiByte() {
        this.load(true);
        return this.realFont.isMultiByte();
    }

    @Override
    public String getFontName() {
        this.load(true);
        return this.realFont.getFontName();
    }

    @Override
    public String getEmbedFontName() {
        this.load(true);
        return this.realFont.getEmbedFontName();
    }

    @Override
    public String getFullName() {
        this.load(true);
        return this.realFont.getFullName();
    }

    @Override
    public Set<String> getFamilyNames() {
        this.load(true);
        return this.realFont.getFamilyNames();
    }

    @Override
    public int getMaxAscent(int n) {
        this.load(true);
        return this.realFont.getMaxAscent(n);
    }

    @Override
    public int getAscender(int n) {
        this.load(true);
        return this.realFont.getAscender(n);
    }

    @Override
    public int getCapHeight(int n) {
        this.load(true);
        return this.realFont.getCapHeight(n);
    }

    @Override
    public int getDescender(int n) {
        this.load(true);
        return this.realFont.getDescender(n);
    }

    @Override
    public int getXHeight(int n) {
        this.load(true);
        return this.realFont.getXHeight(n);
    }

    @Override
    public int getWidth(int n, int n2) {
        this.load(true);
        return this.realFont.getWidth(n, n2);
    }

    @Override
    public int[] getWidths() {
        this.load(true);
        return this.realFont.getWidths();
    }

    @Override
    public boolean hasKerningInfo() {
        this.load(true);
        return this.realFont.hasKerningInfo();
    }

    @Override
    public Map<Integer, Map<Integer, Integer>> getKerningInfo() {
        this.load(true);
        return this.realFont.getKerningInfo();
    }

    @Override
    public int getCapHeight() {
        this.load(true);
        return this.realFontDescriptor.getCapHeight();
    }

    @Override
    public int getDescender() {
        this.load(true);
        return this.realFontDescriptor.getDescender();
    }

    @Override
    public int getAscender() {
        this.load(true);
        return this.realFontDescriptor.getAscender();
    }

    @Override
    public int getFlags() {
        this.load(true);
        return this.realFontDescriptor.getFlags();
    }

    @Override
    public boolean isSymbolicFont() {
        this.load(true);
        return this.realFontDescriptor.isSymbolicFont();
    }

    @Override
    public int[] getFontBBox() {
        this.load(true);
        return this.realFontDescriptor.getFontBBox();
    }

    @Override
    public int getItalicAngle() {
        this.load(true);
        return this.realFontDescriptor.getItalicAngle();
    }

    @Override
    public int getStemV() {
        this.load(true);
        return this.realFontDescriptor.getStemV();
    }

    @Override
    public FontType getFontType() {
        this.load(true);
        return this.realFontDescriptor.getFontType();
    }

    @Override
    public boolean isEmbeddable() {
        this.load(true);
        return this.realFontDescriptor.isEmbeddable();
    }

    @Override
    public boolean performsSubstitution() {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).performsSubstitution();
        }
        return false;
    }

    @Override
    public CharSequence performSubstitution(CharSequence charSequence, String string, String string2) {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).performSubstitution(charSequence, string, string2);
        }
        return charSequence;
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence charSequence, int[][] nArray, String string, String string2) {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).reorderCombiningMarks(charSequence, nArray, string, string2);
        }
        return charSequence;
    }

    @Override
    public boolean performsPositioning() {
        this.load(true);
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performsPositioning();
        }
        return false;
    }

    @Override
    public int[][] performPositioning(CharSequence charSequence, String string, String string2, int n) {
        this.load(true);
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performPositioning(charSequence, string, string2, n);
        }
        return null;
    }

    @Override
    public int[][] performPositioning(CharSequence charSequence, String string, String string2) {
        this.load(true);
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performPositioning(charSequence, string, string2);
        }
        return null;
    }

    @Override
    public boolean isSubsetEmbedded() {
        this.load(true);
        return this.realFont.isMultiByte();
    }
}

