/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public class CompoundPropertyMaker
extends PropertyMaker {
    private PropertyMaker[] subproperties = new PropertyMaker[11];
    private PropertyMaker shorthandMaker = null;

    public CompoundPropertyMaker(int n) {
        super(n);
    }

    public void useGeneric(PropertyMaker propertyMaker) {
        super.useGeneric(propertyMaker);
        if (propertyMaker instanceof CompoundPropertyMaker) {
            CompoundPropertyMaker compoundPropertyMaker = (CompoundPropertyMaker)propertyMaker;
            for (int i = 0; i < 11; ++i) {
                PropertyMaker propertyMaker2 = compoundPropertyMaker.subproperties[i];
                if (propertyMaker2 == null) continue;
                this.addSubpropMaker((PropertyMaker)propertyMaker2.clone());
            }
        }
    }

    public void addSubpropMaker(PropertyMaker propertyMaker) {
        propertyMaker.propId &= 0xFFFFFE00;
        propertyMaker.propId |= this.propId;
        this.subproperties[this.getSubpropIndex((int)propertyMaker.getPropId())] = propertyMaker;
        if (this.shorthandMaker == null && propertyMaker.setByShorthand) {
            this.shorthandMaker = propertyMaker;
        }
    }

    public PropertyMaker getSubpropMaker(int n) {
        return this.subproperties[this.getSubpropIndex(n)];
    }

    private int getSubpropIndex(int n) {
        return ((n & 0xFFFFFE00) >> 9) - 1;
    }

    protected Property checkEnumValues(String string) {
        Property property = null;
        if (this.shorthandMaker != null) {
            property = this.shorthandMaker.checkEnumValues(string);
        }
        if (property == null) {
            property = super.checkEnumValues(string);
        }
        return property;
    }

    public Property get(int n, PropertyList propertyList, boolean bl, boolean bl2) throws PropertyException {
        Property property = super.get(n, propertyList, bl, bl2);
        if (n != 0 && property != null) {
            property = this.getSubprop(property, n);
        }
        return property;
    }

    protected Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
        if ((property = this.shorthandMaker.convertProperty(property, propertyList, fObj)) != null) {
            Property property2 = this.makeCompound(propertyList, fObj);
            CompoundDatatype compoundDatatype = (CompoundDatatype)property2.getObject();
            for (int i = 0; i < 11; ++i) {
                PropertyMaker propertyMaker = this.subproperties[i];
                if (propertyMaker == null || !propertyMaker.setByShorthand) continue;
                compoundDatatype.setComponent(propertyMaker.getPropId() & 0xFFFFFE00, property, false);
            }
            return property2;
        }
        return null;
    }

    public Property make(PropertyList propertyList) throws PropertyException {
        if (this.defaultValue != null) {
            return this.make(propertyList, this.defaultValue, propertyList.getParentFObj());
        }
        return this.makeCompound(propertyList, propertyList.getParentFObj());
    }

    public Property make(PropertyList propertyList, String string, FObj fObj) throws PropertyException {
        Property property = super.make(propertyList, string, fObj);
        property = this.convertProperty(property, propertyList, fObj);
        return property;
    }

    public Property make(Property property, int n, PropertyList propertyList, String string, FObj fObj) throws PropertyException {
        Property property2;
        PropertyMaker propertyMaker;
        if (property == null) {
            property = this.makeCompound(propertyList, fObj);
        }
        if ((propertyMaker = this.getSubpropMaker(n)) != null && (property2 = propertyMaker.make(propertyList, string, fObj)) != null) {
            return this.setSubprop(property, n & 0xFFFFFE00, property2);
        }
        return property;
    }

    protected Property makeCompound(PropertyList propertyList, FObj fObj) throws PropertyException {
        Property property = this.makeNewProperty();
        CompoundDatatype compoundDatatype = (CompoundDatatype)property.getObject();
        for (int i = 0; i < 11; ++i) {
            PropertyMaker propertyMaker = this.subproperties[i];
            if (propertyMaker == null) continue;
            Property property2 = propertyMaker.make(propertyList);
            compoundDatatype.setComponent(propertyMaker.getPropId() & 0xFFFFFE00, property2, true);
        }
        return property;
    }
}

