/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.xml.sax.Locator;

public class LayoutMasterSet
extends FObj {
    private Map<String, SimplePageMaster> simplePageMasters;
    private Map<String, PageSequenceMaster> pageSequenceMasters;

    public LayoutMasterSet(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
    }

    protected void startOfNode() throws FOPException {
        this.getRoot().setLayoutMasterSet(this);
        this.simplePageMasters = new HashMap<String, SimplePageMaster>();
        this.pageSequenceMasters = new HashMap<String, PageSequenceMaster>();
    }

    protected void endOfNode() throws FOPException {
        if (this.firstChild == null) {
            this.missingChildElementError("(simple-page-master|page-sequence-master)+");
        }
        this.checkRegionNames();
        this.resolveSubSequenceReferences();
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string) && !string2.equals("simple-page-master") && !string2.equals("page-sequence-master")) {
            this.invalidChildError(locator, string, string2);
        }
    }

    private void checkRegionNames() throws ValidationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (SimplePageMaster simplePageMaster : this.simplePageMasters.values()) {
            Map<String, Region> map = simplePageMaster.getRegions();
            for (Region region : map.values()) {
                String string;
                if (hashMap.containsKey(region.getRegionName()) && !(string = (String)hashMap.get(region.getRegionName())).equals(region.getDefaultRegionName())) {
                    this.getFOValidationEventProducer().regionNameMappedToMultipleRegionClasses(this, region.getRegionName(), string, region.getDefaultRegionName(), this.getLocator());
                }
                hashMap.put(region.getRegionName(), region.getDefaultRegionName());
            }
        }
    }

    private void resolveSubSequenceReferences() throws ValidationException {
        for (PageSequenceMaster pageSequenceMaster : this.pageSequenceMasters.values()) {
            for (SubSequenceSpecifier subSequenceSpecifier : pageSequenceMaster.getSubSequenceSpecifier()) {
                subSequenceSpecifier.resolveReferences(this);
            }
        }
    }

    protected void addSimplePageMaster(SimplePageMaster simplePageMaster) throws ValidationException {
        String string = simplePageMaster.getMasterName();
        if (this.existsName(string)) {
            this.getFOValidationEventProducer().masterNameNotUnique(this, this.getName(), string, simplePageMaster.getLocator());
        }
        this.simplePageMasters.put(string, simplePageMaster);
    }

    private boolean existsName(String string) {
        return this.simplePageMasters.containsKey(string) || this.pageSequenceMasters.containsKey(string);
    }

    public SimplePageMaster getSimplePageMaster(String string) {
        return this.simplePageMasters.get(string);
    }

    protected void addPageSequenceMaster(String string, PageSequenceMaster pageSequenceMaster) throws ValidationException {
        if (this.existsName(string)) {
            this.getFOValidationEventProducer().masterNameNotUnique(this, this.getName(), string, pageSequenceMaster.getLocator());
        }
        this.pageSequenceMasters.put(string, pageSequenceMaster);
    }

    public PageSequenceMaster getPageSequenceMaster(String string) {
        return this.pageSequenceMasters.get(string);
    }

    public boolean regionNameExists(String string) {
        for (SimplePageMaster simplePageMaster : this.simplePageMasters.values()) {
            if (!simplePageMaster.regionNameExists(string)) continue;
            return true;
        }
        return false;
    }

    public String getLocalName() {
        return "layout-master-set";
    }

    public int getNameId() {
        return 38;
    }
}

