/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.fo.flow.table.BorderSpecification;
import org.apache.fop.fo.flow.table.ConditionalBorder;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;

public class GridUnit {
    public static final int FIRST_IN_PART = 0;
    public static final int LAST_IN_PART = 1;
    public static final int KEEP_WITH_NEXT_PENDING = 2;
    public static final int KEEP_WITH_PREVIOUS_PENDING = 3;
    private PrimaryGridUnit primary;
    protected TableCell cell;
    private TableRow row;
    private int colSpanIndex;
    private int rowSpanIndex;
    private byte flags = 0;
    ConditionalBorder borderBefore;
    ConditionalBorder borderAfter;
    BorderSpecification borderStart;
    BorderSpecification borderEnd;
    protected CollapsingBorderModel collapsingBorderModel;

    protected GridUnit(Table table, int n, int n2) {
        this(n, n2);
        this.setBorders(table);
    }

    protected GridUnit(TableCell tableCell, int n, int n2) {
        this(n, n2);
        this.cell = tableCell;
        this.setBorders(tableCell.getTable());
    }

    GridUnit(PrimaryGridUnit primaryGridUnit, int n, int n2) {
        this(primaryGridUnit.getCell(), n, n2);
        this.primary = primaryGridUnit;
    }

    private GridUnit(int n, int n2) {
        this.colSpanIndex = n;
        this.rowSpanIndex = n2;
    }

    private void setBorders(Table table) {
        if (!table.isSeparateBorderModel()) {
            this.collapsingBorderModel = CollapsingBorderModel.getBorderModelFor(table.getBorderCollapse());
            this.setBordersFromCell();
        }
    }

    protected void setBordersFromCell() {
        this.borderBefore = this.cell.borderBefore.copy();
        if (this.rowSpanIndex > 0) {
            this.borderBefore.normal = BorderSpecification.getDefaultBorder();
        }
        this.borderAfter = this.cell.borderAfter.copy();
        if (!this.isLastGridUnitRowSpan()) {
            this.borderAfter.normal = BorderSpecification.getDefaultBorder();
        }
        this.borderStart = this.colSpanIndex == 0 ? this.cell.borderStart : BorderSpecification.getDefaultBorder();
        this.borderEnd = this.isLastGridUnitColSpan() ? this.cell.borderEnd : BorderSpecification.getDefaultBorder();
    }

    public TableCell getCell() {
        return this.cell;
    }

    public TableRow getRow() {
        return this.row;
    }

    void setRow(TableRow tableRow) {
        this.row = tableRow;
    }

    public PrimaryGridUnit getPrimary() {
        return this.primary;
    }

    public boolean isPrimary() {
        return false;
    }

    public boolean isEmpty() {
        return this.cell == null;
    }

    public boolean isLastGridUnitColSpan() {
        return this.colSpanIndex == this.cell.getNumberColumnsSpanned() - 1;
    }

    public boolean isLastGridUnitRowSpan() {
        return this.rowSpanIndex == this.cell.getNumberRowsSpanned() - 1;
    }

    public int getRowSpanIndex() {
        return this.rowSpanIndex;
    }

    public int getColSpanIndex() {
        return this.colSpanIndex;
    }

    public CommonBorderPaddingBackground.BorderInfo getBorderBefore(int n) {
        switch (n) {
            case 0: {
                return this.borderBefore.normal.getBorderInfo();
            }
            case 1: {
                return this.borderBefore.leadingTrailing.getBorderInfo();
            }
            case 2: {
                return this.borderBefore.rest.getBorderInfo();
            }
        }
        assert (false);
        return null;
    }

    public CommonBorderPaddingBackground.BorderInfo getBorderAfter(int n) {
        switch (n) {
            case 0: {
                return this.borderAfter.normal.getBorderInfo();
            }
            case 1: {
                return this.borderAfter.leadingTrailing.getBorderInfo();
            }
            case 2: {
                return this.borderAfter.rest.getBorderInfo();
            }
        }
        assert (false);
        return null;
    }

    public CommonBorderPaddingBackground.BorderInfo getBorderStart() {
        return this.borderStart.getBorderInfo();
    }

    public CommonBorderPaddingBackground.BorderInfo getBorderEnd() {
        return this.borderEnd.getBorderInfo();
    }

    void resolveBorder(GridUnit gridUnit, int n) {
        switch (n) {
            case 0: {
                this.borderBefore.resolve(gridUnit.borderAfter, true, false, false);
                break;
            }
            case 1: {
                this.borderAfter.resolve(gridUnit.borderBefore, true, false, false);
                break;
            }
            case 2: {
                BorderSpecification borderSpecification = this.collapsingBorderModel.determineWinner(this.borderStart, gridUnit.borderEnd);
                if (borderSpecification == null) break;
                this.borderStart = borderSpecification;
                gridUnit.borderEnd = borderSpecification;
                break;
            }
            case 3: {
                BorderSpecification borderSpecification = this.collapsingBorderModel.determineWinner(this.borderEnd, gridUnit.borderStart);
                if (borderSpecification == null) break;
                this.borderEnd = borderSpecification;
                gridUnit.borderStart = borderSpecification;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void integrateBorderSegment(int n, TableFObj tableFObj, boolean bl, boolean bl2, boolean bl3) {
        switch (n) {
            case 0: {
                this.borderBefore.integrateSegment(tableFObj.borderBefore, bl, bl2, bl3);
                break;
            }
            case 1: {
                this.borderAfter.integrateSegment(tableFObj.borderAfter, bl, bl2, bl3);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void integrateBorderSegment(int n, TableFObj tableFObj) {
        switch (n) {
            case 0: 
            case 1: {
                this.integrateBorderSegment(n, tableFObj, true, true, true);
                break;
            }
            case 2: {
                this.borderStart = this.collapsingBorderModel.determineWinner(this.borderStart, tableFObj.borderStart);
                break;
            }
            case 3: {
                this.borderEnd = this.collapsingBorderModel.determineWinner(this.borderEnd, tableFObj.borderEnd);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void integrateBorderSegment(int n, BorderSpecification borderSpecification) {
        switch (n) {
            case 2: {
                this.borderStart = this.collapsingBorderModel.determineWinner(this.borderStart, borderSpecification);
                break;
            }
            case 3: {
                this.borderEnd = this.collapsingBorderModel.determineWinner(this.borderEnd, borderSpecification);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void integrateCompetingBorder(int n, ConditionalBorder conditionalBorder, boolean bl, boolean bl2, boolean bl3) {
        switch (n) {
            case 0: {
                this.borderBefore.integrateCompetingSegment(conditionalBorder, bl, bl2, bl3);
                break;
            }
            case 1: {
                this.borderAfter.integrateCompetingSegment(conditionalBorder, bl, bl2, bl3);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public boolean getFlag(int n) {
        return (this.flags & 1 << n) != 0;
    }

    public void setFlag(int n, boolean bl) {
        this.flags = bl ? (byte)(this.flags | 1 << n) : (byte)(this.flags & ~(1 << n));
    }

    public void setFlag(int n) {
        this.setFlag(n, true);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEmpty()) {
            stringBuffer.append("EMPTY");
        } else if (this.isPrimary()) {
            stringBuffer.append("Primary");
        }
        stringBuffer.append("GridUnit:");
        if (this.colSpanIndex > 0) {
            stringBuffer.append(" colSpan=").append(this.colSpanIndex);
            if (this.isLastGridUnitColSpan()) {
                stringBuffer.append("(last)");
            }
        }
        if (this.rowSpanIndex > 0) {
            stringBuffer.append(" rowSpan=").append(this.rowSpanIndex);
            if (this.isLastGridUnitRowSpan()) {
                stringBuffer.append("(last)");
            }
        }
        if (!this.isPrimary() && this.getPrimary() != null) {
            stringBuffer.append(" primary=").append(this.getPrimary().getRowIndex());
            stringBuffer.append("/").append(this.getPrimary().getColIndex());
            if (this.getPrimary().getCell() != null) {
                stringBuffer.append(" id=" + this.getPrimary().getCell().getId());
            }
        }
        stringBuffer.append(" flags=").append(Integer.toBinaryString(this.flags));
        return stringBuffer.toString();
    }
}

