/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.fo.flow.table.BorderResolver;
import org.apache.fop.fo.flow.table.BorderSpecification;
import org.apache.fop.fo.flow.table.ConditionalBorder;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCellContainer;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;

class CollapsingBorderResolver
implements BorderResolver {
    private Table table;
    private CollapsingBorderModel collapsingBorderModel;
    private List previousRow;
    private boolean firstInTable;
    private List footerFirstRow;
    private List footerLastRow;
    private Resolver delegate;
    private Resolver resolverInBody = new ResolverInBody();
    private Resolver resolverInFooter;
    private List leadingBorders;
    private List trailingBorders;
    private List headerLastRow = null;

    CollapsingBorderResolver(Table table) {
        TableColumn tableColumn;
        this.table = table;
        this.collapsingBorderModel = CollapsingBorderModel.getBorderModelFor(table.getBorderCollapse());
        this.firstInTable = true;
        int n = 0;
        do {
            tableColumn = table.getColumn(n);
            tableColumn.borderBefore.integrateSegment(table.borderBefore, true, false, true);
            tableColumn.borderBefore.leadingTrailing = tableColumn.borderBefore.rest;
            tableColumn.borderAfter.integrateSegment(table.borderAfter, true, false, true);
            tableColumn.borderAfter.leadingTrailing = tableColumn.borderAfter.rest;
        } while ((n += tableColumn.getNumberColumnsRepeated()) < table.getNumberOfColumns());
    }

    public void endRow(List list, TableCellContainer tableCellContainer) {
        this.delegate.endRow(list, tableCellContainer);
    }

    public void startPart(TablePart tablePart) {
        if (tablePart instanceof TableHeader) {
            this.delegate = new ResolverInHeader();
        } else {
            ConditionalBorder conditionalBorder;
            Iterator iterator;
            if (this.leadingBorders == null || this.table.omitHeaderAtBreak()) {
                this.leadingBorders = new ArrayList(this.table.getNumberOfColumns());
                iterator = this.table.getColumns().iterator();
                while (iterator.hasNext()) {
                    conditionalBorder = ((TableColumn)iterator.next()).borderBefore;
                    this.leadingBorders.add(conditionalBorder);
                }
            }
            if (tablePart instanceof TableFooter) {
                this.delegate = this.resolverInFooter = new ResolverInFooter();
            } else {
                if (this.trailingBorders == null || this.table.omitFooterAtBreak()) {
                    this.trailingBorders = new ArrayList(this.table.getNumberOfColumns());
                    iterator = this.table.getColumns().iterator();
                    while (iterator.hasNext()) {
                        conditionalBorder = ((TableColumn)iterator.next()).borderAfter;
                        this.trailingBorders.add(conditionalBorder);
                    }
                }
                this.delegate = this.resolverInBody;
            }
        }
        this.delegate.startPart(tablePart);
    }

    public void endPart() {
        this.delegate.endPart();
    }

    public void endTable() {
        this.delegate.endTable();
        this.delegate = null;
        if (this.headerLastRow != null) {
            for (GridUnit gridUnit : this.headerLastRow) {
                gridUnit.borderAfter.leadingTrailing = gridUnit.borderAfter.normal;
            }
        }
        if (this.footerLastRow != null) {
            for (GridUnit gridUnit : this.footerLastRow) {
                gridUnit.borderAfter.leadingTrailing = gridUnit.borderAfter.normal;
            }
        }
    }

    private class ResolverInBody
    extends Resolver {
        private boolean firstInBody;

        private ResolverInBody() {
            this.firstInBody = true;
        }

        void endRow(List list, TableCellContainer tableCellContainer) {
            super.endRow(list, tableCellContainer);
            if (CollapsingBorderResolver.this.firstInTable) {
                this.resolveBordersFirstRowInTable(list, true, true, true);
            } else {
                this.resolveBordersBetweenRows(CollapsingBorderResolver.this.previousRow, list);
                this.integrateLeadingBorders(list);
            }
            this.integrateTrailingBorders(list);
            CollapsingBorderResolver.this.previousRow = list;
            if (this.firstInBody) {
                this.firstInBody = false;
                for (GridUnit gridUnit : list) {
                    gridUnit.borderBefore.leadingTrailing = gridUnit.borderBefore.normal;
                }
            }
        }

        void endTable() {
            if (CollapsingBorderResolver.this.resolverInFooter != null) {
                CollapsingBorderResolver.this.resolverInFooter.endTable();
            } else {
                this.resolveBordersLastRowInTable(CollapsingBorderResolver.this.previousRow, true, false, false);
            }
            for (GridUnit gridUnit : CollapsingBorderResolver.this.previousRow) {
                gridUnit.borderAfter.leadingTrailing = gridUnit.borderAfter.normal;
            }
        }
    }

    private class ResolverInFooter
    extends Resolver {
        private ResolverInFooter() {
        }

        void endRow(List list, TableCellContainer tableCellContainer) {
            super.endRow(list, tableCellContainer);
            if (CollapsingBorderResolver.this.footerFirstRow == null) {
                CollapsingBorderResolver.this.footerFirstRow = list;
            } else {
                this.resolveBordersBetweenRows(CollapsingBorderResolver.this.footerLastRow, list);
            }
            CollapsingBorderResolver.this.footerLastRow = list;
        }

        void endPart() {
            this.resolveBordersLastRowInPart(CollapsingBorderResolver.this.footerLastRow, true, true, true);
            CollapsingBorderResolver.this.trailingBorders = new ArrayList(CollapsingBorderResolver.this.table.getNumberOfColumns());
            Iterator iterator = CollapsingBorderResolver.this.footerFirstRow.iterator();
            while (iterator.hasNext()) {
                ConditionalBorder conditionalBorder = ((GridUnit)iterator.next()).borderBefore;
                conditionalBorder.leadingTrailing = conditionalBorder.normal;
                conditionalBorder.rest = conditionalBorder.normal;
                CollapsingBorderResolver.this.trailingBorders.add(conditionalBorder);
            }
        }

        void endTable() {
            this.resolveBordersBetweenRows(CollapsingBorderResolver.this.previousRow, CollapsingBorderResolver.this.footerFirstRow);
            Iterator iterator = CollapsingBorderResolver.this.footerLastRow.iterator();
            while (iterator.hasNext()) {
                ConditionalBorder conditionalBorder = ((GridUnit)iterator.next()).borderAfter;
                conditionalBorder.leadingTrailing = conditionalBorder.normal;
                conditionalBorder.rest = conditionalBorder.normal;
            }
            this.resolveBordersLastRowInTable(CollapsingBorderResolver.this.footerLastRow, true, false, true);
        }
    }

    private class ResolverInHeader
    extends Resolver {
        private ResolverInHeader() {
        }

        void endRow(List list, TableCellContainer tableCellContainer) {
            super.endRow(list, tableCellContainer);
            if (CollapsingBorderResolver.this.previousRow != null) {
                this.resolveBordersBetweenRows(CollapsingBorderResolver.this.previousRow, list);
            } else {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ConditionalBorder conditionalBorder = ((GridUnit)iterator.next()).borderBefore;
                    conditionalBorder.leadingTrailing = conditionalBorder.normal;
                    conditionalBorder.rest = conditionalBorder.normal;
                }
                this.resolveBordersFirstRowInTable(list, true, false, true);
            }
            CollapsingBorderResolver.this.previousRow = list;
        }

        void endPart() {
            super.endPart();
            CollapsingBorderResolver.this.leadingBorders = new ArrayList(CollapsingBorderResolver.this.table.getNumberOfColumns());
            Iterator iterator = CollapsingBorderResolver.this.previousRow.iterator();
            while (iterator.hasNext()) {
                ConditionalBorder conditionalBorder = ((GridUnit)iterator.next()).borderAfter;
                conditionalBorder.leadingTrailing = conditionalBorder.normal;
                conditionalBorder.rest = conditionalBorder.normal;
                CollapsingBorderResolver.this.leadingBorders.add(conditionalBorder);
            }
            CollapsingBorderResolver.this.headerLastRow = CollapsingBorderResolver.this.previousRow;
        }

        void endTable() {
            throw new IllegalStateException();
        }
    }

    private abstract class Resolver {
        protected TablePart tablePart;
        protected boolean firstInPart;
        private BorderSpecification borderStartTableAndBody;
        private BorderSpecification borderEndTableAndBody;

        private Resolver() {
        }

        void resolveBordersFirstRowInTable(List list, boolean bl, boolean bl2, boolean bl3) {
            assert (CollapsingBorderResolver.this.firstInTable);
            for (int i = 0; i < list.size(); ++i) {
                TableColumn tableColumn = CollapsingBorderResolver.this.table.getColumn(i);
                ((GridUnit)list.get(i)).integrateBorderSegment(0, tableColumn, bl, bl2, bl3);
            }
            CollapsingBorderResolver.this.firstInTable = false;
        }

        void resolveBordersBetweenRows(List list, List list2) {
            assert (list != null && list2 != null);
            for (int i = 0; i < list2.size(); ++i) {
                GridUnit gridUnit = (GridUnit)list2.get(i);
                if (gridUnit.getRowSpanIndex() != 0) continue;
                GridUnit gridUnit2 = (GridUnit)list.get(i);
                gridUnit.resolveBorder(gridUnit2, 0);
            }
        }

        void resolveBordersLastRowInPart(List list, boolean bl, boolean bl2, boolean bl3) {
            for (int i = 0; i < list.size(); ++i) {
                ((GridUnit)list.get(i)).integrateBorderSegment(1, this.tablePart, bl, bl2, bl3);
            }
        }

        void resolveBordersLastRowInTable(List list, boolean bl, boolean bl2, boolean bl3) {
            for (int i = 0; i < list.size(); ++i) {
                TableColumn tableColumn = CollapsingBorderResolver.this.table.getColumn(i);
                ((GridUnit)list.get(i)).integrateBorderSegment(1, tableColumn, bl, bl2, bl3);
            }
        }

        void integrateLeadingBorders(List list) {
            for (int i = 0; i < CollapsingBorderResolver.this.table.getNumberOfColumns(); ++i) {
                GridUnit gridUnit = (GridUnit)list.get(i);
                ConditionalBorder conditionalBorder = (ConditionalBorder)CollapsingBorderResolver.this.leadingBorders.get(i);
                gridUnit.integrateCompetingBorder(0, conditionalBorder, false, true, true);
            }
        }

        void integrateTrailingBorders(List list) {
            for (int i = 0; i < CollapsingBorderResolver.this.table.getNumberOfColumns(); ++i) {
                GridUnit gridUnit = (GridUnit)list.get(i);
                ConditionalBorder conditionalBorder = (ConditionalBorder)CollapsingBorderResolver.this.trailingBorders.get(i);
                gridUnit.integrateCompetingBorder(1, conditionalBorder, false, true, true);
            }
        }

        void startPart(TablePart tablePart) {
            this.tablePart = tablePart;
            this.firstInPart = true;
            this.borderStartTableAndBody = CollapsingBorderResolver.this.collapsingBorderModel.determineWinner(((CollapsingBorderResolver)CollapsingBorderResolver.this).table.borderStart, this.tablePart.borderStart);
            this.borderEndTableAndBody = CollapsingBorderResolver.this.collapsingBorderModel.determineWinner(((CollapsingBorderResolver)CollapsingBorderResolver.this).table.borderEnd, this.tablePart.borderEnd);
        }

        void endRow(List list, TableCellContainer tableCellContainer) {
            Object object3;
            Object object2;
            BorderSpecification borderSpecification = this.borderStartTableAndBody;
            BorderSpecification borderSpecification2 = this.borderEndTableAndBody;
            if (tableCellContainer instanceof TableRow) {
                object2 = (TableRow)tableCellContainer;
                for (Object object3 : list) {
                    boolean bl = ((GridUnit)object3).getRowSpanIndex() == 0;
                    boolean bl2 = ((GridUnit)object3).isLastGridUnitRowSpan();
                    ((GridUnit)object3).integrateBorderSegment(0, (TableFObj)object2, bl, bl, true);
                    ((GridUnit)object3).integrateBorderSegment(1, (TableFObj)object2, bl2, bl2, true);
                }
                borderSpecification = CollapsingBorderResolver.this.collapsingBorderModel.determineWinner(borderSpecification, ((TableRow)object2).borderStart);
                borderSpecification2 = CollapsingBorderResolver.this.collapsingBorderModel.determineWinner(borderSpecification2, ((TableRow)object2).borderEnd);
            }
            if (this.firstInPart) {
                for (int i = 0; i < list.size(); ++i) {
                    ((GridUnit)list.get(i)).integrateBorderSegment(0, this.tablePart, true, true, true);
                }
                this.firstInPart = false;
            }
            object2 = list.iterator();
            Object object4 = (GridUnit)object2.next();
            object3 = CollapsingBorderResolver.this.table.getColumns().iterator();
            TableColumn tableColumn = (TableColumn)object3.next();
            ((GridUnit)object4).integrateBorderSegment(2, tableColumn);
            ((GridUnit)object4).integrateBorderSegment(2, borderSpecification);
            while (object2.hasNext()) {
                GridUnit gridUnit = (GridUnit)object2.next();
                TableColumn tableColumn2 = (TableColumn)object3.next();
                if (((GridUnit)object4).isLastGridUnitColSpan()) {
                    ((GridUnit)object4).integrateBorderSegment(3, tableColumn);
                    gridUnit.integrateBorderSegment(2, tableColumn2);
                    ((GridUnit)object4).resolveBorder(gridUnit, 3);
                }
                object4 = gridUnit;
                tableColumn = tableColumn2;
            }
            ((GridUnit)object4).integrateBorderSegment(3, tableColumn);
            ((GridUnit)object4).integrateBorderSegment(3, borderSpecification2);
        }

        void endPart() {
            this.resolveBordersLastRowInPart(CollapsingBorderResolver.this.previousRow, true, true, true);
        }

        abstract void endTable();
    }
}

