/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Stack;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.GraphicsProperties;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fo.properties.StructureTreeElementHolder;

public abstract class AbstractGraphics
extends FObj
implements GraphicsProperties,
StructureTreeElementHolder,
CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private LengthRangeProperty blockProgressionDimension;
    private Length contentHeight;
    private Length contentWidth;
    private int displayAlign;
    private int dominantBaseline;
    private Length height;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private SpaceProperty lineHeight;
    private int overflow;
    private int scaling;
    private int textAlign;
    private Length width;
    private String altText;
    private StructureTreeElement structureTreeElement;

    public AbstractGraphics(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.alignmentAdjust = propertyList.get(3).getLength();
        this.alignmentBaseline = propertyList.get(4).getEnum();
        this.baselineShift = propertyList.get(15).getLength();
        this.blockProgressionDimension = propertyList.get(17).getLengthRange();
        this.contentHeight = propertyList.get(78).getLength();
        this.contentWidth = propertyList.get(80).getLength();
        this.displayAlign = propertyList.get(87).getEnum();
        this.dominantBaseline = propertyList.get(88).getEnum();
        this.height = propertyList.get(115).getLength();
        this.id = propertyList.get(122).getString();
        this.inlineProgressionDimension = propertyList.get(127).getLengthRange();
        this.keepWithNext = propertyList.get(132).getKeep();
        this.keepWithPrevious = propertyList.get(133).getKeep();
        this.lineHeight = propertyList.get(144).getSpace();
        this.overflow = propertyList.get(169).getEnum();
        this.scaling = propertyList.get(215).getEnum();
        this.textAlign = propertyList.get(245).getEnum();
        this.width = propertyList.get(264).getLength();
        if (this.getUserAgent().isAccessibilityEnabled()) {
            this.altText = propertyList.get(274).getString();
            if (this.altText.equals("")) {
                this.getFOValidationEventProducer().altTextMissing(this, this.getLocalName(), this.getLocator());
            }
        }
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public String getId() {
        return this.id;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public LengthRangeProperty getInlineProgressionDimension() {
        return this.inlineProgressionDimension;
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public Length getHeight() {
        return this.height;
    }

    public Length getWidth() {
        return this.width;
    }

    public Length getContentHeight() {
        return this.contentHeight;
    }

    public Length getContentWidth() {
        return this.contentWidth;
    }

    public int getScaling() {
        return this.scaling;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public int getDisplayAlign() {
        return this.displayAlign;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public Length getAlignmentAdjust() {
        Length length;
        if (this.alignmentAdjust.getEnum() == 9 && (length = this.getIntrinsicAlignmentAdjust()) != null) {
            return length;
        }
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public void setStructureTreeElement(StructureTreeElement structureTreeElement) {
        this.structureTreeElement = structureTreeElement;
    }

    public StructureTreeElement getStructureTreeElement() {
        return this.structureTreeElement;
    }

    public String getAltText() {
        return this.altText;
    }

    public abstract int getIntrinsicWidth();

    public abstract int getIntrinsicHeight();

    public abstract Length getIntrinsicAlignmentAdjust();

    public boolean isDelimitedTextRangeBoundary(int n) {
        return false;
    }

    protected Stack collectDelimitedTextRanges(Stack stack, DelimitedTextRange delimitedTextRange) {
        if (delimitedTextRange != null) {
            delimitedTextRange.append('\ufffc', (FONode)this);
        }
        return stack;
    }
}

