/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;

class RGBColorFunction
extends FunctionBase {
    RGBColorFunction() {
    }

    public int getRequiredArgsCount() {
        return 3;
    }

    public PercentBase getPercentBase() {
        return new RGBPercentBase();
    }

    public Property eval(Property[] propertyArray, PropertyInfo propertyInfo) throws PropertyException {
        return ColorProperty.getInstance(propertyInfo.getUserAgent(), "rgb(" + propertyArray[0] + "," + propertyArray[1] + "," + propertyArray[2] + ")");
    }

    private static class RGBPercentBase
    implements PercentBase {
        private RGBPercentBase() {
        }

        public int getDimension() {
            return 0;
        }

        public double getBaseValue() {
            return 255.0;
        }

        public int getBaseLength(PercentBaseContext percentBaseContext) {
            return 0;
        }
    }
}

