/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.util;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlyphSequence
implements Cloneable {
    private static final int DEFAULT_CHARS_CAPACITY = 8;
    private IntBuffer characters;
    private IntBuffer glyphs;
    private List associations;
    private boolean predications;

    public GlyphSequence(IntBuffer intBuffer, IntBuffer intBuffer2, List list, boolean bl) {
        if (intBuffer == null) {
            intBuffer = IntBuffer.allocate(8);
        }
        if (intBuffer2 == null) {
            intBuffer2 = IntBuffer.allocate(intBuffer.capacity());
        }
        if (list == null) {
            list = GlyphSequence.makeIdentityAssociations(intBuffer.limit(), intBuffer2.limit());
        }
        this.characters = intBuffer;
        this.glyphs = intBuffer2;
        this.associations = list;
        this.predications = bl;
    }

    public GlyphSequence(IntBuffer intBuffer, IntBuffer intBuffer2, List list) {
        this(intBuffer, intBuffer2, list, false);
    }

    public GlyphSequence(GlyphSequence glyphSequence) {
        this(glyphSequence.characters.duplicate(), GlyphSequence.copyBuffer(glyphSequence.glyphs), GlyphSequence.copyAssociations(glyphSequence.associations), glyphSequence.predications);
    }

    public GlyphSequence(GlyphSequence glyphSequence, int[] nArray, int[] nArray2, int[] nArray3, CharAssociation[] charAssociationArray, CharAssociation[] charAssociationArray2, CharAssociation[] charAssociationArray3) {
        this(glyphSequence.characters.duplicate(), GlyphSequence.concatGlyphs(nArray, nArray2, nArray3), GlyphSequence.concatAssociations(charAssociationArray, charAssociationArray2, charAssociationArray3), glyphSequence.predications);
    }

    public IntBuffer getCharacters() {
        return this.characters;
    }

    public int[] getCharacterArray(boolean bl) {
        if (bl) {
            return GlyphSequence.toArray(this.characters);
        }
        return this.characters.array();
    }

    public int getCharacterCount() {
        return this.characters.limit();
    }

    public int getGlyph(int n) throws IndexOutOfBoundsException {
        return this.glyphs.get(n);
    }

    public void setGlyph(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 > 65535) {
            n2 = 65535;
        }
        this.glyphs.put(n, n2);
    }

    public IntBuffer getGlyphs() {
        return this.glyphs;
    }

    public int[] getGlyphs(int n, int n2) {
        int n3 = this.getGlyphCount();
        if (n < 0) {
            n = 0;
        } else if (n > n3) {
            n = n3;
        }
        if (n2 < 0) {
            n2 = n3 - n;
        }
        int[] nArray = new int[n2];
        int n4 = n + n2;
        int n5 = 0;
        for (int i = n; i < n4; ++i) {
            if (n5 >= nArray.length) continue;
            nArray[n5++] = this.glyphs.get(i);
        }
        return nArray;
    }

    public int[] getGlyphArray(boolean bl) {
        if (bl) {
            return GlyphSequence.toArray(this.glyphs);
        }
        return this.glyphs.array();
    }

    public int getGlyphCount() {
        return this.glyphs.limit();
    }

    public CharAssociation getAssociation(int n) throws IndexOutOfBoundsException {
        return (CharAssociation)this.associations.get(n);
    }

    public List getAssociations() {
        return this.associations;
    }

    public CharAssociation[] getAssociations(int n, int n2) {
        int n3 = this.getGlyphCount();
        if (n < 0) {
            n = 0;
        } else if (n > n3) {
            n = n3;
        }
        if (n2 < 0) {
            n2 = n3 - n;
        }
        CharAssociation[] charAssociationArray = new CharAssociation[n2];
        int n4 = n + n2;
        int n5 = 0;
        for (int i = n; i < n4; ++i) {
            if (n5 >= charAssociationArray.length) continue;
            charAssociationArray[n5++] = (CharAssociation)this.associations.get(i);
        }
        return charAssociationArray;
    }

    public void setPredications(boolean bl) {
        this.predications = bl;
    }

    public boolean getPredications() {
        return this.predications;
    }

    public void setPredication(int n, String string, Object object) {
        if (this.predications) {
            CharAssociation[] charAssociationArray = this.getAssociations(n, 1);
            CharAssociation charAssociation = charAssociationArray[0];
            charAssociation.setPredication(string, object);
        }
    }

    public Object getPredication(int n, String string) {
        if (this.predications) {
            CharAssociation[] charAssociationArray = this.getAssociations(n, 1);
            CharAssociation charAssociation = charAssociationArray[0];
            return charAssociation.getPredication(string);
        }
        return null;
    }

    public int compareGlyphs(IntBuffer intBuffer) {
        int n = this.getGlyphCount();
        int n2 = intBuffer.limit();
        for (int i = 0; i < n2; ++i) {
            if (i < n) {
                int n3;
                int n4 = this.glyphs.get(i);
                if (n4 > (n3 = intBuffer.get(i))) {
                    return 1;
                }
                if (n4 >= n3) continue;
                return -1;
            }
            return -1;
        }
        return 0;
    }

    public Object clone() {
        try {
            GlyphSequence glyphSequence = (GlyphSequence)super.clone();
            glyphSequence.characters = GlyphSequence.copyBuffer(this.characters);
            glyphSequence.glyphs = GlyphSequence.copyBuffer(this.glyphs);
            glyphSequence.associations = GlyphSequence.copyAssociations(this.associations);
            return glyphSequence;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append("chars = [");
        stringBuffer.append(this.characters);
        stringBuffer.append("], glyphs = [");
        stringBuffer.append(this.glyphs);
        stringBuffer.append("], associations = [");
        stringBuffer.append(this.associations);
        stringBuffer.append("]");
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static boolean sameGlyphs(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static IntBuffer concatGlyphs(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = 0;
        if (nArray != null) {
            n += nArray.length;
        }
        if (nArray2 != null) {
            n += nArray2.length;
        }
        if (nArray3 != null) {
            n += nArray3.length;
        }
        IntBuffer intBuffer = IntBuffer.allocate(n);
        if (nArray != null) {
            intBuffer.put(nArray);
        }
        if (nArray2 != null) {
            intBuffer.put(nArray2);
        }
        if (nArray3 != null) {
            intBuffer.put(nArray3);
        }
        intBuffer.flip();
        return intBuffer;
    }

    public static List concatAssociations(CharAssociation[] charAssociationArray, CharAssociation[] charAssociationArray2, CharAssociation[] charAssociationArray3) {
        int n = 0;
        if (charAssociationArray != null) {
            n += charAssociationArray.length;
        }
        if (charAssociationArray2 != null) {
            n += charAssociationArray2.length;
        }
        if (charAssociationArray3 != null) {
            n += charAssociationArray3.length;
        }
        if (n > 0) {
            int n2;
            ArrayList<CharAssociation> arrayList = new ArrayList<CharAssociation>(n);
            if (charAssociationArray != null) {
                for (n2 = 0; n2 < charAssociationArray.length; ++n2) {
                    arrayList.add(charAssociationArray[n2]);
                }
            }
            if (charAssociationArray2 != null) {
                for (n2 = 0; n2 < charAssociationArray2.length; ++n2) {
                    arrayList.add(charAssociationArray2[n2]);
                }
            }
            if (charAssociationArray3 != null) {
                for (n2 = 0; n2 < charAssociationArray3.length; ++n2) {
                    arrayList.add(charAssociationArray3[n2]);
                }
            }
            return arrayList;
        }
        return null;
    }

    public static GlyphSequence join(GlyphSequence glyphSequence, GlyphSequence[] glyphSequenceArray) {
        assert (glyphSequenceArray != null);
        int n = 0;
        int n2 = 0;
        int n3 = glyphSequenceArray.length;
        for (int i = 0; i < n3; ++i) {
            GlyphSequence glyphSequence2 = glyphSequenceArray[i];
            IntBuffer intBuffer = glyphSequence2.getGlyphs();
            assert (intBuffer != null);
            int n4 = intBuffer.limit();
            List list = glyphSequence2.getAssociations();
            assert (list != null);
            int n5 = list.size();
            assert (n5 == n4);
            n += n4;
            n2 += n5;
        }
        IntBuffer intBuffer = IntBuffer.allocate(n);
        ArrayList arrayList = new ArrayList(n2);
        for (GlyphSequence glyphSequence3 : glyphSequenceArray) {
            intBuffer.put(glyphSequence3.getGlyphs());
            arrayList.addAll(glyphSequence3.getAssociations());
        }
        return new GlyphSequence(glyphSequence.getCharacters(), intBuffer, arrayList, glyphSequence.getPredications());
    }

    public static GlyphSequence reorder(GlyphSequence glyphSequence, int n, int n2, int n3) {
        if (n != n3) {
            int n4 = glyphSequence.getGlyphCount();
            int[] nArray = glyphSequence.getGlyphArray(false);
            int[] nArray2 = new int[n4];
            CharAssociation[] charAssociationArray = glyphSequence.getAssociations(0, n4);
            CharAssociation[] charAssociationArray2 = new CharAssociation[n4];
            if (n < n3) {
                int n5 = 0;
                int n6 = 0;
                int n7 = n;
                while (n6 < n7) {
                    nArray2[n5] = nArray[n6];
                    charAssociationArray2[n5] = charAssociationArray[n6];
                    ++n6;
                    ++n5;
                }
                n6 = n + n2;
                n7 = n3;
                while (n6 < n7) {
                    nArray2[n5] = nArray[n6];
                    charAssociationArray2[n5] = charAssociationArray[n6];
                    ++n6;
                    ++n5;
                }
                n6 = n;
                n7 = n + n2;
                while (n6 < n7) {
                    nArray2[n5] = nArray[n6];
                    charAssociationArray2[n5] = charAssociationArray[n6];
                    ++n6;
                    ++n5;
                }
                n6 = n3;
                n7 = n4;
                while (n6 < n7) {
                    nArray2[n5] = nArray[n6];
                    charAssociationArray2[n5] = charAssociationArray[n6];
                    ++n6;
                    ++n5;
                }
            } else {
                int n8 = 0;
                int n9 = 0;
                int n10 = n3;
                while (n9 < n10) {
                    nArray2[n8] = nArray[n9];
                    charAssociationArray2[n8] = charAssociationArray[n9];
                    ++n9;
                    ++n8;
                }
                n9 = n;
                n10 = n + n2;
                while (n9 < n10) {
                    nArray2[n8] = nArray[n9];
                    charAssociationArray2[n8] = charAssociationArray[n9];
                    ++n9;
                    ++n8;
                }
                n9 = n3;
                n10 = n;
                while (n9 < n10) {
                    nArray2[n8] = nArray[n9];
                    charAssociationArray2[n8] = charAssociationArray[n9];
                    ++n9;
                    ++n8;
                }
                n9 = n + n2;
                n10 = n4;
                while (n9 < n10) {
                    nArray2[n8] = nArray[n9];
                    charAssociationArray2[n8] = charAssociationArray[n9];
                    ++n9;
                    ++n8;
                }
            }
            return new GlyphSequence(glyphSequence, null, nArray2, null, null, charAssociationArray2, null);
        }
        return glyphSequence;
    }

    private static int[] toArray(IntBuffer intBuffer) {
        if (intBuffer != null) {
            int n = intBuffer.limit();
            int[] nArray = new int[n];
            intBuffer.get(nArray, 0, n);
            return nArray;
        }
        return new int[0];
    }

    private static List makeIdentityAssociations(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        ArrayList<CharAssociation> arrayList = new ArrayList<CharAssociation>(n4);
        int n5 = n4;
        for (int i = 0; i < n5; ++i) {
            int n6 = i > n3 ? n3 : i;
            arrayList.add(new CharAssociation(i, n6 == n3 ? 0 : 1));
        }
        return arrayList;
    }

    private static IntBuffer copyBuffer(IntBuffer intBuffer) {
        if (intBuffer != null) {
            int[] nArray = new int[intBuffer.capacity()];
            int n = intBuffer.position();
            int n2 = intBuffer.limit();
            System.arraycopy(intBuffer.array(), 0, nArray, 0, nArray.length);
            return IntBuffer.wrap(nArray, n, n2 - n);
        }
        return null;
    }

    private static List copyAssociations(List list) {
        if (list != null) {
            return new ArrayList(list);
        }
        return list;
    }

    public static class CharAssociation
    implements Cloneable {
        private final int offset;
        private final int count;
        private final int[] subIntervals;
        private Map<String, Object> predications;
        private static volatile Map<String, PredicationMerger> predicationMergers;
        private static final int[] sortIncrements16;
        private static final int[] sortIncrements03;

        public CharAssociation(int n, int n2, int[] nArray) {
            this.offset = n;
            this.count = n2;
            this.subIntervals = nArray != null && nArray.length > 2 ? nArray : null;
        }

        public CharAssociation(int n, int n2) {
            this(n, n2, null);
        }

        public CharAssociation(int[] nArray) {
            this(CharAssociation.getSubIntervalsStart(nArray), CharAssociation.getSubIntervalsLength(nArray), nArray);
        }

        public int getOffset() {
            return this.offset;
        }

        public int getCount() {
            return this.count;
        }

        public int getStart() {
            return this.getOffset();
        }

        public int getEnd() {
            return this.getOffset() + this.getCount();
        }

        public boolean isDisjoint() {
            return this.subIntervals != null;
        }

        public int[] getSubIntervals() {
            return this.subIntervals;
        }

        public int getSubIntervalCount() {
            return this.subIntervals != null ? this.subIntervals.length / 2 : 0;
        }

        public boolean contained(int n, int n2) {
            int n3 = n;
            int n4 = n + n2;
            if (!this.isDisjoint()) {
                int n5 = this.getStart();
                int n6 = this.getEnd();
                return n5 >= n3 && n6 <= n4;
            }
            int n7 = this.getSubIntervalCount();
            for (int i = 0; i < n7; ++i) {
                int n8 = this.subIntervals[2 * i + 0];
                int n9 = this.subIntervals[2 * i + 1];
                if (n8 < n3 || n9 > n4) continue;
                return true;
            }
            return false;
        }

        public void setPredication(String string, Object object) {
            if (this.predications == null) {
                this.predications = new HashMap<String, Object>();
            }
            if (this.predications != null) {
                this.predications.put(string, object);
            }
        }

        public Object getPredication(String string) {
            if (this.predications != null) {
                return this.predications.get(string);
            }
            return null;
        }

        public void mergePredication(String string, Object object) {
            if (this.predications == null) {
                this.predications = new HashMap<String, Object>();
            }
            if (this.predications != null) {
                if (this.predications.containsKey(string)) {
                    Object object2 = this.predications.get(string);
                    Object object3 = object;
                    this.predications.put(string, CharAssociation.mergePredicationValues(string, object2, object3));
                } else {
                    this.predications.put(string, object);
                }
            }
        }

        public static Object mergePredicationValues(String string, Object object, Object object2) {
            PredicationMerger predicationMerger = CharAssociation.getPredicationMerger(string);
            if (predicationMerger != null) {
                return predicationMerger.merge(string, object, object2);
            }
            if (object2 != null) {
                return object2;
            }
            return object;
        }

        public void mergePredications(CharAssociation charAssociation) {
            if (charAssociation.predications != null) {
                for (Map.Entry<String, Object> entry : charAssociation.predications.entrySet()) {
                    this.mergePredication(entry.getKey(), entry.getValue());
                }
            }
        }

        public Object clone() {
            try {
                CharAssociation charAssociation = (CharAssociation)super.clone();
                if (this.predications != null) {
                    charAssociation.predications = new HashMap<String, Object>(this.predications);
                }
                return charAssociation;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public static void setPredicationMerger(String string, PredicationMerger predicationMerger) {
            if (predicationMergers == null) {
                predicationMergers = new HashMap<String, PredicationMerger>();
            }
            if (predicationMergers != null) {
                predicationMergers.put(string, predicationMerger);
            }
        }

        public static PredicationMerger getPredicationMerger(String string) {
            if (predicationMergers != null) {
                return predicationMergers.get(string);
            }
            return null;
        }

        public static CharAssociation[] replicate(CharAssociation charAssociation, int n) {
            CharAssociation[] charAssociationArray = new CharAssociation[n];
            int n2 = charAssociationArray.length;
            for (int i = 0; i < n2; ++i) {
                charAssociationArray[i] = (CharAssociation)charAssociation.clone();
            }
            return charAssociationArray;
        }

        public static CharAssociation join(CharAssociation[] charAssociationArray) {
            CharAssociation charAssociation;
            int[] nArray = CharAssociation.extractIntervals(charAssociationArray);
            if (nArray == null || nArray.length == 0) {
                charAssociation = new CharAssociation(0, 0);
            } else if (nArray.length == 2) {
                int n = nArray[0];
                int n2 = nArray[1];
                charAssociation = new CharAssociation(n, n2 - n);
            } else {
                charAssociation = new CharAssociation(CharAssociation.mergeIntervals(nArray));
            }
            return CharAssociation.mergePredicates(charAssociation, charAssociationArray);
        }

        private static CharAssociation mergePredicates(CharAssociation charAssociation, CharAssociation[] charAssociationArray) {
            for (CharAssociation charAssociation2 : charAssociationArray) {
                charAssociation.mergePredications(charAssociation2);
            }
            return charAssociation;
        }

        private static int getSubIntervalsStart(int[] nArray) {
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            if (nArray != null) {
                int n3 = nArray.length;
                for (int i = 0; i < n3; i += 2) {
                    int n4 = nArray[i + 0];
                    int n5 = nArray[i + 1];
                    if (n4 < n) {
                        n = n4;
                    }
                    if (n5 <= n2) continue;
                    n2 = n5;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n > n2) {
                    n = n2;
                }
            }
            return n;
        }

        private static int getSubIntervalsLength(int[] nArray) {
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            if (nArray != null) {
                int n3 = nArray.length;
                for (int i = 0; i < n3; i += 2) {
                    int n4 = nArray[i + 0];
                    int n5 = nArray[i + 1];
                    if (n4 < n) {
                        n = n4;
                    }
                    if (n5 <= n2) continue;
                    n2 = n5;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n > n2) {
                    n = n2;
                }
            }
            return n2 - n;
        }

        private static int[] extractIntervals(CharAssociation[] charAssociationArray) {
            int n = 0;
            int n2 = charAssociationArray.length;
            for (int i = 0; i < n2; ++i) {
                CharAssociation charAssociation = charAssociationArray[i];
                if (charAssociation.isDisjoint()) {
                    n += charAssociation.getSubIntervalCount();
                    continue;
                }
                ++n;
            }
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int n3 = 0;
            for (int i = 0; i < charAssociationArray.length; ++i) {
                CharAssociation charAssociation = charAssociationArray[i];
                if (charAssociation.isDisjoint()) {
                    int[] nArray3 = charAssociation.getSubIntervals();
                    for (int j = 0; j < nArray3.length; j += 2) {
                        nArray[n3] = nArray3[j + 0];
                        nArray2[n3] = nArray3[j + 1];
                        ++n3;
                    }
                    continue;
                }
                nArray[n3] = charAssociation.getStart();
                nArray2[n3] = charAssociation.getEnd();
                ++n3;
            }
            return CharAssociation.sortIntervals(nArray, nArray2);
        }

        private static int[] sortIntervals(int[] nArray, int[] nArray2) {
            int n;
            assert (nArray != null);
            assert (nArray2 != null);
            assert (nArray.length == nArray2.length);
            int n2 = nArray.length;
            int[] nArray3 = n2 < 21 ? sortIncrements03 : sortIncrements16;
            for (int i = 0; i < nArray3.length; ++i) {
                int n3 = n2;
                for (int j = n = nArray3[i]; j < n3; ++j) {
                    int n4 = nArray[j];
                    int n5 = nArray2[j];
                    for (int k = j; k >= n; k -= n) {
                        int n6 = nArray[k - n];
                        int n7 = nArray2[k - n];
                        if (n6 > n4) {
                            nArray[k] = n6;
                            nArray2[k] = n7;
                            continue;
                        }
                        if (n6 != n4 || n7 <= n5) break;
                        nArray[k] = n6;
                        nArray2[k] = n7;
                    }
                    nArray[k] = n4;
                    nArray2[k] = n5;
                }
            }
            int[] nArray4 = new int[n2 * 2];
            for (n = 0; n < n2; ++n) {
                nArray4[n * 2 + 0] = nArray[n];
                nArray4[n * 2 + 1] = nArray2[n];
            }
            return nArray4;
        }

        private static int[] mergeIntervals(int[] nArray) {
            int n;
            int n2;
            int n3 = nArray.length;
            int n4 = n3;
            int n5 = 0;
            int n6 = -1;
            int n7 = -1;
            for (n2 = 0; n2 < n4; n2 += 2) {
                int n8 = nArray[n2 + 0];
                n = nArray[n2 + 1];
                if (n6 < 0 || n8 > n6) {
                    n7 = n8;
                    n6 = n;
                    ++n5;
                    continue;
                }
                if (n8 < n7 || n <= n6) continue;
                n6 = n;
            }
            int[] nArray2 = new int[n5 * 2];
            n4 = n3;
            n5 = 0;
            n6 = -1;
            n7 = -1;
            for (n2 = 0; n2 < n4; n2 += 2) {
                n = nArray[n2 + 0];
                int n9 = nArray[n2 + 1];
                int n10 = n5 * 2;
                if (n6 < 0 || n > n6) {
                    n7 = n;
                    n6 = n9;
                    nArray2[n10 + 0] = n7;
                    nArray2[n10 + 1] = n6;
                    ++n5;
                    continue;
                }
                if (n < n7) continue;
                if (n9 > n6) {
                    n6 = n9;
                }
                nArray2[n10 - 1] = n6;
            }
            return nArray2;
        }

        static {
            sortIncrements16 = new int[]{1391376, 463792, 198768, 86961, 33936, 13776, 4592, 1968, 861, 336, 112, 48, 21, 7, 3, 1};
            sortIncrements03 = new int[]{7, 3, 1};
        }

        static interface PredicationMerger {
            public Object merge(String var1, Object var2, Object var3);
        }
    }
}

