/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphCoverageMapping;
import org.apache.fop.complexscripts.fonts.GlyphMappingTable;

public final class GlyphCoverageTable
extends GlyphMappingTable
implements GlyphCoverageMapping {
    private static final Log log = LogFactory.getLog(GlyphCoverageTable.class);
    public static final int GLYPH_COVERAGE_TYPE_EMPTY = 0;
    public static final int GLYPH_COVERAGE_TYPE_MAPPED = 1;
    public static final int GLYPH_COVERAGE_TYPE_RANGE = 2;
    private GlyphCoverageMapping cm;

    private GlyphCoverageTable(GlyphCoverageMapping glyphCoverageMapping) {
        assert (glyphCoverageMapping != null);
        assert (glyphCoverageMapping instanceof GlyphMappingTable);
        this.cm = glyphCoverageMapping;
    }

    public int getType() {
        return ((GlyphMappingTable)((Object)this.cm)).getType();
    }

    public List getEntries() {
        return ((GlyphMappingTable)((Object)this.cm)).getEntries();
    }

    public int getCoverageSize() {
        return this.cm.getCoverageSize();
    }

    public int getCoverageIndex(int n) {
        return this.cm.getCoverageIndex(n);
    }

    public static GlyphCoverageTable createCoverageTable(List list) {
        GlyphMappingTable glyphMappingTable = list == null || list.size() == 0 ? new EmptyCoverageTable(list) : (GlyphCoverageTable.isMappedCoverage(list) ? new MappedCoverageTable(list) : (GlyphCoverageTable.isRangeCoverage(list) ? new RangeCoverageTable(list) : null));
        assert (glyphMappingTable != null) : "unknown coverage type";
        return new GlyphCoverageTable((GlyphCoverageMapping)((Object)glyphMappingTable));
    }

    private static boolean isMappedCoverage(List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        for (Object e : list) {
            if (e instanceof Integer) continue;
            return false;
        }
        return true;
    }

    private static boolean isRangeCoverage(List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        for (Object e : list) {
            if (e instanceof GlyphMappingTable.MappingRange) continue;
            return false;
        }
        return true;
    }

    private static class RangeCoverageTable
    extends GlyphMappingTable.RangeMappingTable
    implements GlyphCoverageMapping {
        public RangeCoverageTable(List list) {
            super(list);
        }

        public int getMappedIndex(int n, int n2, int n3) {
            return n3 + n - n2;
        }

        public int getCoverageSize() {
            return this.getMappingSize();
        }

        public int getCoverageIndex(int n) {
            return this.getMappedIndex(n);
        }
    }

    private static class MappedCoverageTable
    extends GlyphMappingTable.MappedMappingTable
    implements GlyphCoverageMapping {
        private int[] map;

        public MappedCoverageTable(List list) {
            this.populate(list);
        }

        public List getEntries() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (this.map != null) {
                int n = this.map.length;
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.map[i]);
                }
            }
            return arrayList;
        }

        public int getMappingSize() {
            return this.map != null ? this.map.length : 0;
        }

        public int getMappedIndex(int n) {
            int n2 = Arrays.binarySearch(this.map, n);
            if (n2 >= 0) {
                return n2;
            }
            return -1;
        }

        public int getCoverageSize() {
            return this.getMappingSize();
        }

        public int getCoverageIndex(int n) {
            return this.getMappedIndex(n);
        }

        private void populate(List list) {
            int n = 0;
            int n2 = 0;
            int n3 = list.size();
            int n4 = -1;
            int[] nArray = new int[n3];
            for (Object e : list) {
                if (e instanceof Integer) {
                    int n5 = (Integer)e;
                    if (n5 >= 0 && n5 < 65536) {
                        if (n5 > n4) {
                            nArray[n++] = n4 = n5;
                            continue;
                        }
                        log.info((Object)("ignoring out of order or duplicate glyph index: " + n5));
                        ++n2;
                        continue;
                    }
                    throw new AdvancedTypographicTableFormatException("illegal glyph index: " + n5);
                }
                throw new AdvancedTypographicTableFormatException("illegal coverage entry, must be Integer: " + e);
            }
            assert (n + n2 == n3);
            assert (this.map == null);
            this.map = nArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('{');
            int n = this.map.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(Integer.toString(this.map[i]));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class EmptyCoverageTable
    extends GlyphMappingTable.EmptyMappingTable
    implements GlyphCoverageMapping {
        public EmptyCoverageTable(List list) {
            super(list);
        }

        public int getCoverageSize() {
            return 0;
        }

        public int getCoverageIndex(int n) {
            return -1;
        }
    }
}

