/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.datatypes.SimplePercentBaseContext;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.RegionBody;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.traits.WritingModeTraitsGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page
extends AreaTreeObject
implements Serializable {
    private static final long serialVersionUID = 6272157047421543866L;
    private RegionViewport regionBefore = null;
    private RegionViewport regionStart = null;
    private RegionViewport regionBody = null;
    private RegionViewport regionEnd = null;
    private RegionViewport regionAfter = null;
    private Map<String, List<Resolvable>> unresolved = null;
    private boolean fakeNonEmpty = false;

    public Page() {
    }

    public Page(SimplePageMaster simplePageMaster) {
        FODimension fODimension = new FODimension(simplePageMaster.getPageWidth().getValue(), simplePageMaster.getPageHeight().getValue());
        CommonMarginBlock commonMarginBlock = simplePageMaster.getCommonMarginBlock();
        SimplePercentBaseContext simplePercentBaseContext = new SimplePercentBaseContext(null, 5, fODimension.ipd);
        SimplePercentBaseContext simplePercentBaseContext2 = new SimplePercentBaseContext(null, 5, fODimension.bpd);
        Rectangle rectangle = new Rectangle(commonMarginBlock.marginLeft.getValue(simplePercentBaseContext), commonMarginBlock.marginTop.getValue(simplePercentBaseContext2), fODimension.ipd - commonMarginBlock.marginLeft.getValue(simplePercentBaseContext) - commonMarginBlock.marginRight.getValue(simplePercentBaseContext), fODimension.bpd - commonMarginBlock.marginTop.getValue(simplePercentBaseContext2) - commonMarginBlock.marginBottom.getValue(simplePercentBaseContext2));
        FODimension fODimension2 = new FODimension(0, 0);
        CTM cTM = CTM.getCTMandRelDims(simplePageMaster.getReferenceOrientation(), simplePageMaster.getWritingMode(), rectangle, fODimension2);
        for (Region region : simplePageMaster.getRegions().values()) {
            RegionViewport regionViewport = Page.makeRegionViewport(region, fODimension2, cTM);
            RegionReference regionReference = region.getNameId() == 58 ? new BodyRegion((RegionBody)region, regionViewport) : new RegionReference(region, regionViewport);
            TraitSetter.addBorders(regionReference, region.getCommonBorderPaddingBackground(), false, false, false, false, null);
            TraitSetter.addPadding(regionReference, region.getCommonBorderPaddingBackground(), false, false, false, false, null);
            Page.setRegionReferencePosition(regionReference, region, regionViewport.getViewArea());
            regionViewport.setRegionReference(regionReference);
            this.setRegionViewport(region.getNameId(), regionViewport);
        }
    }

    public void fakeNonEmpty() {
        this.fakeNonEmpty = true;
    }

    private static RegionViewport makeRegionViewport(Region region, FODimension fODimension, CTM cTM) {
        Rectangle rectangle = region.getViewportRectangle(fODimension);
        Rectangle2D rectangle2D = cTM.transform(rectangle);
        RegionViewport regionViewport = new RegionViewport(rectangle2D);
        regionViewport.setBPD((int)((RectangularShape)rectangle).getHeight());
        regionViewport.setIPD((int)((RectangularShape)rectangle).getWidth());
        TraitSetter.addBackground(regionViewport, region.getCommonBorderPaddingBackground(), null);
        regionViewport.setClip(region.getOverflow() == 57 || region.getOverflow() == 42);
        return regionViewport;
    }

    private static void setRegionReferencePosition(RegionReference regionReference, Region region, Rectangle2D rectangle2D) {
        FODimension fODimension = new FODimension(0, 0);
        regionReference.setCTM(CTM.getCTMandRelDims(region.getReferenceOrientation(), region.getWritingMode(), rectangle2D, fODimension));
        regionReference.setIPD(fODimension.ipd - regionReference.getBorderAndPaddingWidthStart() - regionReference.getBorderAndPaddingWidthEnd());
        regionReference.setBPD(fODimension.bpd - regionReference.getBorderAndPaddingWidthBefore() - regionReference.getBorderAndPaddingWidthAfter());
    }

    public void setRegionViewport(int n, RegionViewport regionViewport) {
        if (n == 57) {
            this.regionBefore = regionViewport;
        } else if (n == 61) {
            this.regionStart = regionViewport;
        } else if (n == 58) {
            this.regionBody = regionViewport;
        } else if (n == 59) {
            this.regionEnd = regionViewport;
        } else if (n == 56) {
            this.regionAfter = regionViewport;
        }
    }

    public RegionViewport getRegionViewport(int n) {
        switch (n) {
            case 57: {
                return this.regionBefore;
            }
            case 61: {
                return this.regionStart;
            }
            case 58: {
                return this.regionBody;
            }
            case 59: {
                return this.regionEnd;
            }
            case 56: {
                return this.regionAfter;
            }
        }
        throw new IllegalArgumentException("No such area class with ID = " + n);
    }

    public boolean isEmpty() {
        if (this.fakeNonEmpty) {
            return false;
        }
        if (this.regionBody == null) {
            return true;
        }
        BodyRegion bodyRegion = (BodyRegion)this.regionBody.getRegionReference();
        return bodyRegion.isEmpty();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Page page = (Page)super.clone();
        if (this.regionBefore != null) {
            page.regionBefore = (RegionViewport)this.regionBefore.clone();
        }
        if (this.regionStart != null) {
            page.regionStart = (RegionViewport)this.regionStart.clone();
        }
        if (this.regionBody != null) {
            page.regionBody = (RegionViewport)this.regionBody.clone();
        }
        if (this.regionEnd != null) {
            page.regionEnd = (RegionViewport)this.regionEnd.clone();
        }
        if (this.regionAfter != null) {
            page.regionAfter = (RegionViewport)this.regionAfter.clone();
        }
        return page;
    }

    public void setUnresolvedReferences(Map<String, List<Resolvable>> map) {
        this.unresolved = map;
    }

    public Map<String, List<Resolvable>> getUnresolvedReferences() {
        return this.unresolved;
    }

    public void setWritingModeTraits(WritingModeTraitsGetter writingModeTraitsGetter) {
        if (this.regionBefore != null) {
            this.regionBefore.setWritingModeTraits(writingModeTraitsGetter);
        }
        if (this.regionStart != null) {
            this.regionStart.setWritingModeTraits(writingModeTraitsGetter);
        }
        if (this.regionBody != null) {
            this.regionBody.setWritingModeTraits(writingModeTraitsGetter);
        }
        if (this.regionEnd != null) {
            this.regionEnd.setWritingModeTraits(writingModeTraitsGetter);
        }
        if (this.regionAfter != null) {
            this.regionAfter.setWritingModeTraits(writingModeTraitsGetter);
        }
    }
}

