/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDTracker {
    private static final Log LOG = LogFactory.getLog(IDTracker.class);
    private Map<String, List<PageViewport>> idLocations = new HashMap<String, List<PageViewport>>();
    private Map<String, Set<Resolvable>> unresolvedIDRefs = new HashMap<String, Set<Resolvable>>();
    private Set<String> unfinishedIDs = new HashSet<String>();
    private Set<String> alreadyResolvedIDs = new HashSet<String>();

    public void associateIDWithPageViewport(String string, PageViewport pageViewport) {
        List<PageViewport> list;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("associateIDWithPageViewport(" + string + ", " + pageViewport + ")"));
        }
        if ((list = this.idLocations.get(string)) == null) {
            list = new ArrayList<PageViewport>();
            this.idLocations.put(string, list);
            list.add(pageViewport);
            pageViewport.setFirstWithID(string);
            if (!this.unfinishedIDs.contains(string)) {
                this.tryIDResolution(string, list);
            }
        } else if (!list.contains(pageViewport)) {
            list.add(pageViewport);
        }
    }

    public void signalPendingID(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("signalPendingID(" + string + ")"));
        }
        this.unfinishedIDs.add(string);
    }

    public void signalIDProcessed(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("signalIDProcessed(" + string + ")"));
        }
        this.alreadyResolvedIDs.add(string);
        if (!this.unfinishedIDs.contains(string)) {
            return;
        }
        this.unfinishedIDs.remove(string);
        List<PageViewport> list = this.idLocations.get(string);
        Set<Resolvable> set = this.unresolvedIDRefs.get(string);
        if (set != null) {
            for (Resolvable resolvable : set) {
                resolvable.resolveIDRef(string, list);
            }
            this.unresolvedIDRefs.remove(string);
        }
    }

    public boolean alreadyResolvedID(String string) {
        return this.alreadyResolvedIDs.contains(string);
    }

    private void tryIDResolution(String string, List<PageViewport> list) {
        Set<Resolvable> set = this.unresolvedIDRefs.get(string);
        if (set != null) {
            for (Resolvable resolvable : set) {
                if (!this.unfinishedIDs.contains(string)) {
                    resolvable.resolveIDRef(string, list);
                    continue;
                }
                return;
            }
            this.alreadyResolvedIDs.add(string);
            this.unresolvedIDRefs.remove(string);
        }
    }

    public void tryIDResolution(PageViewport pageViewport) {
        String[] stringArray = pageViewport.getIDRefs();
        if (stringArray != null) {
            for (String string : stringArray) {
                List<PageViewport> list = this.idLocations.get(string);
                if (list == null || list.isEmpty()) continue;
                this.tryIDResolution(string, list);
            }
        }
    }

    public List<PageViewport> getPageViewportsContainingID(String string) {
        List<PageViewport> list;
        if (this.idLocations != null && !this.idLocations.isEmpty() && (list = this.idLocations.get(string)) != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public PageViewport getFirstPageViewportContaining(String string) {
        List<PageViewport> list = this.getPageViewportsContainingID(string);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public PageViewport getLastPageViewportContaining(String string) {
        List<PageViewport> list = this.getPageViewportsContainingID(string);
        if (list != null && !list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public void addUnresolvedIDRef(String string, Resolvable resolvable) {
        Set<Resolvable> set = this.unresolvedIDRefs.get(string);
        if (set == null) {
            set = new HashSet<Resolvable>();
            this.unresolvedIDRefs.put(string, set);
        }
        set.add(resolvable);
    }
}

