/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import org.apache.fop.area.BlockParent;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.Trait;

public class Block
extends BlockParent {
    private static final long serialVersionUID = 6843727817993665788L;
    public static final int STACK = 0;
    public static final int RELATIVE = 1;
    public static final int ABSOLUTE = 2;
    public static final int FIXED = 3;
    private int positioning = 0;
    protected transient boolean allowBPDUpdate = true;

    public void addBlock(Block block) {
        this.addBlock(block, true);
    }

    public void addBlock(Block block, boolean bl) {
        if (bl && this.allowBPDUpdate && block.isStacked()) {
            this.bpd += block.getAllocBPD();
        }
        this.addChildArea(block);
    }

    public void addLineArea(LineArea lineArea) {
        this.bpd += lineArea.getAllocBPD();
        this.addChildArea(lineArea);
    }

    public void setPositioning(int n) {
        this.positioning = n;
    }

    public int getPositioning() {
        return this.positioning;
    }

    public boolean isStacked() {
        return this.getPositioning() == 0 || this.getPositioning() == 1;
    }

    public int getStartIndent() {
        Integer n = (Integer)this.getTrait(Trait.START_INDENT);
        return n != null ? n : 0;
    }

    public int getEndIndent() {
        Integer n = (Integer)this.getTrait(Trait.END_INDENT);
        return n != null ? n : 0;
    }
}

