/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.util;

import java.awt.geom.Point2D;

public final class CubicBezierApproximator {
    private CubicBezierApproximator() {
    }

    public static double[][] fixedMidPointApproximation(double[] dArray) {
        if (dArray.length < 8) {
            throw new IllegalArgumentException("Must have at least 8 coordinates");
        }
        Point2D.Double double_ = new Point2D.Double(dArray[0], dArray[1]);
        Point2D.Double double_2 = new Point2D.Double(dArray[2], dArray[3]);
        Point2D.Double double_3 = new Point2D.Double(dArray[4], dArray[5]);
        Point2D.Double double_4 = new Point2D.Double(dArray[6], dArray[7]);
        Point2D point2D = CubicBezierApproximator.getPointOnSegment(double_, double_2, 0.75);
        Point2D point2D2 = CubicBezierApproximator.getPointOnSegment(double_4, double_3, 0.75);
        double d = (((Point2D)double_4).getX() - ((Point2D)double_).getX()) / 16.0;
        double d2 = (((Point2D)double_4).getY() - ((Point2D)double_).getY()) / 16.0;
        Point2D point2D3 = CubicBezierApproximator.getPointOnSegment(double_, double_2, 0.375);
        Point2D point2D4 = CubicBezierApproximator.getPointOnSegment(point2D, point2D2, 0.375);
        point2D4 = CubicBezierApproximator.movePoint(point2D4, -d, -d2);
        Point2D point2D5 = CubicBezierApproximator.getPointOnSegment(point2D2, point2D, 0.375);
        point2D5 = CubicBezierApproximator.movePoint(point2D5, d, d2);
        Point2D point2D6 = CubicBezierApproximator.getPointOnSegment(double_4, double_3, 0.375);
        Point2D point2D7 = CubicBezierApproximator.getMidPoint(point2D3, point2D4);
        Point2D point2D8 = CubicBezierApproximator.getMidPoint(point2D, point2D2);
        Point2D point2D9 = CubicBezierApproximator.getMidPoint(point2D5, point2D6);
        return new double[][]{{point2D3.getX(), point2D3.getY(), point2D7.getX(), point2D7.getY()}, {point2D4.getX(), point2D4.getY(), point2D8.getX(), point2D8.getY()}, {point2D5.getX(), point2D5.getY(), point2D9.getX(), point2D9.getY()}, {point2D6.getX(), point2D6.getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY()}};
    }

    private static Point2D.Double movePoint(Point2D point2D, double d, double d2) {
        return new Point2D.Double(point2D.getX() + d, point2D.getY() + d2);
    }

    private static Point2D getMidPoint(Point2D point2D, Point2D point2D2) {
        return CubicBezierApproximator.getPointOnSegment(point2D, point2D2, 0.5);
    }

    private static Point2D getPointOnSegment(Point2D point2D, Point2D point2D2, double d) {
        double d2 = point2D.getX() + (point2D2.getX() - point2D.getX()) * d;
        double d3 = point2D.getY() + (point2D2.getY() - point2D.getY()) * d;
        return new Point2D.Double(d2, d3);
    }
}

