/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.Completable;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.StructuredData;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.goca.GraphicsAreaBegin;
import org.apache.fop.afp.goca.GraphicsAreaEnd;
import org.apache.fop.afp.goca.GraphicsBox;
import org.apache.fop.afp.goca.GraphicsChainedSegment;
import org.apache.fop.afp.goca.GraphicsCharacterString;
import org.apache.fop.afp.goca.GraphicsData;
import org.apache.fop.afp.goca.GraphicsEndProlog;
import org.apache.fop.afp.goca.GraphicsFillet;
import org.apache.fop.afp.goca.GraphicsFullArc;
import org.apache.fop.afp.goca.GraphicsImage;
import org.apache.fop.afp.goca.GraphicsLine;
import org.apache.fop.afp.goca.GraphicsSetArcParameters;
import org.apache.fop.afp.goca.GraphicsSetCharacterSet;
import org.apache.fop.afp.goca.GraphicsSetCurrentPosition;
import org.apache.fop.afp.goca.GraphicsSetFractionalLineWidth;
import org.apache.fop.afp.goca.GraphicsSetLineType;
import org.apache.fop.afp.goca.GraphicsSetLineWidth;
import org.apache.fop.afp.goca.GraphicsSetPatternSymbol;
import org.apache.fop.afp.goca.GraphicsSetProcessColor;
import org.apache.fop.afp.modca.AbstractDataObject;
import org.apache.fop.afp.modca.GraphicsDataDescriptor;
import org.apache.xmlgraphics.java2d.color.ColorConverter;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public class GraphicsObject
extends AbstractDataObject {
    private GraphicsData currentData = null;
    protected List<GraphicsData> objects = new ArrayList<GraphicsData>();
    private final GraphicsState graphicsState = new GraphicsState();
    private ColorConverter colorConverter = null;

    public GraphicsObject(Factory factory, String string) {
        super(factory, string);
    }

    public void setViewport(AFPDataObjectInfo aFPDataObjectInfo) {
        super.setViewport(aFPDataObjectInfo);
        AFPObjectAreaInfo aFPObjectAreaInfo = aFPDataObjectInfo.getObjectAreaInfo();
        int n = aFPObjectAreaInfo.getWidth();
        int n2 = aFPObjectAreaInfo.getHeight();
        int n3 = aFPObjectAreaInfo.getWidthRes();
        int n4 = aFPObjectAreaInfo.getHeightRes();
        GraphicsDataDescriptor graphicsDataDescriptor = this.factory.createGraphicsDataDescriptor(0, n, 0, n2, n3, n4);
        this.getObjectEnvironmentGroup().setDataDescriptor(graphicsDataDescriptor);
    }

    public void addObject(StructuredData structuredData) {
        if (this.currentData == null) {
            this.newData();
        } else if (this.currentData.getDataLength() + structuredData.getDataLength() >= 8208) {
            GraphicsChainedSegment graphicsChainedSegment = (GraphicsChainedSegment)this.currentData.removeCurrentSegment();
            graphicsChainedSegment.setName(this.newData().createSegmentName());
            this.currentData.addSegment(graphicsChainedSegment);
        }
        this.currentData.addObject(structuredData);
    }

    private GraphicsData getData() {
        if (this.currentData == null) {
            return this.newData();
        }
        return this.currentData;
    }

    private GraphicsData newData() {
        if (this.currentData != null) {
            this.currentData.setComplete(true);
        }
        this.currentData = this.factory.createGraphicsData();
        this.objects.add(this.currentData);
        return this.currentData;
    }

    public void setColor(Color color) {
        if (!ColorUtil.isSameColor((Color)color, (Color)this.graphicsState.color)) {
            this.addObject(new GraphicsSetProcessColor(this.colorConverter.convert(color)));
            this.graphicsState.color = color;
        }
    }

    public void setColorConverter(ColorConverter colorConverter) {
        this.colorConverter = colorConverter;
    }

    public void setCurrentPosition(int[] nArray) {
        this.addObject(new GraphicsSetCurrentPosition(nArray));
    }

    public void setLineWidth(int n) {
        if ((float)n != this.graphicsState.lineWidth) {
            this.addObject(new GraphicsSetLineWidth(n));
            this.graphicsState.lineWidth = n;
        }
    }

    public void setLineWidth(float f) {
        float f2 = Float.intBitsToFloat(0x800000);
        if (Math.abs(this.graphicsState.lineWidth - f) > f2) {
            this.addObject(new GraphicsSetFractionalLineWidth(f));
            this.graphicsState.lineWidth = f;
        }
    }

    public void setLineType(byte by) {
        if (by != this.graphicsState.lineType) {
            this.addObject(new GraphicsSetLineType(by));
            this.graphicsState.lineType = by;
        }
    }

    public void setFill(boolean bl) {
        this.setPatternSymbol(bl ? (byte)16 : 15);
    }

    public void setPatternSymbol(byte by) {
        if (by != this.graphicsState.patternSymbol) {
            this.addObject(new GraphicsSetPatternSymbol(by));
            this.graphicsState.patternSymbol = by;
        }
    }

    public void setCharacterSet(int n) {
        if (n != this.graphicsState.characterSet) {
            this.graphicsState.characterSet = n;
        }
        this.addObject(new GraphicsSetCharacterSet(n));
    }

    public void addLine(int[] nArray) {
        this.addLine(nArray, false);
    }

    public void addLine(int[] nArray, boolean bl) {
        this.addObject(new GraphicsLine(nArray, bl));
    }

    public void addBox(int[] nArray) {
        this.addObject(new GraphicsBox(nArray));
    }

    public void addFillet(int[] nArray) {
        this.addFillet(nArray, false);
    }

    public void addFillet(int[] nArray, boolean bl) {
        this.addObject(new GraphicsFillet(nArray, bl));
    }

    public void setArcParams(int n, int n2, int n3, int n4) {
        this.addObject(new GraphicsSetArcParameters(n, n2, n3, n4));
    }

    public void addFullArc(int n, int n2, int n3, int n4) {
        this.addObject(new GraphicsFullArc(n, n2, n3, n4));
    }

    public void addImage(int n, int n2, int n3, int n4, byte[] byArray) {
        this.addObject(new GraphicsImage(n, n2, n3, n4, byArray));
    }

    public void addString(String string, int n, int n2, CharacterSet characterSet) {
        this.addObject(new GraphicsCharacterString(string, n, n2, characterSet));
    }

    public void beginArea() {
        this.addObject(new GraphicsAreaBegin());
    }

    public void endArea() {
        this.addObject(new GraphicsAreaEnd());
    }

    public void endProlog() {
        this.addObject(new GraphicsEndProlog());
    }

    public String toString() {
        return "GraphicsObject: " + this.getName();
    }

    public void newSegment() {
        this.getData().newSegment();
        this.graphicsState.lineWidth = 0.0f;
    }

    public void setComplete(boolean bl) {
        for (Completable completable : this.objects) {
            completable.setComplete(true);
        }
        super.setComplete(bl);
    }

    protected void writeStart(OutputStream outputStream) throws IOException {
        super.writeStart(outputStream);
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-88, (byte)-69);
        outputStream.write(byArray);
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        super.writeContent(outputStream);
        this.writeObjects(this.objects, outputStream);
    }

    protected void writeEnd(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[17];
        this.copySF(byArray, (byte)-87, (byte)-69);
        outputStream.write(byArray);
    }

    private static final class GraphicsState {
        private Color color;
        private byte lineType;
        private float lineWidth;
        private byte patternSymbol;
        private int characterSet;

        private GraphicsState() {
        }
    }
}

