/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.afp.AFPLineDataInfo;
import org.apache.fop.afp.Completable;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.afp.modca.ActiveEnvironmentGroup;
import org.apache.fop.afp.modca.IncludePageSegment;
import org.apache.fop.afp.modca.NoOperation;
import org.apache.fop.afp.modca.PresentationTextObject;
import org.apache.fop.afp.modca.TagLogicalElement;
import org.apache.fop.afp.ptoca.PtocaProducer;

public abstract class AbstractPageObject
extends AbstractNamedAFPObject
implements Completable {
    protected ActiveEnvironmentGroup activeEnvironmentGroup = null;
    private PresentationTextObject currentPresentationTextObject = null;
    protected List objects = new ArrayList();
    private int width;
    private int height;
    protected int rotation = 0;
    protected boolean complete = false;
    private int widthRes;
    private int heightRes;
    protected final Factory factory;

    public AbstractPageObject(Factory factory) {
        this.factory = factory;
    }

    public AbstractPageObject(Factory factory, String string) {
        super(string);
        this.factory = factory;
    }

    public AbstractPageObject(Factory factory, String string, int n, int n2, int n3, int n4, int n5) {
        super(string);
        this.factory = factory;
        this.width = n;
        this.height = n2;
        this.rotation = n3;
        this.widthRes = n4;
        this.heightRes = n5;
    }

    public void createFont(int n, AFPFont aFPFont, int n2) {
        this.getActiveEnvironmentGroup().createFont(n, aFPFont, n2, 0);
    }

    public void createLine(AFPLineDataInfo aFPLineDataInfo) {
        this.getPresentationTextObject().createLineData(aFPLineDataInfo);
    }

    public void createText(PtocaProducer ptocaProducer) throws UnsupportedEncodingException {
        this.getPresentationTextObject().createControlSequences(ptocaProducer);
    }

    public void endPage() {
        if (this.currentPresentationTextObject != null) {
            this.currentPresentationTextObject.endControlSequence();
        }
        this.setComplete(true);
    }

    protected void endPresentationObject() {
        if (this.currentPresentationTextObject != null) {
            this.currentPresentationTextObject.endControlSequence();
            this.currentPresentationTextObject = null;
        }
    }

    public PresentationTextObject getPresentationTextObject() {
        if (this.currentPresentationTextObject == null) {
            PresentationTextObject presentationTextObject = this.factory.createPresentationTextObject();
            this.addObject(presentationTextObject);
            this.currentPresentationTextObject = presentationTextObject;
        }
        return this.currentPresentationTextObject;
    }

    protected List getTagLogicalElements() {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        return this.objects;
    }

    public void createTagLogicalElement(String string, String string2, int n) {
        TagLogicalElement tagLogicalElement = new TagLogicalElement(string, string2, n);
        List list = this.getTagLogicalElements();
        list.add(tagLogicalElement);
    }

    public void createNoOperation(String string) {
        this.addObject(new NoOperation(string));
    }

    public void createIncludePageSegment(String string, int n, int n2, boolean bl) {
        IncludePageSegment includePageSegment = this.factory.createIncludePageSegment(string, n, n2);
        this.addObject(includePageSegment);
        if (bl) {
            this.getActiveEnvironmentGroup().addMapPageSegment(string);
        }
    }

    public ActiveEnvironmentGroup getActiveEnvironmentGroup() {
        if (this.activeEnvironmentGroup == null) {
            this.activeEnvironmentGroup = this.factory.createActiveEnvironmentGroup(this.width, this.height, this.widthRes, this.heightRes);
            if (this.rotation != 0) {
                switch (this.rotation) {
                    case 90: {
                        this.activeEnvironmentGroup.setObjectAreaPosition(this.width, 0, this.rotation);
                        break;
                    }
                    case 180: {
                        this.activeEnvironmentGroup.setObjectAreaPosition(this.width, this.height, this.rotation);
                        break;
                    }
                    case 270: {
                        this.activeEnvironmentGroup.setObjectAreaPosition(0, this.height, this.rotation);
                        break;
                    }
                }
            }
        }
        return this.activeEnvironmentGroup;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRotation() {
        return this.rotation;
    }

    protected void writeContent(OutputStream outputStream) throws IOException {
        super.writeContent(outputStream);
        this.writeObjects(this.objects, outputStream);
    }

    public void addObject(Object object) {
        this.objects.add(object);
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

