/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.CharacterSetOrientation;
import org.apache.fop.afp.fonts.CharacterSetType;
import org.apache.fop.afp.fonts.FopCharacterSet;
import org.apache.fop.afp.util.ResourceAccessor;
import org.apache.fop.afp.util.StructuredFieldReader;
import org.apache.fop.fonts.Typeface;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharacterSetBuilder {
    protected static final Log LOG = LogFactory.getLog(CharacterSetBuilder.class);
    private static final CharacterSetOrientation[] EMPTY_CSO_ARRAY = new CharacterSetOrientation[0];
    private static final byte[] CODEPAGE_SF = new byte[]{-45, -88, -121};
    private static final byte[] CHARACTER_TABLE_SF = new byte[]{-45, -116, -121};
    private static final byte[] FONT_DESCRIPTOR_SF = new byte[]{-45, -90, -119};
    private static final byte[] FONT_CONTROL_SF = new byte[]{-45, -89, -119};
    private static final byte[] FONT_ORIENTATION_SF = new byte[]{-45, -82, -119};
    private static final byte[] FONT_POSITION_SF = new byte[]{-45, -84, -119};
    private static final byte[] FONT_INDEX_SF = new byte[]{-45, -116, -119};
    private final Map<String, Map<String, String>> codePagesCache = Collections.synchronizedMap(new WeakHashMap());
    private final SoftMapCache characterSetsCache = new SoftMapCache(true);

    private CharacterSetBuilder() {
    }

    public static CharacterSetBuilder getSingleByteInstance() {
        return SingleByteLoader.getInstance();
    }

    public static CharacterSetBuilder getDoubleByteInstance() {
        return DoubleByteLoader.getInstance();
    }

    protected InputStream openInputStream(ResourceAccessor resourceAccessor, String string, AFPEventProducer aFPEventProducer) throws IOException {
        URI uRI;
        try {
            uRI = new URI(string.trim());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new FileNotFoundException("Invalid filename: " + string + " (" + uRISyntaxException.getMessage() + ")");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening " + uRI));
        }
        InputStream inputStream = resourceAccessor.createInputStream(uRI);
        return inputStream;
    }

    protected void closeInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage());
        }
    }

    public CharacterSet buildSBCS(String string, String string2, String string3, ResourceAccessor resourceAccessor, AFPEventProducer aFPEventProducer) throws IOException {
        return this.processFont(string, string2, string3, CharacterSetType.SINGLE_BYTE, resourceAccessor, aFPEventProducer);
    }

    public CharacterSet buildDBCS(String string, String string2, String string3, CharacterSetType characterSetType, ResourceAccessor resourceAccessor, AFPEventProducer aFPEventProducer) throws IOException {
        return this.processFont(string, string2, string3, characterSetType, resourceAccessor, aFPEventProducer);
    }

    public CharacterSet build(String string, String string2, String string3, Typeface typeface, AFPEventProducer aFPEventProducer) throws IOException {
        return new FopCharacterSet(string2, string3, string, typeface, aFPEventProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharacterSet processFont(String string, String string2, String string3, CharacterSetType characterSetType, ResourceAccessor resourceAccessor, AFPEventProducer aFPEventProducer) throws IOException {
        String string4 = string + "_" + string3 + "_" + string2;
        CharacterSet characterSet = (CharacterSet)this.characterSetsCache.get((Object)string4);
        if (characterSet != null) {
            return characterSet;
        }
        characterSet = new CharacterSet(string2, string3, characterSetType, string, resourceAccessor, aFPEventProducer);
        InputStream inputStream = null;
        try {
            Map<String, String> map;
            Object object = this.codePagesCache;
            synchronized (object) {
                map = this.codePagesCache.get(string2);
                if (map == null) {
                    map = this.loadCodePage(string2, string3, resourceAccessor, aFPEventProducer);
                    this.codePagesCache.put(string2, map);
                }
            }
            inputStream = this.openInputStream(resourceAccessor, string, aFPEventProducer);
            object = new StructuredFieldReader(inputStream);
            FontDescriptor fontDescriptor = CharacterSetBuilder.processFontDescriptor((StructuredFieldReader)object);
            characterSet.setNominalVerticalSize(fontDescriptor.getNominalFontSizeInMillipoints());
            FontControl fontControl = this.processFontControl((StructuredFieldReader)object);
            if (fontControl != null) {
                int n;
                double d;
                CharacterSetOrientation[] characterSetOrientationArray = this.processFontOrientation((StructuredFieldReader)object);
                if (fontControl.isRelative()) {
                    d = 1.0;
                } else {
                    n = fontControl.getDpi();
                    d = 7.2E7 / (double)fontDescriptor.getNominalFontSizeInMillipoints() / (double)n;
                }
                this.processFontPosition((StructuredFieldReader)object, characterSetOrientationArray, d);
                for (n = 0; n < characterSetOrientationArray.length; ++n) {
                    this.processFontIndex((StructuredFieldReader)object, characterSetOrientationArray[n], map, d);
                    characterSet.addCharacterSetOrientation(characterSetOrientationArray[n]);
                }
            } else {
                throw new IOException("Missing D3AE89 Font Control structured field.");
            }
            this.closeInputStream(inputStream);
        }
        catch (Throwable throwable) {
            this.closeInputStream(inputStream);
            throw throwable;
        }
        this.characterSetsCache.put((Object)string4, (Object)characterSet);
        return characterSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> loadCodePage(String string, String string2, ResourceAccessor resourceAccessor, AFPEventProducer aFPEventProducer) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        InputStream inputStream = null;
        try {
            inputStream = this.openInputStream(resourceAccessor, string.trim(), aFPEventProducer);
            StructuredFieldReader structuredFieldReader = new StructuredFieldReader(inputStream);
            byte[] byArray = structuredFieldReader.getNext(CHARACTER_TABLE_SF);
            int n = 0;
            byte[] byArray2 = new byte[8];
            byte[] byArray3 = new byte[1];
            for (int i = 3; i < byArray.length; ++i) {
                if (n < 8) {
                    byArray2[n] = byArray[i];
                    ++n;
                    continue;
                }
                if (n == 9) {
                    n = 0;
                    byArray3[0] = byArray[i];
                    String string3 = new String(byArray2, "Cp1146");
                    String string4 = new String(byArray3, string2);
                    hashMap.put(string3, string4);
                    continue;
                }
                ++n;
            }
            this.closeInputStream(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                aFPEventProducer.codePageNotFound(this, fileNotFoundException);
                this.closeInputStream(inputStream);
            }
            catch (Throwable throwable) {
                this.closeInputStream(inputStream);
                throw throwable;
            }
        }
        return hashMap;
    }

    protected static FontDescriptor processFontDescriptor(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] byArray = structuredFieldReader.getNext(FONT_DESCRIPTOR_SF);
        return new FontDescriptor(byArray);
    }

    protected FontControl processFontControl(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] byArray = structuredFieldReader.getNext(FONT_CONTROL_SF);
        FontControl fontControl = null;
        if (byArray != null) {
            int n;
            fontControl = new FontControl();
            if (byArray[7] == 2) {
                fontControl.setRelative(true);
            }
            if ((n = CharacterSetBuilder.getUBIN(byArray, 9)) == 1000) {
                fontControl.setUnitsPerEm(1000);
            } else {
                fontControl.setDpi(n / 10);
            }
        }
        return fontControl;
    }

    protected CharacterSetOrientation[] processFontOrientation(StructuredFieldReader structuredFieldReader) throws IOException {
        byte[] byArray = structuredFieldReader.getNext(FONT_ORIENTATION_SF);
        int n = 0;
        byte[] byArray2 = new byte[26];
        ArrayList<CharacterSetOrientation> arrayList = new ArrayList<CharacterSetOrientation>();
        for (int i = 3; i < byArray.length; ++i) {
            byArray2[n] = byArray[i];
            if (++n != 26) continue;
            n = 0;
            int n2 = CharacterSetBuilder.determineOrientation(byArray2[2]);
            int n3 = ((byArray2[8] & 0xFF) << 8) + (byArray2[9] & 0xFF);
            int n4 = ((byArray2[14] & 0xFF) << 8) + (byArray2[15] & 0xFF);
            CharacterSetOrientation characterSetOrientation = new CharacterSetOrientation(n2);
            characterSetOrientation.setSpaceIncrement(n3);
            characterSetOrientation.setEmSpaceIncrement(n4);
            arrayList.add(characterSetOrientation);
        }
        return arrayList.toArray(EMPTY_CSO_ARRAY);
    }

    protected void processFontPosition(StructuredFieldReader structuredFieldReader, CharacterSetOrientation[] characterSetOrientationArray, double d) throws IOException {
        byte[] byArray = structuredFieldReader.getNext(FONT_POSITION_SF);
        int n = 0;
        byte[] byArray2 = new byte[26];
        int n2 = 0;
        for (int i = 3; i < byArray.length; ++i) {
            if (n < 22) {
                byArray2[n] = byArray[i];
                if (n == 9) {
                    CharacterSetOrientation characterSetOrientation = characterSetOrientationArray[n2];
                    int n3 = CharacterSetBuilder.getSBIN(byArray2, 2);
                    int n4 = CharacterSetBuilder.getSBIN(byArray2, 4);
                    int n5 = CharacterSetBuilder.getSBIN(byArray2, 6);
                    int n6 = CharacterSetBuilder.getSBIN(byArray2, 8);
                    characterSetOrientation.setXHeight((int)Math.round((double)n3 * d));
                    characterSetOrientation.setCapHeight((int)Math.round((double)n4 * d));
                    characterSetOrientation.setAscender((int)Math.round((double)n5 * d));
                    characterSetOrientation.setDescender((int)Math.round((double)(n6 *= -1) * d));
                }
            } else if (n == 22) {
                n = 0;
                ++n2;
                byArray2[n] = byArray[i];
            }
            ++n;
        }
    }

    protected void processFontIndex(StructuredFieldReader structuredFieldReader, CharacterSetOrientation characterSetOrientation, Map<String, String> map, double d) throws IOException {
        byte[] byArray = structuredFieldReader.getNext(FONT_INDEX_SF);
        int n = 0;
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[20];
        char c = '\u00ff';
        char c2 = '\u0000';
        String string = null;
        for (int i = 3; i < byArray.length; ++i) {
            double d2;
            int n2;
            int n3;
            if (n < 8) {
                byArray2[n] = byArray[i];
                ++n;
                continue;
            }
            if (n < 27) {
                byArray3[n - 8] = byArray[i];
                ++n;
                continue;
            }
            if (n != 27) continue;
            byArray3[n - 8] = byArray[i];
            n = 0;
            String string2 = new String(byArray2, "Cp1146");
            String string3 = map.get(string2);
            if (string3 == null) continue;
            char c3 = string3.charAt(0);
            int n4 = CharacterSetBuilder.getUBIN(byArray3, 0);
            int n5 = CharacterSetBuilder.getSBIN(byArray3, 10);
            int n6 = n5 + (n3 = CharacterSetBuilder.getUBIN(byArray3, 12)) + (n2 = CharacterSetBuilder.getSBIN(byArray3, 14));
            int n7 = Math.abs(n6 - n4);
            if (n7 != 0 && n4 != 0 && (d2 = (double)(100 * n7) / (double)n4) > 2.0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(string2 + ": " + n5 + " + " + n3 + " + " + n2 + " = " + (n5 + n3 + n2) + " but found: " + n4));
                }
                if (string == null) {
                    string = string2;
                }
            }
            if (c3 < c) {
                c = c3;
            }
            if (c3 > c2) {
                c2 = c3;
            }
            int n8 = (int)Math.round((double)n4 * d);
            characterSetOrientation.setWidth(c3, n8);
        }
        characterSetOrientation.setFirstChar(c);
        characterSetOrientation.setLastChar(c2);
        if (LOG.isDebugEnabled() && string != null) {
            LOG.debug((Object)("Font has metrics inconsitencies where A+B+C doesn't equal the character increment. The first such character found: " + string));
        }
    }

    private static int getUBIN(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    private static int getSBIN(byte[] byArray, int n) {
        int n2 = ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
        if ((n2 & 0x8000) != 0) {
            return n2 | 0xFFFF0000;
        }
        return n2;
    }

    private static int determineOrientation(byte by) {
        int n = 0;
        switch (by) {
            case 0: {
                n = 0;
                break;
            }
            case 45: {
                n = 90;
                break;
            }
            case 90: {
                n = 180;
                break;
            }
            case -121: {
                n = 270;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid orientation: " + by);
            }
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DoubleByteLoader
    extends CharacterSetBuilder {
        private static final DoubleByteLoader INSTANCE = new DoubleByteLoader();

        private DoubleByteLoader() {
        }

        static DoubleByteLoader getInstance() {
            return INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Map<String, String> loadCodePage(String string, String string2, ResourceAccessor resourceAccessor, AFPEventProducer aFPEventProducer) throws IOException {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            InputStream inputStream = null;
            try {
                byte[] byArray;
                inputStream = this.openInputStream(resourceAccessor, string.trim(), aFPEventProducer);
                StructuredFieldReader structuredFieldReader = new StructuredFieldReader(inputStream);
                while ((byArray = structuredFieldReader.getNext(CHARACTER_TABLE_SF)) != null) {
                    int n = 0;
                    byte[] byArray2 = new byte[8];
                    byte[] byArray3 = new byte[2];
                    for (int i = 3; i < byArray.length; ++i) {
                        if (n < 8) {
                            byArray2[n] = byArray[i];
                            ++n;
                            continue;
                        }
                        if (n == 9) {
                            byArray3[0] = byArray[i];
                            ++n;
                            continue;
                        }
                        if (n == 10) {
                            n = 0;
                            byArray3[1] = byArray[i];
                            String string3 = new String(byArray2, "Cp1146");
                            String string4 = new String(byArray3, string2);
                            hashMap.put(string3, string4);
                            continue;
                        }
                        ++n;
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    aFPEventProducer.codePageNotFound(this, fileNotFoundException);
                }
                catch (Throwable throwable) {
                    this.closeInputStream(inputStream);
                    throw throwable;
                }
                this.closeInputStream(inputStream);
            }
            this.closeInputStream(inputStream);
            return hashMap;
        }
    }

    private static final class SingleByteLoader
    extends CharacterSetBuilder {
        private static final SingleByteLoader INSTANCE = new SingleByteLoader();

        private SingleByteLoader() {
        }

        private static SingleByteLoader getInstance() {
            return INSTANCE;
        }
    }

    private static class FontDescriptor {
        private byte[] data;

        public FontDescriptor(byte[] byArray) {
            this.data = byArray;
        }

        public int getNominalFontSizeInMillipoints() {
            int n = 100 * CharacterSetBuilder.getUBIN(this.data, 39);
            return n;
        }
    }

    private class FontControl {
        private int dpi;
        private int unitsPerEm;
        private boolean isRelative = false;

        private FontControl() {
        }

        public int getDpi() {
            return this.dpi;
        }

        public void setDpi(int n) {
            this.dpi = n;
        }

        public int getUnitsPerEm() {
            return this.unitsPerEm;
        }

        public void setUnitsPerEm(int n) {
            this.unitsPerEm = n;
        }

        public boolean isRelative() {
            return this.isRelative;
        }

        public void setRelative(boolean bl) {
            this.isRelative = bl;
        }
    }
}

