/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.FopCharacterSet;
import org.apache.fop.afp.fonts.RasterFont;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.base14.Courier;
import org.apache.fop.fonts.base14.CourierBold;
import org.apache.fop.fonts.base14.CourierBoldOblique;
import org.apache.fop.fonts.base14.CourierOblique;
import org.apache.fop.fonts.base14.Helvetica;
import org.apache.fop.fonts.base14.HelveticaBold;
import org.apache.fop.fonts.base14.HelveticaOblique;
import org.apache.fop.fonts.base14.TimesBold;
import org.apache.fop.fonts.base14.TimesBoldItalic;
import org.apache.fop.fonts.base14.TimesItalic;
import org.apache.fop.fonts.base14.TimesRoman;

public class AFPBase12FontCollection
implements FontCollection {
    private final AFPEventProducer eventProducer;
    private static final int[] RASTER_SIZES = new int[]{6, 7, 8, 9, 10, 11, 12, 14, 16, 18, 20, 24, 30, 36};
    private static final String[] CHARSET_REF = new String[]{"60", "70", "80", "90", "00", "A0", "B0", "D0", "F0", "H0", "J0", "N0", "T0", "Z0"};

    public AFPBase12FontCollection(AFPEventProducer aFPEventProducer) {
        this.eventProducer = aFPEventProducer;
    }

    private void addCharacterSet(RasterFont rasterFont, String string, Base14Font base14Font) {
        for (int i = 0; i < RASTER_SIZES.length; ++i) {
            int n = RASTER_SIZES[i] * 1000;
            FopCharacterSet fopCharacterSet = new FopCharacterSet("T1V10500", "Cp500", string + CHARSET_REF[i], base14Font, this.eventProducer);
            rasterFont.addCharacterSet(n, fopCharacterSet);
        }
    }

    private int addFontProperties(FontInfo fontInfo, AFPFont aFPFont, String[] stringArray, String string, int n, int n2) {
        String string2 = "F" + n2;
        fontInfo.addMetrics(string2, aFPFont);
        fontInfo.addFontProperties(string2, stringArray, string, n);
        return ++n2;
    }

    public int setup(int n, FontInfo fontInfo) {
        int n2 = n;
        RasterFont rasterFont = null;
        String[] stringArray = new String[]{"Helvetica", "Arial", "sans-serif"};
        rasterFont = this.createReferencedRasterFont("Helvetica");
        this.addCharacterSet(rasterFont, "C0H200", new Helvetica());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray, "normal", 400, n2);
        rasterFont = this.createReferencedRasterFont("Helvetica Italic");
        this.addCharacterSet(rasterFont, "C0H300", new HelveticaOblique());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray, "italic", 400, n2);
        rasterFont = this.createReferencedRasterFont("Helvetica (Semi) Bold");
        this.addCharacterSet(rasterFont, "C0H400", new HelveticaBold());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray, "normal", 700, n2);
        rasterFont = this.createReferencedRasterFont("Helvetica Italic (Semi) Bold");
        this.addCharacterSet(rasterFont, "C0H500", new HelveticaOblique());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray, "italic", 700, n2);
        String[] stringArray2 = new String[]{"Times", "TimesRoman", "Times Roman", "Times-Roman", "Times New Roman", "TimesNewRoman", "serif", "any"};
        rasterFont = this.createReferencedRasterFont("Times Roman");
        this.addCharacterSet(rasterFont, "C0N200", new TimesRoman());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray2, "normal", 400, n2);
        rasterFont = this.createReferencedRasterFont("Times Roman Italic");
        this.addCharacterSet(rasterFont, "C0N300", new TimesItalic());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray2, "italic", 400, n2);
        rasterFont = this.createReferencedRasterFont("Times Roman Bold");
        this.addCharacterSet(rasterFont, "C0N400", new TimesBold());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray2, "normal", 700, n2);
        rasterFont = this.createReferencedRasterFont("Times Roman Italic Bold");
        this.addCharacterSet(rasterFont, "C0N500", new TimesBoldItalic());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray2, "italic", 700, n2);
        String[] stringArray3 = new String[]{"Courier", "monospace"};
        rasterFont = this.createReferencedRasterFont("Courier");
        this.addCharacterSet(rasterFont, "C04200", new Courier());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray3, "normal", 400, n2);
        rasterFont = this.createReferencedRasterFont("Courier Italic");
        this.addCharacterSet(rasterFont, "C04300", new CourierOblique());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray3, "italic", 400, n2);
        rasterFont = this.createReferencedRasterFont("Courier Bold");
        this.addCharacterSet(rasterFont, "C04400", new CourierBold());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray3, "normal", 700, n2);
        rasterFont = this.createReferencedRasterFont("Courier Italic Bold");
        this.addCharacterSet(rasterFont, "C04500", new CourierBoldOblique());
        n2 = this.addFontProperties(fontInfo, rasterFont, stringArray3, "italic", 700, n2);
        return n2;
    }

    private RasterFont createReferencedRasterFont(String string) {
        RasterFont rasterFont = new RasterFont(string);
        rasterFont.setEmbeddable(false);
        return rasterFont;
    }
}

