/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.accessibility;

import java.util.Locale;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class StructureTree2SAXEventAdapter
implements StructureTreeEventHandler {
    private final ContentHandler contentHandler;

    private StructureTree2SAXEventAdapter(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public static StructureTreeEventHandler newInstance(ContentHandler contentHandler) {
        return new StructureTree2SAXEventAdapter(contentHandler);
    }

    public void startPageSequence(Locale locale, String string) {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            if (string != null) {
                attributesImpl.addAttribute("", "type", "type", "CDATA", string);
            }
            this.contentHandler.startPrefixMapping("foi", "http://xmlgraphics.apache.org/fop/internal");
            this.contentHandler.startPrefixMapping("fox", "http://xmlgraphics.apache.org/fop/extensions");
            this.contentHandler.startElement("http://xmlgraphics.apache.org/fop/intermediate", "structure-tree", "structure-tree", attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    public void endPageSequence() {
        try {
            this.contentHandler.endElement("http://xmlgraphics.apache.org/fop/intermediate", "structure-tree", "structure-tree");
            this.contentHandler.endPrefixMapping("fox");
            this.contentHandler.endPrefixMapping("foi");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    public StructureTreeElement startNode(String string, Attributes attributes) {
        try {
            if (string.equals("#PCDATA")) {
                string = "marked-content";
                this.contentHandler.startElement("http://xmlgraphics.apache.org/fop/intermediate", string, string, attributes);
            } else {
                this.contentHandler.startElement("http://www.w3.org/1999/XSL/Format", string, "fo:" + string, attributes);
            }
            return null;
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    public void endNode(String string) {
        try {
            this.contentHandler.endElement("http://www.w3.org/1999/XSL/Format", string, "fo:" + string);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException);
        }
    }

    public StructureTreeElement startImageNode(String string, Attributes attributes) {
        return this.startNode(string, attributes);
    }

    public StructureTreeElement startReferencedNode(String string, Attributes attributes) {
        return this.startNode(string, attributes);
    }
}

