/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.worker;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedAuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.service.PersistenceDirException;
import com.mathworks.toolbox.distcomp.service.PersistentServiceConfiguration;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.distcomp.worker.PackageInfo;
import com.mathworks.toolbox.distcomp.worker.sessiontracking.LifecycleReporter;
import com.mathworks.toolbox.distcomp.workunit.JobAndTaskIdentifier;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;

public class PersistentWorkerConfiguration
extends PersistentServiceConfiguration {
    private String fJobManagerName;
    private String fJobManagerHostName;
    private long fMaxWaitBeforeShutdownMillis;
    private long fLookupServiceQueryIntervalMillis;
    private JobManagerProxy fJobManagerProxy;
    private JobAndTaskIdentifier fLastJobAndTask = null;
    private transient JobAndTaskIdentifier fCurrentJobAndTask = null;
    private transient EncryptedAuthenticationToken fCurrentTaskAuthenticationToken;
    private String fTaskEvaluator;
    private String fMatlabExecutable;
    private String fMatlabOutputFile = null;
    private String fMatlabLogFile;
    private transient Handler fMatlabHandler = null;
    private String[] fMatlabArguments;
    private String[] fMatlabEnvironment;
    private long fMatlabStartupTimeoutMillis;
    private String fWindowsDomain;
    private transient LifecycleReporter fLifecycleReporter = null;
    private transient long fWorkerLifecycleHeartBeatSeconds;
    private transient long fTaskLifecycleHeartBeatSeconds;
    private boolean fUseMatlabOnDemand;
    private long fIdleMatlabKillTimeoutInSeconds;

    public PersistentWorkerConfiguration(Configuration configuration, String string) throws ConfigurationException, PersistenceDirException {
        super(configuration, string);
        if (this.fMatlabHandler == null) {
            this.fMatlabHandler = (Handler)configuration.getEntry(string, "matlabHandler", Handler.class);
            Level level = DistcompLevel.getLevelFromValue((int)this.getLogLevel());
            this.fMatlabHandler.setLevel(level);
        }
        if (this.fMatlabOutputFile == null) {
            this.initMatlabOutputFile(configuration, string);
        }
        if (this.fLastJobAndTask == null) {
            this.fLastJobAndTask = new JobAndTaskIdentifier();
        }
        if (this.fCurrentJobAndTask == null) {
            this.fCurrentJobAndTask = new JobAndTaskIdentifier();
        }
        if (this.fLifecycleReporter == null) {
            this.initLifecycleReporter(configuration, string);
        }
    }

    @Override
    public synchronized void recover(InputStream inputStream) throws Exception {
        super.recover(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.fJobManagerName = (String)objectInputStream.readObject();
        this.fJobManagerHostName = (String)objectInputStream.readObject();
        this.fLookupServiceQueryIntervalMillis = (Long)objectInputStream.readObject();
        this.fMaxWaitBeforeShutdownMillis = (Long)objectInputStream.readObject();
        this.fJobManagerProxy = (JobManagerProxy)objectInputStream.readObject();
        this.fLastJobAndTask = (JobAndTaskIdentifier)objectInputStream.readObject();
        this.fTaskEvaluator = (String)objectInputStream.readObject();
        this.fMatlabExecutable = (String)objectInputStream.readObject();
        this.fMatlabLogFile = (String)objectInputStream.readObject();
        this.fMatlabArguments = (String[])objectInputStream.readObject();
        this.fMatlabEnvironment = (String[])objectInputStream.readObject();
        this.fMatlabStartupTimeoutMillis = (Long)objectInputStream.readObject();
        this.fWindowsDomain = (String)objectInputStream.readObject();
        this.fUseMatlabOnDemand = (Boolean)objectInputStream.readObject();
        this.fIdleMatlabKillTimeoutInSeconds = (Long)objectInputStream.readObject();
    }

    @Override
    public synchronized void snapshot(OutputStream outputStream) throws Exception {
        super.snapshot(outputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this.fJobManagerName);
        objectOutputStream.writeObject(this.fJobManagerHostName);
        objectOutputStream.writeObject(this.fLookupServiceQueryIntervalMillis);
        objectOutputStream.writeObject(this.fMaxWaitBeforeShutdownMillis);
        objectOutputStream.writeObject(this.fJobManagerProxy);
        objectOutputStream.writeObject(this.fLastJobAndTask);
        objectOutputStream.writeObject(this.fTaskEvaluator);
        objectOutputStream.writeObject(this.fMatlabExecutable);
        objectOutputStream.writeObject(this.fMatlabLogFile);
        objectOutputStream.writeObject(this.fMatlabArguments);
        objectOutputStream.writeObject(this.fMatlabEnvironment);
        objectOutputStream.writeObject(this.fMatlabStartupTimeoutMillis);
        objectOutputStream.writeObject(this.fWindowsDomain);
        objectOutputStream.writeObject(this.fUseMatlabOnDemand);
        objectOutputStream.writeObject(this.fIdleMatlabKillTimeoutInSeconds);
        objectOutputStream.flush();
    }

    synchronized long getMaxWaitBeforeShutdownMillis() {
        return this.fMaxWaitBeforeShutdownMillis;
    }

    synchronized long getLookupServiceQueryIntervalMillis() {
        return this.fLookupServiceQueryIntervalMillis;
    }

    synchronized JobManagerProxy getJobManagerProxy() {
        return this.fJobManagerProxy;
    }

    synchronized void setJobManagerProxy(JobManagerProxy jobManagerProxy) throws PersistenceDirException {
        this.fJobManagerProxy = jobManagerProxy;
        this.snapshot();
    }

    synchronized JobAndTaskIdentifier getLastJobAndTask() {
        return this.fLastJobAndTask;
    }

    synchronized JobAndTaskIdentifier getCurrentJobAndTask() {
        return this.fCurrentJobAndTask;
    }

    synchronized void setCurrentTaskInformation(JobAndTaskIdentifier jobAndTaskIdentifier, AuthenticationToken authenticationToken) {
        PackageInfo.LOGGER.info("Setting current task information: " + jobAndTaskIdentifier + ", AuthenticationToken:" + authenticationToken);
        this.fCurrentJobAndTask = jobAndTaskIdentifier;
        this.fCurrentTaskAuthenticationToken = authenticationToken == null ? null : authenticationToken.prepare();
    }

    synchronized JobAndTaskIdentifier[] getCurrentAndLastJobsAndTasks() {
        return new JobAndTaskIdentifier[]{this.fCurrentJobAndTask, this.fLastJobAndTask};
    }

    synchronized AuthenticationToken getCurrentTaskAuthenticationToken() {
        return this.fCurrentTaskAuthenticationToken.unpack();
    }

    synchronized UserIdentity getCurrentTaskUserIdentity() {
        if (this.fCurrentTaskAuthenticationToken == null) {
            return null;
        }
        return this.fCurrentTaskAuthenticationToken.getUserIdentity();
    }

    synchronized void setCurrentAndLastTaskInformation(JobAndTaskIdentifier jobAndTaskIdentifier, AuthenticationToken authenticationToken, JobAndTaskIdentifier jobAndTaskIdentifier2) throws PersistenceDirException {
        this.setCurrentTaskInformation(jobAndTaskIdentifier, authenticationToken);
        this.fLastJobAndTask = jobAndTaskIdentifier2;
        this.snapshot();
    }

    public synchronized File getTaskRootDirectory() {
        return new File(this.getPersistenceDirectory(), PersistentWorkerConfiguration.getSubDirForRootDir());
    }

    public synchronized File getFileDependencyDir() {
        return new File(this.getTaskRootDirectory(), PersistentWorkerConfiguration.getSubDirForFileDependency());
    }

    public synchronized File getWorkerDir() {
        return new File(this.getTaskRootDirectory(), PersistentWorkerConfiguration.getSubDirForWork());
    }

    synchronized String getJobManagerName() {
        return this.fJobManagerName;
    }

    synchronized String getJobManagerHostName() {
        return this.fJobManagerHostName;
    }

    synchronized String getTaskEvaluator() {
        return this.fTaskEvaluator;
    }

    public synchronized String getMatlabExecutable() {
        return this.fMatlabExecutable;
    }

    public synchronized String getMatlabLogFile() {
        return this.fMatlabLogFile;
    }

    public synchronized Handler getMatlabHandler() {
        return this.fMatlabHandler;
    }

    @Override
    public synchronized void setLogLevel(int n) throws PersistenceDirException {
        Level level = DistcompLevel.getLevelFromValue((int)n);
        this.fMatlabHandler.setLevel(level);
        super.setLogLevel(n);
    }

    public synchronized String getMatlabOutputFile() {
        return this.fMatlabOutputFile;
    }

    public synchronized String[] getMatlabArguments() {
        return (String[])this.fMatlabArguments.clone();
    }

    public synchronized String[] getMatlabEnvironment() {
        return (String[])this.fMatlabEnvironment.clone();
    }

    public synchronized long getMatlabStartupTimeoutMillis() {
        return this.fMatlabStartupTimeoutMillis;
    }

    public synchronized String getWindowsDomain() {
        return this.fWindowsDomain;
    }

    public synchronized boolean getUseMatlabOnDemand() {
        return this.fUseMatlabOnDemand;
    }

    public synchronized long getIdleKillTimeoutInSeconds() {
        return this.fIdleMatlabKillTimeoutInSeconds;
    }

    synchronized LifecycleReporter getLifecycleReporter() {
        return this.fLifecycleReporter;
    }

    synchronized long getWorkerLifecycleHeartBeatSeconds() {
        return this.fWorkerLifecycleHeartBeatSeconds;
    }

    synchronized long getTaskLifecycleHeartBeatSeconds() {
        return this.fTaskLifecycleHeartBeatSeconds;
    }

    @Override
    protected void initServiceInfo(Configuration configuration, String string) throws ConfigurationException {
        try {
            super.initServiceInfo(configuration, string);
            this.fJobManagerName = (String)configuration.getEntry(string, "jobManagerName", String.class);
            this.fJobManagerHostName = (String)configuration.getEntry(string, "lookupHosts", String.class);
            this.fLookupServiceQueryIntervalMillis = (Long)configuration.getEntry(string, "lookupServiceQueryIntervalSecs", Long.TYPE) * 1000L;
            this.fMaxWaitBeforeShutdownMillis = (Long)configuration.getEntry(string, "maxWaitBeforeShutdownSecs", Long.TYPE) * 1000L;
            this.fTaskEvaluator = (String)configuration.getEntry(string, "taskEvaluator", String.class);
            this.fMatlabExecutable = (String)configuration.getEntry(string, "matlabExecutable", String.class);
            this.initMatlabOutputFile(configuration, string);
            this.fMatlabLogFile = (String)configuration.getEntry(string, "matlabLogFilePattern", String.class);
            this.fMatlabArguments = (String[])configuration.getEntry(string, "matlabArguments", String[].class);
            this.fMatlabEnvironment = (String[])configuration.getEntry(string, "matlabEnvironment", String[].class);
            this.fMatlabStartupTimeoutMillis = (Long)configuration.getEntry(string, "matlabStartupTimeoutSecs", Long.TYPE) * 1000L;
            this.fWindowsDomain = (String)configuration.getEntry(string, "windowsDomain", String.class);
            this.fUseMatlabOnDemand = Boolean.valueOf((String)configuration.getEntry(string, "onDemand", String.class));
            this.fIdleMatlabKillTimeoutInSeconds = (Long)configuration.getEntry(string, "idleKillTimeoutInSeconds", Long.TYPE);
            this.initLifecycleReporter(configuration, string);
        }
        catch (ConfigurationException configurationException) {
            throw new WorkerConfigException((BaseMsgID)new mjs.InvalidWorkerConfig(), configurationException);
        }
    }

    private void initMatlabOutputFile(Configuration configuration, String string) throws ConfigurationException {
        this.fMatlabOutputFile = (String)configuration.getEntry(string, "matlabOutputFile", String.class);
    }

    private void initLifecycleReporter(Configuration configuration, String string) throws ConfigurationException {
        String string2 = (String)configuration.getEntry(string, "lifecycleReporter", String.class);
        try {
            Class<?> clazz = Class.forName(string2);
            this.fLifecycleReporter = (LifecycleReporter)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WorkerConfigException((BaseMsgID)new mjs.NoLifecycleReporter(string2), classNotFoundException);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new WorkerConfigException((BaseMsgID)new mjs.LifecycleReporterInstantiationFailed(string2), reflectiveOperationException);
        }
        catch (ClassCastException classCastException) {
            throw new WorkerConfigException((BaseMsgID)new mjs.LifecycleReporterCastFailed(string2), classCastException);
        }
        this.fWorkerLifecycleHeartBeatSeconds = (Long)configuration.getEntry(string, "workerLifecycleHeartBeatSeconds", Long.TYPE);
        this.fTaskLifecycleHeartBeatSeconds = (Long)configuration.getEntry(string, "taskLifecycleHeartBeatSeconds", Long.TYPE);
    }

    public static String getSubDirForRootDir() {
        return "matlab";
    }

    public static String getSubDirForFileDependency() {
        return "filedependencies";
    }

    public static String getSubDirForWork() {
        return "work";
    }

    private static class WorkerConfigException
    extends ConfigurationException
    implements I18nMatlabIdentifiedException {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();
        private final BaseMsgID fMessageID;

        private WorkerConfigException(BaseMsgID baseMsgID, Throwable throwable) {
            super("", throwable);
            this.fMessageID = baseMsgID;
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.fMessageID);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.fMessageID);
        }

        public String getMessageID() {
            return this.fMessageID.getCatalogId() + ":" + this.fMessageID.getMessageId();
        }
    }
}

