/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import java.util.LinkedList;

public class RWLock {
    private ThreadLocal fReadLocksByThread = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new Counter();
        }
    };
    private ThreadLocal fWriteLocksByThread = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new Counter();
        }
    };
    private int gCurrentReadLocks;
    private int gWaitingReaders;
    private int gCurrentWriteLocks;
    private final LinkedList<Object> gWaitingWriters = new LinkedList();

    public synchronized boolean haveReadLock() {
        return ((Counter)this.fReadLocksByThread.get()).getValue() > 0;
    }

    public synchronized boolean haveWriteLock() {
        return ((Counter)this.fWriteLocksByThread.get()).getValue() > 0;
    }

    public synchronized void getReadLock() {
        if (this.haveReadLock() || this.haveWriteLock() || this.gCurrentWriteLocks == 0 && this.gWaitingWriters.size() == 0) {
            ++this.gCurrentReadLocks;
            ((Counter)this.fReadLocksByThread.get()).increment();
        } else {
            ++this.gWaitingReaders;
            while (true) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            ((Counter)this.fReadLocksByThread.get()).increment();
        }
    }

    private synchronized void notifyReaders() {
        this.gCurrentReadLocks += this.gWaitingReaders;
        this.gWaitingReaders = 0;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWriteLock() {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            RWLock rWLock = this;
            synchronized (rWLock) {
                if (this.haveWriteLock() || this.gWaitingWriters.size() == 0 && this.gCurrentReadLocks == 0 && this.gCurrentWriteLocks == 0) {
                    ++this.gCurrentWriteLocks;
                    ((Counter)this.fWriteLocksByThread.get()).increment();
                    return;
                }
                this.gWaitingWriters.addLast(object);
            }
            while (true) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            rWLock = this;
            synchronized (rWLock) {
                ((Counter)this.fWriteLocksByThread.get()).increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void notifyNextWriter() {
        if (this.gWaitingWriters.size() > 0) {
            Object object;
            ++this.gCurrentWriteLocks;
            Object object2 = object = this.gWaitingWriters.removeFirst();
            synchronized (object2) {
                object.notify();
            }
        }
    }

    public synchronized void releaseReadLock() {
        if (!this.haveReadLock()) {
            return;
        }
        --this.gCurrentReadLocks;
        ((Counter)this.fReadLocksByThread.get()).decrement();
        if (this.haveWriteLock()) {
            return;
        }
        if (this.gCurrentReadLocks == 0) {
            this.notifyNextWriter();
        }
    }

    public synchronized void releaseWriteLock() {
        if (!this.haveWriteLock()) {
            return;
        }
        --this.gCurrentWriteLocks;
        ((Counter)this.fWriteLocksByThread.get()).decrement();
        if (this.gCurrentWriteLocks == 0) {
            if (this.gWaitingReaders > 0) {
                this.notifyReaders();
            } else {
                this.notifyNextWriter();
            }
        }
    }

    public static class NeedLockException
    extends Exception {
        public NeedLockException(String string) {
            super(string);
        }
    }

    private static class Counter {
        private int fCount = 0;

        private Counter() {
        }

        public void increment() {
            ++this.fCount;
        }

        public void decrement() {
            --this.fCount;
        }

        public int getValue() {
            return this.fCount;
        }
    }
}

