/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.util.PackageInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PathNotificationGateway {
    private List<Listener> fListenerList = Collections.synchronizedList(new LinkedList());
    private static PathNotificationGateway sInstance = null;

    private PathNotificationGateway() {
    }

    private void fireListeners(Notification notification, String string, String ... stringArray) {
        Listener[] listenerArray;
        String[] stringArray2 = new String[]{string};
        for (Listener listener : listenerArray = this.fListenerList.toArray(new Listener[0])) {
            try {
                switch (notification) {
                    case ADDPATH: {
                        assert (stringArray.length > 0) : "No where provided for addpath";
                        String string2 = stringArray[0];
                        listener.addpath(stringArray2, string2);
                        break;
                    }
                    case CD: {
                        listener.cd(string);
                        break;
                    }
                    case RMPATH: {
                        listener.rmpath(stringArray2);
                        break;
                    }
                    case CLEAR: {
                        listener.clear(stringArray2);
                    }
                }
            }
            catch (Throwable throwable) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to send notification to a PathNotification listener\nMessage was: " + throwable.getMessage());
            }
        }
    }

    private void fireListeners(Notification notification, String[] stringArray, String ... stringArray2) {
        Listener[] listenerArray;
        for (Listener listener : listenerArray = this.fListenerList.toArray(new Listener[0])) {
            try {
                switch (notification) {
                    case ADDPATH: {
                        assert (stringArray2.length > 0) : "No where provided for addpath";
                        String string = stringArray2[0];
                        listener.addpath(stringArray, string);
                        break;
                    }
                    case RMPATH: {
                        listener.rmpath(stringArray);
                        break;
                    }
                    case CLEAR: {
                        listener.clear(stringArray);
                    }
                }
            }
            catch (Throwable throwable) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to send notification to a PathNotification listener\nMessage was: " + throwable.getMessage());
            }
        }
    }

    private void iAddListener(Listener listener) {
        assert (!this.fListenerList.contains(listener)) : "fListenerList on PathNotificationGateway already contained the listener";
        this.fListenerList.add(listener);
    }

    private void iRemoveListener(Listener listener) {
        assert (this.fListenerList.contains(listener)) : "fListenerList on PathNotificationGateway didn't contain the listener";
        this.fListenerList.remove(listener);
    }

    public static void addListener(Listener listener) {
        PathNotificationGateway.getInstance().iAddListener(listener);
    }

    public static void removeListener(Listener listener) {
        PathNotificationGateway.getInstance().iRemoveListener(listener);
    }

    private static PathNotificationGateway getInstance() {
        if (sInstance == null) {
            sInstance = new PathNotificationGateway();
        }
        return sInstance;
    }

    public static void addpath(String string, String string2) {
        PathNotificationGateway.getInstance().fireListeners(Notification.ADDPATH, string, string2);
    }

    public static void cd(String string) {
        PathNotificationGateway.getInstance().fireListeners(Notification.CD, string, new String[0]);
    }

    public static void rmpath(String string) {
        PathNotificationGateway.getInstance().fireListeners(Notification.RMPATH, string, new String[0]);
    }

    public static void clear(String string) {
        PathNotificationGateway.getInstance().fireListeners(Notification.CLEAR, string, new String[0]);
    }

    public static void addpath(String[] stringArray, String string) {
        PathNotificationGateway.getInstance().fireListeners(Notification.ADDPATH, stringArray, string);
    }

    public static void rmpath(String[] stringArray) {
        PathNotificationGateway.getInstance().fireListeners(Notification.RMPATH, stringArray, new String[0]);
    }

    private static enum Notification {
        ADDPATH,
        CD,
        RMPATH,
        CLEAR;

    }

    public static interface Listener {
        public void addpath(String[] var1, String var2);

        public void rmpath(String[] var1);

        public void cd(String var1);

        public void clear(String[] var1);
    }
}

