/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.jobmanager.TestedJobManager;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.service.ServiceAccessor;
import com.mathworks.toolbox.distcomp.util.AllowAllSecurityManager;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;

public final class JobManagerFinder {
    private static final int MAX_FIND_ATTEMPTS = 20;
    private static final long PAUSE_BETWEEN_ATTEMPTS = 250L;
    private final String fJobManagerName;
    private final String fJobManagerLookupURL;

    public JobManagerFinder(String string, String string2) {
        this.fJobManagerName = string;
        this.fJobManagerLookupURL = string2;
    }

    public JobManagerLocal findJobManager(int n, long l) throws JobManagerFindException {
        for (int i = n; i > 0; --i) {
            TestedJobManager[] testedJobManagerArray;
            try {
                testedJobManagerArray = ServiceAccessor.getJobManagers(this.fJobManagerLookupURL, this.fJobManagerName);
            }
            catch (DistcompException | MJSException exception) {
                throw new JobManagerFindException((BaseMsgID)new mjs.CouldNotGetJMProxies(), (Throwable)exception);
            }
            for (TestedJobManager testedJobManager : testedJobManagerArray) {
                if (!testedJobManager.isOneWayCommunicationOk()) continue;
                return testedJobManager;
            }
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new JobManagerFindException((BaseMsgID)new mjs.CouldNotFindJobManager(this.fJobManagerName, this.fJobManagerLookupURL));
    }

    public JobManagerLocal findJobManager() throws JobManagerFindException {
        return this.findJobManager(20, 250L);
    }

    static {
        System.setSecurityManager(new AllowAllSecurityManager());
    }

    public static class JobManagerFindException
    extends Exception
    implements I18nMatlabIdentifiedException {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();
        private final BaseMsgID fMessageID;

        JobManagerFindException(BaseMsgID baseMsgID) {
            this.fMessageID = baseMsgID;
        }

        JobManagerFindException(BaseMsgID baseMsgID, Throwable throwable) {
            super(throwable);
            this.fMessageID = baseMsgID;
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.fMessageID);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.fMessageID);
        }

        public String getMessageID() {
            return this.fMessageID.getCatalogId() + ":" + this.fMessageID.getMessageId();
        }
    }
}

