/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import com.mathworks.toolbox.distcomp.ui.widget.GlassPaneTextContextMenu;
import com.mathworks.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class StringVectorView
extends ConfigurablePropertyView {
    private final JTextArea fStringVectorTextArea;
    private static final Dimension MIN_SCROLL_PANE_SIZE = new Dimension(250, 100);
    private static final Dimension MAX_SCROLL_PANE_SIZE = new Dimension(Integer.MAX_VALUE, 100);

    public StringVectorView(Property property, String string) {
        super(property);
        this.fStringVectorTextArea = this.createStringVectorTextArea(string);
        this.updateUI(this.getProperty().getValue());
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fStringVectorTextArea);
        mJScrollPane.setVerticalScrollBarPolicy(20);
        mJScrollPane.setHorizontalScrollBarPolicy(30);
        mJScrollPane.setMinimumSize(MIN_SCROLL_PANE_SIZE);
        mJScrollPane.setMaximumSize(MAX_SCROLL_PANE_SIZE);
        mJScrollPane.setPreferredSize(MIN_SCROLL_PANE_SIZE);
        JComponent jComponent = this.addUseDefaultOverlayDecorator((JComponent)mJScrollPane, string);
        this.addLine(jComponent, 8);
        if (this.getProperty().getPropertyInfo().hasDefaultString()) {
            this.addLine(this.createDefaultValueDecorator());
        }
    }

    public JTextArea getStringVectorTextArea() {
        return this.fStringVectorTextArea;
    }

    private JTextArea createStringVectorTextArea(String string) {
        MJTextArea mJTextArea = new MJTextArea();
        mJTextArea.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StringVectorView.this.commitEdit();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 2);
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>();
        hashSet.add(keyStroke);
        hashSet.add(keyStroke2);
        mJTextArea.setFocusTraversalKeys(0, hashSet);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(9, 1);
        HashSet<KeyStroke> hashSet2 = new HashSet<KeyStroke>();
        hashSet2.add(keyStroke3);
        mJTextArea.setFocusTraversalKeys(1, hashSet2);
        mJTextArea.addContextMenu((JPopupMenu)((Object)new GlassPaneTextContextMenu()));
        mJTextArea.setName(string);
        return mJTextArea;
    }

    @Override
    public void commitEdit() {
        Property property = this.getProperty();
        String string = this.fStringVectorTextArea.getText();
        String[] stringArray = null;
        if (string.length() != 0) {
            stringArray = StringUtils.stringToArray((String)this.fStringVectorTextArea.getText(), (String)"\n");
        }
        if (stringArray == null) {
            property.unsetValue();
        } else {
            property.setValue(stringArray);
        }
    }

    @Override
    public void updateUI(Object object) {
        if (object instanceof DefaultValue) {
            this.fStringVectorTextArea.setText("");
            return;
        }
        assert (object instanceof String[]) : "StringVectorView can only handle string arrays.";
        this.fStringVectorTextArea.setText(StringUtils.arrayToString((String[])((String[])object), (String)"\n"));
    }
}

