/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;

public class EnumView
extends ConfigurablePropertyView {
    private final JComboBox fEnumCombobox;
    private static final String USE_DEFAULT = sRes.getString("ConfigurableView.Common.UseDefaultLabel");

    public EnumView(Property property, String string) {
        super(property);
        this.fEnumCombobox = this.createComboBox(string);
        this.updateUI(this.getProperty().getValue());
        this.addLine(this.fEnumCombobox, 8);
        if (this.getProperty().getPropertyInfo().hasDefaultString()) {
            this.addLine(this.createDefaultValueDecorator());
        }
    }

    private JComboBox createComboBox(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(USE_DEFAULT);
        arrayList.addAll((List)this.getProperty().getPropertyInfo().getConstraint().getAdditionalInputs());
        MJComboBox mJComboBox = new MJComboBox(arrayList);
        int n = (int)mJComboBox.getPreferredSize().getHeight();
        mJComboBox.setMinimumSize(new Dimension(250, n));
        mJComboBox.setMaximumSize(new Dimension(250, n));
        mJComboBox.setSize(new Dimension(250, n));
        mJComboBox.setPreferredSize(new Dimension(250, n));
        mJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EnumView.this.commitEdit();
            }
        });
        mJComboBox.setName(string);
        return mJComboBox;
    }

    @Override
    public void commitEdit() {
        Property property = this.getProperty();
        if (this.fEnumCombobox.getSelectedItem().equals(USE_DEFAULT)) {
            property.unsetValue();
        } else {
            property.setValue(this.fEnumCombobox.getSelectedItem());
        }
    }

    @Override
    public void updateUI(Object object) {
        ActionListener[] actionListenerArray;
        for (ActionListener actionListener : actionListenerArray = this.fEnumCombobox.getActionListeners()) {
            this.fEnumCombobox.removeActionListener(actionListener);
        }
        if (object instanceof DefaultValue) {
            this.fEnumCombobox.setSelectedItem(USE_DEFAULT);
        } else {
            assert (object instanceof String) : "EnumView can only handle Strings.";
            this.fEnumCombobox.setSelectedItem(object);
        }
        for (ActionListener actionListener : actionListenerArray) {
            this.fEnumCombobox.addActionListener(actionListener);
        }
    }
}

